/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.binsearch.impl;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.archive.util.binsearch.AbstractSeekableLineReader;
import org.archive.util.binsearch.impl.NIOSeekableLineReaderFactory;

public class NIOSeekableLineReader
extends AbstractSeekableLineReader {
    private FileChannel fc;
    private long size;
    private FileChannelInputStream fcis;
    private ByteBufferBackedInputStream bbis;
    private NIOSeekableLineReaderFactory.NIOType type;

    public NIOSeekableLineReader(FileChannel fc, int blockSize, NIOSeekableLineReaderFactory.NIOType type) throws IOException {
        super(blockSize);
        this.fc = fc;
        this.type = type;
        this.size = fc.size();
        this.fcis = null;
        this.bbis = null;
    }

    @Override
    public InputStream doSeekLoad(long offset, int maxLength) throws IOException {
        if (this.type == NIOSeekableLineReaderFactory.NIOType.MMAP && maxLength >= 0) {
            MappedByteBuffer mapBuff = this.fc.map(FileChannel.MapMode.READ_ONLY, offset, maxLength);
            this.bbis = new ByteBufferBackedInputStream(mapBuff, offset);
            return ByteStreams.limit((InputStream)this.bbis, (long)maxLength);
        }
        this.fcis = new FileChannelInputStream(this.fc, offset, maxLength);
        return this.fcis;
    }

    public long getOffset() throws IOException {
        if (this.fcis != null) {
            return this.fcis.fcOffset;
        }
        if (this.bbis != null) {
            return this.bbis.position();
        }
        return 0L;
    }

    @Override
    public void doClose() throws IOException {
        this.fcis = null;
        this.bbis = null;
    }

    @Override
    public long getSize() throws IOException {
        return this.size;
    }

    public class FileChannelInputStream
    extends InputStream {
        FileChannel fc;
        long fcOffset;
        int remaining;
        boolean bounded;

        public FileChannelInputStream(FileChannel fc, long offset, int maxLength) {
            this.fc = fc;
            this.fcOffset = offset;
            this.remaining = maxLength;
            this.bounded = this.remaining > 0;
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            int amt = this.read(b, 0, 1);
            if (amt == -1) {
                return -1;
            }
            return b[0] & 0xFF;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            int amtRead;
            if (this.bounded) {
                this.remaining = Math.min(length, this.remaining);
            }
            ByteBuffer bb = ByteBuffer.wrap(buffer, offset, length);
            int totalRead = 0;
            while (length > 0 && (amtRead = this.fc.read(bb, this.fcOffset)) != -1) {
                totalRead += amtRead;
                this.fcOffset += (long)amtRead;
                length -= amtRead;
            }
            if (this.bounded) {
                this.remaining -= totalRead;
            }
            return totalRead == 0 ? -1 : totalRead;
        }

        @Override
        public int available() {
            return this.remaining;
        }
    }

    public static class ByteBufferBackedInputStream
    extends InputStream {
        ByteBuffer buf;
        long fcOffset;

        public ByteBufferBackedInputStream(ByteBuffer buf, long offset) {
            this.buf = buf;
            this.fcOffset = offset;
        }

        @Override
        public synchronized int read() throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            return this.buf.get() & 0xFF;
        }

        @Override
        public synchronized int read(byte[] bytes, int off, int len) throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            len = Math.min(len, this.buf.remaining());
            this.buf.get(bytes, off, len);
            return len;
        }

        public long position() {
            return this.fcOffset + (long)this.buf.position();
        }
    }
}

