/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import opennlp.tools.ml.model.AbstractDataIndexer;
import opennlp.tools.ml.model.ComparableEvent;
import opennlp.tools.ml.model.Event;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.ObjectStreamUtils;
import opennlp.tools.util.TrainingParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnePassDataIndexer
extends AbstractDataIndexer<TrainingParameters> {
    private static final Logger logger = LoggerFactory.getLogger(OnePassDataIndexer.class);

    public void index(ObjectStream<Event> eventStream) throws IOException {
        int cutoff = ((TrainingParameters)this.trainingParameters).getIntParameter("Cutoff", 5);
        boolean sort = ((TrainingParameters)this.trainingParameters).getBooleanParameter("sort", true);
        long start = System.currentTimeMillis();
        logger.info("Indexing events with OnePass using cutoff of {}", (Object)cutoff);
        logger.info("Computing event counts...");
        HashMap<String, Integer> predicateIndex = new HashMap<String, Integer>();
        List<Event> events = this.computeEventCounts(eventStream, predicateIndex, cutoff);
        logger.info("done. {} events", (Object)events.size());
        logger.info("Indexing...  ");
        List<ComparableEvent> eventsToCompare = this.index((ObjectStream<Event>)ObjectStreamUtils.createObjectStream(events), predicateIndex);
        logger.info("done.");
        logger.info("Sorting and merging events... ");
        this.sortAndMerge(eventsToCompare, sort);
        logger.info(String.format("Done indexing in %.2f s.", (double)(System.currentTimeMillis() - start) / 1000.0));
    }

    private List<Event> computeEventCounts(ObjectStream<Event> eventStream, Map<String, Integer> predicatesInOut, int cutoff) throws IOException {
        Event ev;
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        LinkedList<Event> events = new LinkedList<Event>();
        while ((ev = (Event)eventStream.read()) != null) {
            events.add(ev);
            OnePassDataIndexer.update(ev.getContext(), counter);
        }
        String[] predicateSet = (String[])counter.entrySet().stream().filter(entry -> (Integer)entry.getValue() >= cutoff).map(Map.Entry::getKey).sorted().toArray(String[]::new);
        this.predCounts = new int[predicateSet.length];
        for (int i = 0; i < predicateSet.length; ++i) {
            this.predCounts[i] = (Integer)counter.get(predicateSet[i]);
            predicatesInOut.put(predicateSet[i], i);
        }
        return events;
    }
}

