/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.configuration;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.time.Clock;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.apache.pulsar.common.util.ThreadDumpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/status.html")
public class VipStatus {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VipStatus.class);
    public static final String ATTRIBUTE_STATUS_FILE_PATH = "statusFilePath";
    public static final String ATTRIBUTE_IS_READY_PROBE = "isReadyProbe";
    private static final long LOG_THREADDUMP_INTERVAL_WHEN_DEADLOCK_DETECTED = 600000L;
    private static final long CHECK_STATUS_INTERVAL = 500L;
    private static volatile long lastCheckStatusTimestamp;
    private static volatile long lastPrintThreadDumpTimestamp;
    private static volatile boolean lastCheckStatusResult;
    private long printThreadDumpIntervalMs;
    private Clock clock;
    @Context
    protected ServletContext servletContext;

    public VipStatus() {
        this.clock = Clock.systemUTC();
        this.printThreadDumpIntervalMs = 600000L;
    }

    @VisibleForTesting
    public VipStatus(ServletContext servletContext, long printThreadDumpIntervalMs) {
        this.servletContext = servletContext;
        this.printThreadDumpIntervalMs = printThreadDumpIntervalMs;
        this.clock = Clock.systemUTC();
    }

    @VisibleForTesting
    static void reset() {
        lastCheckStatusTimestamp = 0L;
        lastPrintThreadDumpTimestamp = 0L;
        lastCheckStatusResult = false;
    }

    @GET
    public String checkStatus() {
        Class<VipStatus> clazz = VipStatus.class;
        synchronized (VipStatus.class) {
            boolean isReady;
            if (this.clock.millis() - lastCheckStatusTimestamp < 500L) {
                if (lastCheckStatusResult) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return "OK";
                }
                throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
            }
            lastCheckStatusTimestamp = this.clock.millis();
            String statusFilePath = (String)this.servletContext.getAttribute(ATTRIBUTE_STATUS_FILE_PATH);
            Supplier isReadyProbe = (Supplier)this.servletContext.getAttribute(ATTRIBUTE_IS_READY_PROBE);
            boolean bl = isReady = isReadyProbe != null ? (Boolean)isReadyProbe.get() : true;
            if (statusFilePath != null) {
                File statusFile = new File(statusFilePath);
                if (isReady && statusFile.exists() && statusFile.isFile()) {
                    ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
                    long[] threadIds = threadBean.findDeadlockedThreads();
                    if (threadIds != null && threadIds.length > 0) {
                        ThreadInfo[] threadInfos = threadBean.getThreadInfo(threadIds, false, false);
                        String threadNames = Arrays.stream(threadInfos).map(threadInfo -> threadInfo.getThreadName() + "(tid=" + threadInfo.getThreadId() + ")").collect(Collectors.joining(", "));
                        if (this.clock.millis() - lastPrintThreadDumpTimestamp > this.printThreadDumpIntervalMs) {
                            String diagnosticResult = ThreadDumpUtil.buildThreadDiagnosticString();
                            log.error("Deadlocked threads detected. {}. Service may be unavailable, thread stack details are as follows:\n{}", (Object)threadNames, (Object)diagnosticResult);
                            lastPrintThreadDumpTimestamp = this.clock.millis();
                        } else {
                            log.error("Deadlocked threads detected. {}", (Object)threadNames);
                        }
                        lastCheckStatusResult = false;
                        throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
                    }
                    lastCheckStatusResult = true;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return "OK";
                }
            }
            lastCheckStatusResult = false;
            log.warn("Status file '{}' doesn't exist or ready probe value ({}) isn't true. The service is not ready", (Object)statusFilePath, (Object)isReady);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }
}

