/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.Policies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DispatchRateLimiter {
    protected final PersistentTopic topic;
    protected final String topicName;
    protected final String subscriptionName;
    protected final Type type;
    protected final BrokerService brokerService;
    private static final Logger log = LoggerFactory.getLogger(DispatchRateLimiter.class);

    protected DispatchRateLimiter(PersistentTopic topic, String subscriptionName, Type type) {
        this.topic = topic;
        this.topicName = topic.getName();
        this.subscriptionName = subscriptionName;
        this.brokerService = topic.getBrokerService();
        this.type = type;
        this.updateDispatchRate();
    }

    protected DispatchRateLimiter(BrokerService brokerService) {
        this.topic = null;
        this.topicName = null;
        this.subscriptionName = null;
        this.brokerService = brokerService;
        this.type = Type.BROKER;
        this.updateDispatchRate();
    }

    public abstract long getAvailableDispatchRateLimitOnMsg();

    public abstract long getAvailableDispatchRateLimitOnByte();

    public abstract void consumeDispatchQuota(long var1, long var3);

    public abstract boolean isDispatchRateLimitingEnabled();

    private DispatchRate createDispatchRate() {
        int dispatchThrottlingRateInMsg;
        ServiceConfiguration config = this.brokerService.pulsar().getConfiguration();
        return DispatchRate.builder().dispatchThrottlingRateInMsg(dispatchThrottlingRateInMsg).dispatchThrottlingRateInByte(switch (this.type.ordinal()) {
            case 0 -> {
                dispatchThrottlingRateInMsg = config.getDispatchThrottlingRatePerTopicInMsg();
                yield config.getDispatchThrottlingRatePerTopicInByte();
            }
            case 1 -> {
                dispatchThrottlingRateInMsg = config.getDispatchThrottlingRatePerSubscriptionInMsg();
                yield config.getDispatchThrottlingRatePerSubscriptionInByte();
            }
            case 2 -> {
                dispatchThrottlingRateInMsg = config.getDispatchThrottlingRatePerReplicatorInMsg();
                yield config.getDispatchThrottlingRatePerReplicatorInByte();
            }
            case 3 -> {
                dispatchThrottlingRateInMsg = config.getDispatchThrottlingRateInMsg();
                yield config.getDispatchThrottlingRateInByte();
            }
            default -> {
                dispatchThrottlingRateInMsg = -1;
                yield -1L;
            }
        }).ratePeriodInSecond(1).relativeToPublishRate(this.type != Type.BROKER && config.isDispatchThrottlingRateRelativeToPublishRate()).build();
    }

    public final void updateDispatchRate() {
        DispatchRate dispatchRate;
        switch (this.type.ordinal()) {
            case 0: {
                dispatchRate = this.topic.getDispatchRate();
                break;
            }
            case 1: {
                dispatchRate = this.topic.getSubscriptionDispatchRate(this.subscriptionName);
                break;
            }
            case 2: {
                dispatchRate = this.topic.getReplicatorDispatchRate();
                break;
            }
            case 3: {
                dispatchRate = this.createDispatchRate();
                break;
            }
            default: {
                log.warn("ignore configured dispatch rate for type {}", (Object)this.type);
                return;
            }
        }
        if (this.type == Type.BROKER) {
            log.info("configured broker message-dispatch rate {}", (Object)dispatchRate);
        } else {
            log.info("[{}] configured {} message-dispatch rate at broker {} subscriptionName [{}]", new Object[]{this.topicName, this.type, this.subscriptionName == null ? "null" : this.subscriptionName, dispatchRate});
        }
        this.updateDispatchRate(dispatchRate);
    }

    public static CompletableFuture<Optional<Policies>> getPoliciesAsync(BrokerService brokerService, String topicName) {
        NamespaceName namespace = TopicName.get((String)topicName).getNamespaceObject();
        return brokerService.pulsar().getPulsarResources().getNamespaceResources().getPoliciesAsync(namespace);
    }

    @Deprecated
    public static Optional<Policies> getPolicies(BrokerService brokerService, String topicName) {
        NamespaceName namespace = TopicName.get((String)topicName).getNamespaceObject();
        return brokerService.pulsar().getPulsarResources().getNamespaceResources().getPoliciesIfCached(namespace);
    }

    public abstract void updateDispatchRate(DispatchRate var1);

    public abstract long getDispatchRateOnMsg();

    public abstract long getDispatchRateOnByte();

    public abstract void close();

    public static boolean isDispatchRateEnabled(DispatchRate dispatchRate) {
        return dispatchRate != null && (dispatchRate.getDispatchThrottlingRateInMsg() > 0 || dispatchRate.getDispatchThrottlingRateInByte() > 0L);
    }

    public static enum Type {
        TOPIC,
        SUBSCRIPTION,
        REPLICATOR,
        BROKER;

    }
}

