/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.collect.Streams;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedCursorAttributes;
import org.apache.bookkeeper.mledger.ManagedCursorMXBean;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;

public class OpenTelemetryManagedCursorStats
implements AutoCloseable {
    public static final String PERSIST_OPERATION_COUNTER = "pulsar.broker.managed_ledger.persist.operation.count";
    private final ObservableLongMeasurement persistOperationCounter;
    public static final String PERSIST_OPERATION_METADATA_STORE_COUNTER = "pulsar.broker.managed_ledger.persist.mds.operation.count";
    private final ObservableLongMeasurement persistOperationMetadataStoreCounter;
    public static final String NON_CONTIGUOUS_MESSAGE_RANGE_COUNTER = "pulsar.broker.managed_ledger.message_range.count";
    private final ObservableLongMeasurement nonContiguousMessageRangeCounter;
    public static final String OUTGOING_BYTE_COUNTER = "pulsar.broker.managed_ledger.cursor.outgoing.size";
    private final ObservableLongMeasurement outgoingByteCounter;
    public static final String OUTGOING_BYTE_LOGICAL_COUNTER = "pulsar.broker.managed_ledger.cursor.outgoing.logical.size";
    private final ObservableLongMeasurement outgoingByteLogicalCounter;
    public static final String INCOMING_BYTE_COUNTER = "pulsar.broker.managed_ledger.cursor.incoming.size";
    private final ObservableLongMeasurement incomingByteCounter;
    private final BatchCallback batchCallback;

    public OpenTelemetryManagedCursorStats(OpenTelemetry openTelemetry, ManagedLedgerFactoryImpl factory) {
        Meter meter = openTelemetry.getMeter("org.apache.pulsar.broker");
        this.persistOperationCounter = meter.counterBuilder(PERSIST_OPERATION_COUNTER).setUnit("{operation}").setDescription("The number of acknowledgment operations on the ledger.").buildObserver();
        this.persistOperationMetadataStoreCounter = meter.counterBuilder(PERSIST_OPERATION_METADATA_STORE_COUNTER).setUnit("{operation}").setDescription("The number of acknowledgment operations in the metadata store.").buildObserver();
        this.nonContiguousMessageRangeCounter = meter.upDownCounterBuilder(NON_CONTIGUOUS_MESSAGE_RANGE_COUNTER).setUnit("{range}").setDescription("The number of non-contiguous deleted messages ranges.").buildObserver();
        this.outgoingByteCounter = meter.counterBuilder(OUTGOING_BYTE_COUNTER).setUnit("{By}").setDescription("The total amount of data written to the ledger.").buildObserver();
        this.outgoingByteLogicalCounter = meter.counterBuilder(OUTGOING_BYTE_LOGICAL_COUNTER).setUnit("{By}").setDescription("The total amount of data written to the ledger, not including replicas.").buildObserver();
        this.incomingByteCounter = meter.counterBuilder(INCOMING_BYTE_COUNTER).setUnit("{By}").setDescription("The total amount of data read from the ledger.").buildObserver();
        this.batchCallback = meter.batchCallback(() -> factory.getManagedLedgers().values().stream().map(ManagedLedger::getCursors).flatMap(Streams::stream).forEach(this::recordMetrics), (ObservableMeasurement)this.persistOperationCounter, new ObservableMeasurement[]{this.persistOperationMetadataStoreCounter, this.nonContiguousMessageRangeCounter, this.outgoingByteCounter, this.outgoingByteLogicalCounter, this.incomingByteCounter});
    }

    @Override
    public void close() {
        this.batchCallback.close();
    }

    private void recordMetrics(ManagedCursor cursor) {
        ManagedCursorMXBean stats = cursor.getStats();
        ManagedCursorAttributes cursorAttributesSet = cursor.getManagedCursorAttributes();
        Attributes attributes = cursorAttributesSet.getAttributes();
        Attributes attributesSucceed = cursorAttributesSet.getAttributesOperationSucceed();
        Attributes attributesFailed = cursorAttributesSet.getAttributesOperationFailure();
        this.persistOperationCounter.record(stats.getPersistLedgerSucceed(), attributesSucceed);
        this.persistOperationCounter.record(stats.getPersistLedgerErrors(), attributesFailed);
        this.persistOperationMetadataStoreCounter.record(stats.getPersistZookeeperSucceed(), attributesSucceed);
        this.persistOperationMetadataStoreCounter.record(stats.getPersistZookeeperErrors(), attributesFailed);
        this.nonContiguousMessageRangeCounter.record((long)cursor.getTotalNonContiguousDeletedMessagesRange(), attributes);
        this.outgoingByteCounter.record(stats.getWriteCursorLedgerSize(), attributes);
        this.outgoingByteLogicalCounter.record(stats.getWriteCursorLedgerLogicalSize(), attributes);
        this.incomingByteCounter.record(stats.getReadCursorLedgerSize(), attributes);
    }
}

