/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl.cache;

import com.google.common.annotations.VisibleForTesting;
import io.opentelemetry.api.OpenTelemetry;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerFactoryConfig;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryMBeanImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.cache.EntryCache;
import org.apache.bookkeeper.mledger.impl.cache.EntryCacheDisabled;
import org.apache.bookkeeper.mledger.impl.cache.EntryCacheManager;
import org.apache.bookkeeper.mledger.impl.cache.EntryLengthFunction;
import org.apache.bookkeeper.mledger.impl.cache.InflightReadsLimiter;
import org.apache.bookkeeper.mledger.impl.cache.RangeCacheEntryWrapper;
import org.apache.bookkeeper.mledger.impl.cache.RangeCacheRemovalQueue;
import org.apache.bookkeeper.mledger.impl.cache.RangeEntryCacheImpl;
import org.apache.bookkeeper.mledger.impl.cache.RangeEntryCacheManagerEvictionHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeEntryCacheManagerImpl
implements EntryCacheManager {
    private volatile long maxSize;
    private volatile long evictionTriggerThreshold;
    private volatile double cacheEvictionWatermark;
    private final AtomicLong currentSize = new AtomicLong(0L);
    private final ConcurrentMap<String, EntryCache> caches = new ConcurrentHashMap<String, EntryCache>();
    private final RangeCacheRemovalQueue rangeCacheRemovalQueue;
    private final RangeEntryCacheManagerEvictionHandler evictionHandler;
    private final AtomicReference<CompletableFuture<Void>> evictionInProgress = new AtomicReference<Object>(null);
    private final ManagedLedgerFactoryImpl mlFactory;
    protected final ManagedLedgerFactoryMBeanImpl mlFactoryMBean;
    private final InflightReadsLimiter inflightReadsLimiter;
    protected static final double MB = 1048576.0;
    private static final double evictionTriggerThresholdPercent = 0.98;
    private volatile EntryLengthFunction entryLengthFunction = EntryLengthFunction.DEFAULT;
    private static final Logger log = LoggerFactory.getLogger(RangeEntryCacheManagerImpl.class);

    public RangeEntryCacheManagerImpl(ManagedLedgerFactoryImpl factory, OrderedScheduler scheduledExecutor, OpenTelemetry openTelemetry) {
        ManagedLedgerFactoryConfig config = factory.getConfig();
        this.maxSize = config.getMaxCacheSize();
        this.inflightReadsLimiter = new InflightReadsLimiter(config.getManagedLedgerMaxReadsInFlightSize(), config.getManagedLedgerMaxReadsInFlightPermitsAcquireQueueSize(), config.getManagedLedgerMaxReadsInFlightPermitsAcquireTimeoutMillis(), (ScheduledExecutorService)scheduledExecutor, openTelemetry);
        this.evictionTriggerThreshold = (long)((double)this.maxSize * 0.98);
        this.cacheEvictionWatermark = config.getCacheEvictionWatermark();
        this.mlFactory = factory;
        this.mlFactoryMBean = factory.getMbean();
        this.rangeCacheRemovalQueue = new RangeCacheRemovalQueue(config.getCacheEvictionExtendTTLOfEntriesWithRemainingExpectedReadsMaxTimes(), config.isCacheEvictionExtendTTLOfRecentlyAccessed());
        this.evictionHandler = new RangeEntryCacheManagerEvictionHandler(this, this.rangeCacheRemovalQueue);
        log.info("Initialized managed-ledger entry cache of {} Mb", (Object)((double)this.maxSize / 1048576.0));
    }

    @Override
    public EntryCache getEntryCache(ManagedLedger ml) {
        if (this.maxSize == 0L) {
            return new EntryCacheDisabled((ManagedLedgerImpl)ml);
        }
        RangeEntryCacheImpl newEntryCache = new RangeEntryCacheImpl(this, (ManagedLedgerImpl)ml, this.mlFactory.getConfig().isCopyEntriesInCache(), this.rangeCacheRemovalQueue, this.entryLengthFunction);
        EntryCache currentEntryCache = this.caches.putIfAbsent(ml.getName(), newEntryCache);
        if (currentEntryCache != null) {
            return currentEntryCache;
        }
        return newEntryCache;
    }

    @Override
    public void updateCacheSizeAndThreshold(long maxSize) {
        this.maxSize = maxSize;
        this.evictionTriggerThreshold = (long)((double)maxSize * 0.98);
    }

    @Override
    public void updateCacheEvictionWatermark(double cacheEvictionWatermark) {
        this.cacheEvictionWatermark = cacheEvictionWatermark;
    }

    @Override
    public void removeEntryCache(String name) {
        EntryCache entryCache = (EntryCache)this.caches.remove(name);
        if (entryCache == null) {
            return;
        }
        long size = entryCache.getSize();
        entryCache.clear();
        if (log.isDebugEnabled()) {
            log.debug("Removed cache for {} - Size: {} -- Current Size: {}", new Object[]{name, (double)size / 1048576.0, (double)this.currentSize.get() / 1048576.0});
        }
    }

    Optional<CompletableFuture<Void>> triggerEvictionWhenNeeded() {
        long currentSize = this.currentSize.get();
        if (currentSize > this.evictionTriggerThreshold) {
            CompletableFuture<Void> evictionCompletionFuture = null;
            while (evictionCompletionFuture == null) {
                evictionCompletionFuture = this.evictionInProgress.get();
                if (evictionCompletionFuture != null || (evictionCompletionFuture = this.evictionInProgress.updateAndGet(currentValue -> currentValue == null ? new CompletableFuture() : null)) == null) continue;
                this.triggerEvictionToMakeSpace(evictionCompletionFuture);
            }
            return Optional.of(evictionCompletionFuture);
        }
        return Optional.empty();
    }

    private void triggerEvictionToMakeSpace(CompletableFuture<Void> evictionCompletionFuture) {
        this.mlFactory.getCacheEvictionExecutor().execute(() -> {
            try {
                this.doEvictToWatermarkWhenOverThreshold();
            }
            finally {
                evictionCompletionFuture.complete(null);
                this.evictionInProgress.set(null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEvictToWatermarkWhenOverThreshold() {
        long sizeToEvict;
        long currentSize = this.currentSize.get();
        if (currentSize > this.evictionTriggerThreshold && (sizeToEvict = currentSize - (long)((double)this.maxSize * this.cacheEvictionWatermark)) > 0L) {
            try {
                long startTime = System.nanoTime();
                if (log.isDebugEnabled()) {
                    log.debug("Triggering cache eviction. total size: {} Mb -- Need to discard: {} Mb", (Object)((double)currentSize / 1048576.0), (Object)((double)sizeToEvict / 1048576.0));
                }
                this.evictionHandler.evictEntries(sizeToEvict);
                if (log.isDebugEnabled()) {
                    long endTime = System.nanoTime();
                    double durationMs = TimeUnit.NANOSECONDS.toMillis(endTime - startTime);
                    log.debug("Eviction completed. Removed {} Mb in {} ms", (Object)((double)(currentSize - this.currentSize.get()) / 1048576.0), (Object)durationMs);
                }
            }
            finally {
                this.mlFactoryMBean.recordCacheEviction();
            }
        }
    }

    void entryAdded(long size) {
        this.currentSize.addAndGet(size);
        this.mlFactoryMBean.recordCacheInsertion();
        this.triggerEvictionWhenNeeded();
    }

    void entriesRemoved(long size, int count) {
        this.mlFactoryMBean.recordNumberOfCacheEntriesEvicted(count);
        this.currentSize.addAndGet(-size);
    }

    @Override
    public long getSize() {
        return this.currentSize.get();
    }

    @VisibleForTesting
    public Pair<Integer, Long> getNonEvictableSize() {
        return this.evictionHandler.getNonEvictableSize();
    }

    @Override
    public long getMaxSize() {
        return this.maxSize;
    }

    @Override
    public double getCacheEvictionWatermark() {
        return this.cacheEvictionWatermark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCacheEviction() {
        CompletableFuture<Object> evictionCompletionFuture = new CompletableFuture<Object>();
        this.evictionInProgress.set(evictionCompletionFuture);
        try {
            long maxTimestamp = System.nanoTime() - this.mlFactory.getCacheEvictionTimeThreshold();
            this.evictionHandler.invalidateEntriesBeforeTimestampNanos(maxTimestamp);
            this.doEvictToWatermarkWhenOverThreshold();
        }
        finally {
            evictionCompletionFuture.complete(null);
            this.evictionInProgress.set(null);
        }
    }

    @Override
    public void clear() {
        this.caches.values().forEach(EntryCache::clear);
    }

    public InflightReadsLimiter getInflightReadsLimiter() {
        return this.inflightReadsLimiter;
    }

    @Override
    public void updateCacheEvictionExtendTTLOfEntriesWithRemainingExpectedReadsMaxTimes(int extendTTLOfEntriesWithRemainingExpectedReadsMaxTimes) {
        this.rangeCacheRemovalQueue.setMaxRequeueCountWhenHasExpectedReads(extendTTLOfEntriesWithRemainingExpectedReadsMaxTimes);
    }

    @Override
    public void updateCacheEvictionExtendTTLOfRecentlyAccessed(boolean cacheEvictionExtendTTLOfRecentlyAccessed) {
        this.rangeCacheRemovalQueue.setExtendTTLOfRecentlyAccessed(cacheEvictionExtendTTLOfRecentlyAccessed);
    }

    @VisibleForTesting
    RangeCacheRemovalQueue getRangeCacheRemovalQueue() {
        return this.rangeCacheRemovalQueue;
    }

    @VisibleForTesting
    void forEachEntry(Consumer<RangeCacheEntryWrapper> consumer) {
        this.rangeCacheRemovalQueue.forEachEntry(consumer);
    }

    @Generated
    public ManagedLedgerFactoryMBeanImpl getMlFactoryMBean() {
        return this.mlFactoryMBean;
    }

    @Generated
    public void setEntryLengthFunction(EntryLengthFunction entryLengthFunction) {
        this.entryLengthFunction = entryLengthFunction;
    }
}

