# PIP-301: Separate load data storage from configuration metadata store

# Background knowledge

The following z-nodes store the load and quota data about loadbalance. And the CRUD about them are handled by `localMetadataStore`, not `configurationMetadataStore`.
* `/loadbalance/bundle-data`
* `/loadbalance/broker-time-average`
* `/loadbalance/resource-quota`

Currently, the access about the above z-nodes are distributed everywhere. It's very easy to call the the wrong `configurationMetadataStore` to handle them, e.g.:
* [[fix] [broker] remove bundle-data in local metadata store.](https://github.com/apache/pulsar/pull/21078)

# Motivation

Refactor the access code about balance/load data

# Goals

## In Scope

Introduce `LoadBalanceResources` to unify the CRUD about balance/load data.

## Out of Scope

None

# High Level Design

Introduce `LoadBalanceResources` which has three inner class:
* `BundleDataResources`
* `BrokerTimeAverageResources`
* `QuotaResources`

# Detailed Design

## Design & Implementation Details

```java
public class LoadBalanceResources {
    public static final String BUNDLE_DATA_BASE_PATH = "/loadbalance/bundle-data";
    public static final String BROKER_TIME_AVERAGE_BASE_PATH = "/loadbalance/broker-time-average";
    public static final String RESOURCE_QUOTA_BASE_PATH = "/loadbalance/resource-quota";

    private final BundleDataResources bundleDataResources;

    public LoadBalanceResources(MetadataStore store, int operationTimeoutSec) {
        bundleDataResources = new BundleDataResources(store, operationTimeoutSec);
    }

    public static class BundleDataResources extends BaseResources<BundleData> {
        public BundleDataResources(MetadataStore store, int operationTimeoutSec) {
            super(store, BundleData.class, operationTimeoutSec);
        }
        // ...
    }

    public static class BrokerTimeAverageResources extends BaseResources<TimeAverageBrokerData> {
        public BrokerTimeAverageResources(MetadataStore store, int operationTimeoutSec) {
            super(store, TimeAverageBrokerData.class, operationTimeoutSec);
        }
        // ...
    }

    public static class QuotaResources extends BaseResources<ResourceQuota> {
        public QuotaResources(MetadataStore store, int operationTimeoutSec) {
            super(store, ResourceQuota.class, operationTimeoutSec);
        }
        // ...
    }
}
```

## Public-facing Changes

None

### Public API

None

# Backward & Forward Compatibility

None

# Links

* Mailing List discussion thread: https://lists.apache.org/thread/7ngw9dc62tj2c4c5484dgsnlwgtstpbj
* Mailing List voting thread: https://lists.apache.org/thread/26dc8r6hnp7owdsq1hpzb48g8vlfrtxt
