/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client.session;

import com.google.common.annotations.VisibleForTesting;
import io.oxia.client.ClientConfig;
import io.oxia.client.grpc.OxiaStubProvider;
import io.oxia.client.metrics.InstrumentProvider;
import io.oxia.client.session.Session;
import io.oxia.client.session.SessionFactory;
import io.oxia.client.session.SessionNotificationListener;
import io.oxia.client.shard.ShardManager;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager
implements AutoCloseable,
Consumer<ShardManager.ShardAssignmentChanges>,
SessionNotificationListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionManager.class);
    private final ConcurrentMap<Long, CompletableFuture<Session>> sessionsByShardId = new ConcurrentHashMap<Long, CompletableFuture<Session>>();
    private final SessionFactory factory;
    private volatile boolean closed = false;

    public SessionManager(@NonNull ScheduledExecutorService executor, @NonNull ClientConfig config, @NonNull OxiaStubProvider stubProvider, @NonNull InstrumentProvider instrumentProvider) {
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (stubProvider == null) {
            throw new NullPointerException("stubProvider is marked non-null but is null");
        }
        if (instrumentProvider == null) {
            throw new NullPointerException("instrumentProvider is marked non-null but is null");
        }
        this.factory = new SessionFactory(executor, config, this, stubProvider, instrumentProvider);
    }

    SessionManager(SessionFactory factory) {
        this.factory = factory;
    }

    @NonNull
    public CompletableFuture<Session> getSession(long shardId) {
        if (this.closed) {
            return CompletableFuture.failedFuture(new IllegalStateException("session manager has been closed"));
        }
        return this.sessionsByShardId.compute(shardId, (key, existing) -> {
            if (existing != null && !existing.isCompletedExceptionally()) {
                return existing;
            }
            return this.factory.create(shardId);
        });
    }

    @Override
    public void onSessionClosed(Session session) {
        this.sessionsByShardId.remove(session.getShardId());
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.sessionsByShardId.values().stream().map(this::closeQuietly).forEach(CompletableFuture::join);
    }

    @VisibleForTesting
    Map<Long, Session> sessions() {
        HashMap<Long, Session> sessions = new HashMap<Long, Session>(this.sessionsByShardId.size());
        for (Map.Entry e : this.sessionsByShardId.entrySet()) {
            if (!((CompletableFuture)e.getValue()).isDone() || ((CompletableFuture)e.getValue()).isCompletedExceptionally()) continue;
            sessions.put((Long)e.getKey(), (Session)((CompletableFuture)e.getValue()).join());
        }
        return sessions;
    }

    @Override
    public void accept(@NonNull ShardManager.ShardAssignmentChanges changes) {
        if (changes == null) {
            throw new NullPointerException("changes is marked non-null but is null");
        }
        if (!this.closed) {
            changes.removed().forEach(s -> this.closeQuietly((CompletableFuture)this.sessionsByShardId.remove(s.id())));
        }
    }

    @VisibleForTesting
    CompletableFuture<Void> closeQuietly(CompletableFuture<Session> sessionFuture) {
        CompletionStage future = ((CompletableFuture)sessionFuture.thenCompose(Session::close)).thenApply(__ -> null);
        return ((CompletableFuture)future).exceptionally(ex -> null);
    }
}

