# PIP-176: Refactor Doc Bot

[PIP 176: Refactor Doc Bot to Improve Efficiency of Managing Doc](https://docs.google.com/document/d/1syM2irXZQtcVXHNWP7v_m4EdPvOy9olnxJUd62gtiDI/edit#)

# Issues (new)

- [ ] P0: doc bot check is pending or waiting and `documentation label check` is changed to `label check` after it is set to `required`.

This blocks many PRs, eg. https://github.com/apache/pulsar/pull/16298, https://github.com/apache/pulsar/pull/16023

This might be caused by GitHub Action limitations https://stackoverflow.com/questions/52200096/github-pull-request-waiting-for-status-to-be-reported

Can you please take a look at it at your earliest convenience? Thank you!

- [ ] P1: when the PR description is empty and the PR author selects labels from **Labels**, the doc bot should work normally.

- [ ] P2: configure the doc bot to other branches except for master
        - [x] 2.10. Obsever the results and set for other branches if it works well
        - [ ] 2.9
        - [ ] 2.8
        - [ ] 2.7

## Issues can't be resolved

- [ ] P2: [Doc Bot is triggered after updating PR title](https://docs.google.com/document/d/1syM2irXZQtcVXHNWP7v_m4EdPvOy9olnxJUd62gtiDI/edit#bookmark=id.y66kb6ag4crn). (can not be resolved now due to GitHub limitations)

# Issues (old)

When fixing https://github.com/apache/pulsar/issues/15732, @maxsxu found that the doc Bot was implemented by modifying `dist` rather than `src`, which makes it hard to maintain and scale.

Consequently, he suggests refactoring the doc Bot along with resolving the following issues in Bot:

## Scenario 1

### Issue

[This PR](https://github.com/apache/pulsar/pull/15789) was marked with doc-related labels and then removed. No doc-related label is marked for this PR.

### Expected behavior

In this case, this PR should be labeled w/ `doc-label-missing`.

<img width="1043" alt="image" src="https://user-images.githubusercontent.com/50226895/170403373-c2dd5645-274b-4dc7-968d-b0b54ff94c5c.png">

## Scenario 2

### Issue

Doc Bot only works for master change.

### Expected behavior

Doc Bot should work for all branches and label all PRs.

<img width="1295" alt="image" src="https://user-images.githubusercontent.com/50226895/170403785-2462456f-337a-455e-9b62-b2c249c0a6b3.png">

## Scenario 3

### Issue

Bot labels [this PR](https://github.com/apache/pulsar/pull/15790) with several doc labels.

### Expected behavior

Bot should label a PR with only a doc label.

![image](https://user-images.githubusercontent.com/50226895/170409437-4152241c-fde3-4ab8-80f0-2a127360367a.png)

# Improvements

Set documentation label check as one of the GitHub checks.

# References

## Pulsar Bot

- [Instructions](https://docs.google.com/document/d/1Qw7LHQdXWBW9t2-r-A7QdFDBwmZh6ytB4guwMoXHqc0/edit#bookmark=id.5d66olk7l4oz)
- [Implementation process](https://docs.google.com/document/d/1bQfZkSu5nG1tNycpmXXtUFn-Z5-h-uqHv6IXsCEySQ8/edit#)
- [Flowchart](https://lucid.app/lucidchart/2e71291d-7882-4c61-86c1-0711a007ce58/edit?beaconFlowId=CE4A5D8BF4076F72&invitationId=inv_0fe733d2-a1dd-425d-807d-ac11ad9dc39d&page=0_0#)
- [Script file](https://github.com/apache/pulsar-test-infra/blob/76c227dea32f3b9be99558d4f2c22f1e70252839/doc-label-check/dist/index.js#L2617)
