/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.quantiles;

import com.yahoo.memory.Memory;
import com.yahoo.memory.NativeMemory;
import com.yahoo.memory.UnsafeUtil;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.quantiles.Util;
import java.nio.ByteOrder;

final class PreambleUtil {
    static final int PREAMBLE_LONGS_BYTE = 0;
    static final int SER_VER_BYTE = 1;
    static final int FAMILY_BYTE = 2;
    static final int FLAGS_BYTE = 3;
    static final int K_SHORT = 4;
    static final int N_LONG = 8;
    static final int MIN_DOUBLE = 16;
    static final int MAX_DOUBLE = 24;
    static final int COMBINED_BUFFER = 32;
    static final int BIG_ENDIAN_FLAG_MASK = 1;
    static final int READ_ONLY_FLAG_MASK = 2;
    static final int EMPTY_FLAG_MASK = 4;
    static final int COMPACT_FLAG_MASK = 8;
    static final int ORDERED_FLAG_MASK = 16;
    static final boolean NATIVE_ORDER_IS_BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;

    private PreambleUtil() {
    }

    static String toString(byte[] byteArr, boolean isDoublesSketch) {
        NativeMemory mem = new NativeMemory(byteArr);
        return PreambleUtil.toString((Memory)mem, isDoublesSketch);
    }

    static String toString(Memory mem, boolean isDoublesSketch) {
        return PreambleUtil.memoryToString(mem, isDoublesSketch);
    }

    private static String memoryToString(Memory mem, boolean isDoublesSketch) {
        int preLongs = mem.getByte(0L) & 0xFF;
        byte serVer = mem.getByte(1L);
        byte familyID = mem.getByte(2L);
        String famName = Family.idToFamily(familyID).toString();
        byte flags = mem.getByte(3L);
        boolean bigEndian = (flags & 1) > 0;
        String nativeOrder = ByteOrder.nativeOrder().toString();
        boolean readOnly = (flags & 2) > 0;
        boolean empty = (flags & 4) > 0;
        boolean compact = (flags & 8) > 0;
        boolean ordered = (flags & 0x10) > 0;
        short k = mem.getShort(4L);
        long n = preLongs == 1 ? 0L : mem.getLong(8L);
        double minDouble = Double.POSITIVE_INFINITY;
        double maxDouble = Double.NEGATIVE_INFINITY;
        if (preLongs > 1 && isDoublesSketch) {
            minDouble = mem.getDouble(16L);
            maxDouble = mem.getDouble(24L);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Util.LS);
        sb.append("### QUANTILES SKETCH PREAMBLE SUMMARY:").append(Util.LS);
        sb.append("Byte  0: Preamble Longs       : ").append(preLongs).append(Util.LS);
        sb.append("Byte  1: Serialization Version: ").append(serVer).append(Util.LS);
        sb.append("Byte  2: Family               : ").append(famName).append(Util.LS);
        sb.append("Byte  3: Flags Field          : ").append(String.format("%02o", flags)).append(Util.LS);
        sb.append("  BIG ENDIAN                  : ").append(bigEndian).append(Util.LS);
        sb.append("  (Native Byte Order)         : ").append(nativeOrder).append(Util.LS);
        sb.append("  READ ONLY                   : ").append(readOnly).append(Util.LS);
        sb.append("  EMPTY                       : ").append(empty).append(Util.LS);
        sb.append("  COMPACT                     : ").append(compact).append(Util.LS);
        sb.append("  ORDERED                     : ").append(ordered).append(Util.LS);
        sb.append("Bytes  4-5  : K               : ").append(k).append(Util.LS);
        if (preLongs == 1) {
            sb.append(" --ABSENT, ASSUMED:").append(Util.LS);
        }
        sb.append("Bytes  8-15 : N                : ").append(n).append(Util.LS);
        if (isDoublesSketch) {
            sb.append("MinDouble                      : ").append(minDouble).append(Util.LS);
            sb.append("MaxDouble                      : ").append(maxDouble).append(Util.LS);
        }
        sb.append("Retained Items                 : ").append(Util.computeRetainedItems(k, n)).append(Util.LS);
        sb.append("Total Bytes                    : ").append(mem.getCapacity()).append(Util.LS);
        sb.append("### END SKETCH PREAMBLE SUMMARY").append(Util.LS);
        return sb.toString();
    }

    static int extractPreLongs(Object arr, long cumOffset) {
        return UnsafeUtil.unsafe.getByte(arr, cumOffset + 0L) & 0xFF;
    }

    static int extractSerVer(Object arr, long cumOffset) {
        return UnsafeUtil.unsafe.getByte(arr, cumOffset + 1L) & 0xFF;
    }

    static int extractFamilyID(Object arr, long cumOffset) {
        return UnsafeUtil.unsafe.getByte(arr, cumOffset + 2L) & 0xFF;
    }

    static int extractFlags(Object arr, long cumOffset) {
        return UnsafeUtil.unsafe.getByte(arr, cumOffset + 3L) & 0xFF;
    }

    static int extractK(Object arr, long cumOffset) {
        return UnsafeUtil.unsafe.getShort(arr, cumOffset + 4L) & 0xFFFF;
    }

    static long extractN(Object arr, long cumOffset) {
        return UnsafeUtil.unsafe.getLong(arr, cumOffset + 8L);
    }

    static double extractMinDouble(Object arr, long cumOffset) {
        return UnsafeUtil.unsafe.getDouble(arr, cumOffset + 16L);
    }

    static double extractMaxDouble(Object arr, long cumOffset) {
        return UnsafeUtil.unsafe.getDouble(arr, cumOffset + 24L);
    }

    static void insertPreLongs(Object arr, long cumOffset, int value) {
        UnsafeUtil.unsafe.putByte(arr, cumOffset + 0L, (byte)value);
    }

    static void insertSerVer(Object arr, long cumOffset, int value) {
        UnsafeUtil.unsafe.putByte(arr, cumOffset + 1L, (byte)value);
    }

    static void insertFamilyID(Object arr, long cumOffset, int value) {
        UnsafeUtil.unsafe.putByte(arr, cumOffset + 2L, (byte)value);
    }

    static void insertFlags(Object arr, long cumOffset, int value) {
        UnsafeUtil.unsafe.putByte(arr, cumOffset + 3L, (byte)value);
    }

    static void insertK(Object arr, long cumOffset, int value) {
        UnsafeUtil.unsafe.putShort(arr, cumOffset + 4L, (short)value);
    }

    static void insertN(Object arr, long cumOffset, long value) {
        UnsafeUtil.unsafe.putLong(arr, cumOffset + 8L, value);
    }

    static void insertMinDouble(Object arr, long cumOffset, double value) {
        UnsafeUtil.unsafe.putDouble(arr, cumOffset + 16L, value);
    }

    static void insertMaxDouble(Object arr, long cumOffset, double value) {
        UnsafeUtil.unsafe.putDouble(arr, cumOffset + 24L, value);
    }
}

