/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.util;

import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.core.Configuration;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.OutgoingEntry;
import org.eclipse.jetty.websocket.core.util.WebSocketFlusher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FragmentingFlusher
extends WebSocketFlusher {
    private static final Logger LOG = LoggerFactory.getLogger(FragmentingFlusher.class);
    private final Configuration _configuration;
    private ByteBuffer _payload;

    public FragmentingFlusher(Configuration configuration) {
        this._configuration = configuration;
    }

    protected abstract void forwardFrame(OutgoingEntry var1);

    @Override
    protected boolean onFrame(OutgoingEntry entry, boolean first) {
        Frame frame = entry.getFrame();
        long maxFrameSize = this._configuration.getMaxFrameSize();
        if (first) {
            if (frame.isControlFrame() || maxFrameSize <= 0L || (long)frame.getPayloadLength() <= maxFrameSize) {
                this.forwardFrame(entry);
                return true;
            }
            this._payload = frame.getPayload().slice();
        }
        int remaining = this._payload.remaining();
        int fragmentSize = (int)Math.min((long)remaining, maxFrameSize);
        byte opCode = frame.getOpCode() == 0 || !first ? (byte)0 : frame.getOpCode();
        Frame fragment = new Frame(opCode);
        boolean finished = maxFrameSize <= 0L || (long)remaining <= maxFrameSize;
        fragment.setFin(frame.isFin() && finished);
        if (finished) {
            fragment.setPayload(this._payload);
            this._payload = null;
        } else {
            int limit = this._payload.limit();
            int newLimit = this._payload.position() + fragmentSize;
            this._payload.limit(newLimit);
            ByteBuffer payloadFragment = this._payload.slice();
            this._payload.limit(limit);
            fragment.setPayload(payloadFragment);
            this._payload.position(newLimit);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fragmented {}->{}", (Object)frame, (Object)fragment);
            }
        }
        this.forwardFrame(new OutgoingEntry.Builder(entry).frame(fragment).build());
        return finished;
    }

    @Override
    protected void onCompleteFailure(Throwable cause) {
        super.onCompleteFailure(cause);
        this._payload = null;
    }
}

