/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.security.auth.Subject;
import org.apache.qpid.server.model.PermissionedObject;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.access.config.RuleBasedAccessControl;

class CachingSecurityToken
implements SecurityToken {
    private final Subject _subject;
    private volatile AccessControlCache _cache;
    private static final AtomicReferenceFieldUpdater<CachingSecurityToken, AccessControlCache> CACHE_UPDATE = AtomicReferenceFieldUpdater.newUpdater(CachingSecurityToken.class, AccessControlCache.class, "_cache");

    CachingSecurityToken(Subject subject, RuleBasedAccessControl accessControl) {
        this._subject = subject;
        this._cache = new AccessControlCache(accessControl);
    }

    Subject getSubject() {
        return this._subject;
    }

    Result authorise(RuleBasedAccessControl ruleBasedAccessControl, Operation operation, PermissionedObject configuredObject, Map<String, Object> arguments) {
        AccessControlCache cache;
        while ((cache = CACHE_UPDATE.get(this)).getAccessControl() != ruleBasedAccessControl) {
            CACHE_UPDATE.compareAndSet(this, cache, new AccessControlCache(ruleBasedAccessControl));
        }
        CachedMethodAuthKey key = new CachedMethodAuthKey(configuredObject, operation, arguments);
        Result result = (Result)cache.getCache().get(key);
        if (result == null) {
            result = ruleBasedAccessControl.authorise(operation, configuredObject, arguments);
            cache.getCache().putIfAbsent(key, result);
        }
        return result;
    }

    private static final class AccessControlCache {
        private final RuleBasedAccessControl _accessControl;
        private final ConcurrentMap<CachedMethodAuthKey, Result> _cache = new ConcurrentHashMap<CachedMethodAuthKey, Result>();

        private AccessControlCache(RuleBasedAccessControl accessControl) {
            this._accessControl = accessControl;
        }

        public RuleBasedAccessControl getAccessControl() {
            return this._accessControl;
        }

        public ConcurrentMap<CachedMethodAuthKey, Result> getCache() {
            return this._cache;
        }
    }

    private static final class CachedMethodAuthKey {
        private final PermissionedObject _configuredObject;
        private final Operation _operation;
        private final Map<String, Object> _arguments;
        private final int _hashCode;

        public CachedMethodAuthKey(PermissionedObject configuredObject, Operation operation, Map<String, Object> arguments) {
            this._configuredObject = configuredObject;
            this._operation = operation;
            this._arguments = arguments;
            int result = this._configuredObject != null ? this._configuredObject.hashCode() : 0;
            result = 31 * result + (operation != null ? operation.hashCode() : 0);
            this._hashCode = result = 31 * result + (this._arguments != null ? this._arguments.hashCode() : 0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachedMethodAuthKey that = (CachedMethodAuthKey)o;
            return Objects.equals(this._configuredObject, that._configuredObject) && Objects.equals(this._operation, that._operation) && Objects.equals(this._arguments, that._arguments);
        }

        public int hashCode() {
            return this._hashCode;
        }
    }
}

