/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.function.aggregation;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.qpid.server.query.engine.exception.QueryEvaluationException;
import org.apache.qpid.server.query.engine.exception.QueryParsingException;
import org.apache.qpid.server.query.engine.parsing.collector.CollectorType;
import org.apache.qpid.server.query.engine.parsing.expression.Expression;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.function.AbstractFunctionExpression;
import org.apache.qpid.server.query.engine.parsing.query.SelectExpression;
import org.apache.qpid.server.query.engine.validation.FunctionParameterTypePredicate;

public abstract class AbstractAggregationExpression<T, R>
extends AbstractFunctionExpression<T, R> {
    private R _value;
    private SelectExpression<T, R> _selectExpression;

    public AbstractAggregationExpression(String alias, List<ExpressionNode<T, ?>> args) {
        super(alias, args);
    }

    @Override
    public R apply(T value) {
        if (this._value != null) {
            if (this._value instanceof Map) {
                List indexes = this._selectExpression.getGroupBy().stream().map(item -> item.apply(value)).collect(Collectors.toList());
                Object result = this._value;
                for (Object index : indexes) {
                    result = ((Map)result).get(index);
                }
                return result;
            }
            return this._value;
        }
        throw QueryParsingException.of("%s.apply() should be called after calling aggregate()", this.getClass().getSimpleName());
    }

    protected List<?> getArguments(List<T> items, FunctionParameterTypePredicate<Object> _typeValidator) {
        List args = items.stream().map(this.getSource()).collect(Collectors.toList());
        List invalidArgs = args.stream().filter(_typeValidator.negate()).collect(Collectors.toList());
        if (!invalidArgs.isEmpty()) {
            throw QueryEvaluationException.invalidFunctionParameters(this._functionName, invalidArgs);
        }
        return args;
    }

    public abstract R aggregate(List<T> var1);

    public abstract CollectorType getCollectorType();

    public void setValue(R value) {
        this._value = value;
    }

    public void setSelect(SelectExpression<T, R> selectExpression) {
        this._selectExpression = selectExpression;
    }

    public Expression<T, R> getSource() {
        return this.getChild(0);
    }
}

