/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import org.apache.qpid.jms.message.JmsOutboundMessageDispatch;
import org.apache.qpid.jms.meta.JmsConnectionInfo;
import org.apache.qpid.jms.meta.JmsProducerInfo;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.ProviderException;
import org.apache.qpid.jms.provider.amqp.AmqpConnection;
import org.apache.qpid.jms.provider.amqp.AmqpExceptionBuilder;
import org.apache.qpid.jms.provider.amqp.AmqpProducer;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.provider.amqp.AmqpSession;
import org.apache.qpid.jms.provider.amqp.AmqpSupport;
import org.apache.qpid.jms.provider.amqp.AmqpTransactionContext;
import org.apache.qpid.jms.provider.amqp.AmqpTransferTagGenerator;
import org.apache.qpid.jms.provider.amqp.message.AmqpReadableBuffer;
import org.apache.qpid.jms.provider.exceptions.ProviderDeliveryModifiedException;
import org.apache.qpid.jms.provider.exceptions.ProviderDeliveryReleasedException;
import org.apache.qpid.jms.provider.exceptions.ProviderExceptionSupport;
import org.apache.qpid.jms.provider.exceptions.ProviderIllegalStateException;
import org.apache.qpid.jms.provider.exceptions.ProviderSendTimedOutException;
import org.apache.qpid.jms.provider.exceptions.ProviderUnsupportedOperationException;
import org.apache.qpid.jms.tracing.JmsTracer;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.transaction.TransactionalState;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpFixedProducer
extends AmqpProducer {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpFixedProducer.class);
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final AmqpTransferTagGenerator tagGenerator = new AmqpTransferTagGenerator(true);
    private final Map<Object, InFlightSend> sent = new LinkedHashMap<Object, InFlightSend>();
    private final Map<Object, InFlightSend> blocked = new LinkedHashMap<Object, InFlightSend>();
    private final AmqpConnection connection;
    private final JmsTracer tracer;

    public AmqpFixedProducer(AmqpSession session, JmsProducerInfo info, Sender sender) {
        super(session, info, sender);
        this.connection = session.getConnection();
        this.tracer = ((JmsConnectionInfo)this.connection.getResourceInfo()).getTracer();
        this.delayedDeliverySupported = this.connection.getProperties().isDelayedDeliverySupported();
    }

    @Override
    public void close(AsyncResult request) {
        if (!this.blocked.isEmpty() || !this.sent.isEmpty()) {
            this.closeRequest = request;
            return;
        }
        super.close(request);
    }

    @Override
    public void send(JmsOutboundMessageDispatch envelope, AsyncResult request) throws ProviderException {
        if (!this.isClosed()) {
            InFlightSend send = new InFlightSend(envelope, request);
            if (!this.delayedDeliverySupported && envelope.getMessage().getFacade().isDeliveryTimeTransmitted()) {
                send.onFailure(new ProviderUnsupportedOperationException("Remote does not support delayed message delivery"));
            } else if (this.session.isTransactionInDoubt()) {
                send.onSuccess();
            } else if (((Sender)this.getEndpoint()).getCredit() <= 0) {
                LOG.trace("Holding Message send until credit is available.");
                if (this.getSendTimeout() > -1L) {
                    send.requestTimeout = this.getParent().getProvider().scheduleRequestTimeout((AsyncResult)send, this.getSendTimeout(), send);
                }
                this.blocked.put(envelope.getMessageId(), send);
                this.getParent().getProvider().pumpToProtonTransport(request);
            } else {
                this.doSend(envelope, send);
            }
        } else {
            request.onFailure(new ProviderIllegalStateException("The MessageProducer is closed"));
        }
    }

    private void doSend(JmsOutboundMessageDispatch envelope, InFlightSend send) throws ProviderException {
        LOG.trace("Producer sending message: {}", (Object)envelope);
        boolean presettle = envelope.isPresettle() || this.isPresettle();
        Delivery delivery = null;
        if (presettle) {
            delivery = ((Sender)this.getEndpoint()).delivery(EMPTY_BYTE_ARRAY, 0, 0);
        } else {
            byte[] tag = this.tagGenerator.getNextTag();
            delivery = ((Sender)this.getEndpoint()).delivery(tag, 0, tag.length);
        }
        if (this.session.isTransacted()) {
            AmqpTransactionContext context = this.session.getTransactionContext();
            delivery.disposition((DeliveryState)context.getTxnEnrolledState());
            context.registerTxProducer(this);
        }
        ByteBuf encoded = (ByteBuf)envelope.getPayload();
        ((Sender)this.getEndpoint()).sendNoCopy((ReadableBuffer)new AmqpReadableBuffer(encoded.duplicate()));
        AmqpProvider provider = this.getParent().getProvider();
        if (!presettle && this.getSendTimeout() != -1L && send.requestTimeout == null) {
            send.requestTimeout = this.getParent().getProvider().scheduleRequestTimeout((AsyncResult)send, this.getSendTimeout(), send);
        }
        if (presettle) {
            delivery.settle();
        } else {
            this.sent.put(envelope.getMessageId(), send);
            ((Sender)this.getEndpoint()).advance();
        }
        send.setDelivery(delivery);
        delivery.setContext((Object)send);
        if (provider.pumpToProtonTransport(send, false)) {
            if (presettle) {
                send.onSuccess();
            } else if (envelope.isSendAsync()) {
                send.getOriginalRequest().onSuccess();
            }
            try {
                provider.getTransport().flush();
            }
            catch (Throwable ex) {
                throw ProviderExceptionSupport.createOrPassthroughFatal(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processFlowUpdates(AmqpProvider provider) throws ProviderException {
        if (!this.blocked.isEmpty() && ((Sender)this.getEndpoint()).getCredit() > 0) {
            Iterator<InFlightSend> blockedSends = this.blocked.values().iterator();
            while (((Sender)this.getEndpoint()).getCredit() > 0 && blockedSends.hasNext()) {
                LOG.trace("Dispatching previously held send");
                InFlightSend held = blockedSends.next();
                try {
                    if (this.session.isTransacted() && this.session.isTransactionInDoubt()) {
                        held.onSuccess();
                        return;
                    }
                    this.doSend(held.getEnvelope(), held);
                }
                finally {
                    blockedSends.remove();
                }
            }
        }
        if (((Sender)this.getEndpoint()).getDrain()) {
            ((Sender)this.getEndpoint()).drained();
        }
        super.processFlowUpdates(provider);
    }

    @Override
    public void processDeliveryUpdates(AmqpProvider provider, Delivery delivery) throws ProviderException {
        DeliveryState state = delivery.getRemoteState();
        if (state != null) {
            InFlightSend send = (InFlightSend)delivery.getContext();
            if (state.getType() == DeliveryState.DeliveryStateType.Accepted) {
                LOG.trace("Outcome of delivery was accepted: {}", (Object)delivery);
                send.onSuccess();
            } else {
                this.applyDeliveryStateUpdate(send, delivery, state);
            }
        }
        super.processDeliveryUpdates(provider, delivery);
    }

    private void applyDeliveryStateUpdate(InFlightSend send, Delivery delivery, DeliveryState state) {
        ProviderException deliveryError = null;
        if (state == null) {
            return;
        }
        switch (state.getType()) {
            case Transactional: {
                LOG.trace("State of delivery is Transactional, retrieving outcome: {}", (Object)state);
                this.applyDeliveryStateUpdate(send, delivery, (DeliveryState)((TransactionalState)state).getOutcome());
                break;
            }
            case Accepted: {
                LOG.trace("Outcome of delivery was accepted: {}", (Object)delivery);
                send.onSuccess();
                break;
            }
            case Rejected: {
                LOG.trace("Outcome of delivery was rejected: {}", (Object)delivery);
                ErrorCondition remoteError = ((Rejected)state).getError();
                if (remoteError == null) {
                    remoteError = ((Sender)this.getEndpoint()).getRemoteCondition();
                }
                deliveryError = AmqpSupport.convertToNonFatalException(this.getParent().getProvider(), this.getEndpoint(), remoteError);
                break;
            }
            case Released: {
                LOG.trace("Outcome of delivery was released: {}", (Object)delivery);
                deliveryError = new ProviderDeliveryReleasedException("Delivery failed: released by receiver");
                break;
            }
            case Modified: {
                LOG.trace("Outcome of delivery was modified: {}", (Object)delivery);
                Modified modified = (Modified)state;
                deliveryError = new ProviderDeliveryModifiedException("Delivery failed: failure at remote", modified);
                break;
            }
            default: {
                LOG.warn("Message send updated with unsupported state: {}", (Object)state);
            }
        }
        if (deliveryError != null) {
            send.onFailure(deliveryError);
        }
    }

    public AmqpSession getSession() {
        return this.session;
    }

    @Override
    public boolean isAnonymous() {
        return ((JmsProducerInfo)this.getResourceInfo()).getDestination() == null;
    }

    @Override
    public boolean isPresettle() {
        return ((Sender)this.getEndpoint()).getSenderSettleMode() == SenderSettleMode.SETTLED;
    }

    public long getSendTimeout() {
        return this.getParent().getProvider().getSendTimeout();
    }

    public String toString() {
        return "AmqpFixedProducer { " + String.valueOf(this.getProducerId()) + " }";
    }

    @Override
    public void handleResourceClosure(AmqpProvider provider, ProviderException error) {
        if (error == null) {
            error = ((Sender)this.getEndpoint()).getRemoteCondition() != null ? AmqpSupport.convertToNonFatalException(provider, this.getEndpoint(), ((Sender)this.getEndpoint()).getRemoteCondition()) : new ProviderException("Producer closed remotely before message transfer result was notified");
        }
        ArrayList<InFlightSend> inflightSends = new ArrayList<InFlightSend>(this.sent.values());
        for (InFlightSend send : inflightSends) {
            try {
                send.onFailure(error);
            }
            catch (Exception e) {
                LOG.debug("Caught exception when failing pending send during remote producer closure: {}", (Object)send, (Object)e);
            }
        }
        ArrayList<InFlightSend> blockedSends = new ArrayList<InFlightSend>(this.blocked.values());
        for (InFlightSend send : blockedSends) {
            try {
                send.onFailure(error);
            }
            catch (Exception e) {
                LOG.debug("Caught exception when failing blocked send during remote producer closure: {}", (Object)send, (Object)e);
            }
        }
    }

    private final class InFlightSend
    implements AsyncResult,
    AmqpExceptionBuilder {
        private final JmsOutboundMessageDispatch envelope;
        private final AsyncResult request;
        private Delivery delivery;
        private ScheduledFuture<?> requestTimeout;

        public InFlightSend(JmsOutboundMessageDispatch envelope, AsyncResult request) {
            this.envelope = envelope;
            this.request = request;
        }

        @Override
        public void onFailure(ProviderException cause) {
            this.handleSendCompletion(false);
            if (this.request.isComplete()) {
                if (this.envelope.isCompletionRequired()) {
                    AmqpFixedProducer.this.getParent().getProvider().getProviderListener().onFailedMessageSend(this.envelope, ProviderExceptionSupport.createNonFatalOrPassthrough(cause));
                } else {
                    AmqpFixedProducer.this.getParent().getProvider().fireNonFatalProviderException(ProviderExceptionSupport.createNonFatalOrPassthrough(cause));
                }
            } else {
                this.request.onFailure(cause);
            }
        }

        @Override
        public void onSuccess() {
            this.handleSendCompletion(true);
            if (!this.request.isComplete()) {
                this.request.onSuccess();
            }
            if (this.envelope.isCompletionRequired()) {
                AmqpFixedProducer.this.getParent().getProvider().getProviderListener().onCompletedMessageSend(this.envelope);
            }
        }

        public void setRequestTimeout(ScheduledFuture<?> requestTimeout) {
            if (this.requestTimeout != null) {
                this.requestTimeout.cancel(false);
            }
            this.requestTimeout = requestTimeout;
        }

        public JmsOutboundMessageDispatch getEnvelope() {
            return this.envelope;
        }

        public AsyncResult getOriginalRequest() {
            return this.request;
        }

        public void setDelivery(Delivery delivery) {
            this.delivery = delivery;
        }

        public Delivery getDelivery() {
            return this.delivery;
        }

        @Override
        public boolean isComplete() {
            return this.request.isComplete();
        }

        private void handleSendCompletion(boolean successful) {
            this.setRequestTimeout(null);
            if (this.getDelivery() != null) {
                AmqpFixedProducer.this.sent.remove(this.envelope.getMessageId());
                this.delivery.settle();
                if (successful) {
                    AmqpFixedProducer.this.tagGenerator.returnTag(this.delivery.getTag());
                }
                DeliveryState remoteState = this.delivery.getRemoteState();
                AmqpFixedProducer.this.tracer.completeSend(this.envelope.getMessage().getFacade(), remoteState == null ? null : remoteState.getType().name());
            } else {
                AmqpFixedProducer.this.blocked.remove(this.envelope.getMessageId());
                AmqpFixedProducer.this.tracer.completeSend(this.envelope.getMessage().getFacade(), null);
            }
            this.envelope.getMessage().onSendComplete();
            if (AmqpFixedProducer.this.isAwaitingClose() && !AmqpFixedProducer.this.isClosed() && AmqpFixedProducer.this.blocked.isEmpty() && AmqpFixedProducer.this.sent.isEmpty()) {
                AmqpFixedProducer.super.close(AmqpFixedProducer.this.closeRequest);
            }
        }

        @Override
        public ProviderException createException() {
            if (this.delivery == null) {
                return new ProviderSendTimedOutException("Timed out waiting for credit to send Message", this.envelope.getMessage());
            }
            return new ProviderSendTimedOutException("Timed out waiting for disposition of sent Message", this.envelope.getMessage());
        }
    }
}

