/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.IOException;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.datastream.SupportedDataStreamType;
import org.apache.ratis.server.DataStreamServer;
import org.apache.ratis.server.DataStreamServerFactory;
import org.apache.ratis.server.DataStreamServerRpc;
import org.apache.ratis.server.RaftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataStreamServerImpl
implements DataStreamServer {
    public static final Logger LOG = LoggerFactory.getLogger(DataStreamServerImpl.class);
    private final DataStreamServerRpc serverRpc;

    DataStreamServerImpl(RaftServer server, Parameters parameters) {
        SupportedDataStreamType type = RaftConfigKeys.DataStream.type(server.getProperties(), LOG::info);
        this.serverRpc = DataStreamServerFactory.newInstance(type, parameters).newDataStreamServerRpc(server);
    }

    @Override
    public DataStreamServerRpc getServerRpc() {
        return this.serverRpc;
    }

    @Override
    public void close() throws IOException {
        this.serverRpc.close();
    }
}

