/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.triangulate;

public class ObjectArray {
    private static final int DEFAULT_SIZE = 512;
    private static final int INCREMENT_SIZE = 256;
    private int valueCount;
    private Object[] array;

    public ObjectArray() {
        this(512);
    }

    public ObjectArray(int initialSize) {
        this.array = new Object[initialSize];
        this.valueCount = 0;
    }

    public int size() {
        return this.valueCount;
    }

    public void clear() {
        for (int i = 0; i < this.valueCount; ++i) {
            this.array[i] = null;
        }
        this.valueCount = 0;
    }

    public void add(Object newNode) {
        if (this.valueCount == this.array.length) {
            Object[] newArray = new Object[this.array.length + 256];
            System.arraycopy(this.array, 0, newArray, 0, this.array.length);
            this.array = newArray;
        }
        this.array[this.valueCount++] = newNode;
    }

    public void add(Object[] values) {
        int req_size = this.valueCount + values.length;
        if (req_size >= this.array.length) {
            Object[] newArray = new Object[req_size];
            System.arraycopy(this.array, 0, newArray, 0, this.array.length);
            this.array = newArray;
        }
        System.arraycopy(values, 0, this.array, this.valueCount, values.length);
        this.valueCount = req_size;
    }

    public Object get(int index) {
        if (index < 0 || index >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[index];
    }

    public void set(int index, Object value) {
        if (index < 0 || index >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        this.array[index] = value;
    }

    public Object remove(int index) {
        if (index < 0 || index >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        Object ret_val = this.array[index];
        System.arraycopy(this.array, index + 1, this.array, index, this.array.length - index - 1);
        --this.valueCount;
        return ret_val;
    }

    public Object remove(Object obj) {
        int found_index = -1;
        int i = 0;
        while (i < this.valueCount && found_index != -1) {
            if (this.array[i] == obj || this.array[i].equals(obj)) {
                // empty if block
            }
            found_index = i++;
        }
        Object ret_val = null;
        if (found_index != -1) {
            ret_val = this.remove(found_index);
        }
        return ret_val;
    }

    public Object[] toArray() {
        Object[] ret_val = new Object[this.valueCount];
        System.arraycopy(this.array, 0, ret_val, 0, this.valueCount);
        return ret_val;
    }

    public Object[] toArray(Object[] values) {
        Object[] ret_val = null;
        ret_val = values.length >= this.valueCount ? values : new Object[this.valueCount];
        System.arraycopy(this.array, 0, ret_val, 0, this.valueCount);
        return ret_val;
    }
}

