/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphframes.graphx;

import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.graphframes.graphx.Edge;
import org.apache.spark.graphframes.graphx.EdgeContext;
import org.apache.spark.graphframes.graphx.EdgeDirection;
import org.apache.spark.graphframes.graphx.EdgeDirection$;
import org.apache.spark.graphframes.graphx.EdgeTriplet;
import org.apache.spark.graphframes.graphx.Graph;
import org.apache.spark.graphframes.graphx.Graph$;
import org.apache.spark.graphframes.graphx.Pregel$;
import org.apache.spark.graphframes.graphx.TripletFields;
import org.apache.spark.graphframes.graphx.VertexRDD;
import org.apache.spark.graphframes.graphx.lib.ConnectedComponents$;
import org.apache.spark.graphframes.graphx.lib.PageRank$;
import org.apache.spark.graphframes.graphx.lib.StronglyConnectedComponents$;
import org.apache.spark.graphframes.graphx.lib.TriangleCount$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\t%h\u0001\u0002\u0015*\u0001QB\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I!\u0013\u0005\t7\u0002\u0011\u0019\u0011)A\u00069\"A!\r\u0001B\u0002B\u0003-1\rC\u0003e\u0001\u0011\u0005Q\r\u0003\u0005l\u0001!\u0015\r\u0011\"\u0001m\u0011!!\b\u0001#b\u0001\n\u0003a\u0007\u0002\u0003<\u0001\u0011\u000b\u0007I\u0011A<\t\u0011}\u0004\u0001R1A\u0005\u0002]D\u0011\"a\u0001\u0001\u0011\u000b\u0007I\u0011A<\t\u000f\u0005\u001d\u0001\u0001\"\u0003\u0002\n!9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0001bBA\u0018\u0001\u0011\u0005\u0011\u0011\u0007\u0005\b\u0003\u007f\u0001A\u0011AA!\u0011\u001d\ty\u0005\u0001C\u0001\u0003#Bq!a\u0015\u0001\t\u0003\t)\u0006C\u0004\u0002\u0006\u0002!\t!a\"\t\u0013\u00055\u0007!%A\u0005\u0002\u0005=\u0007\"CAz\u0001E\u0005I\u0011AA{\u0011\u001d\u0011\u0019\u0001\u0001C\u0001\u0005\u000bAqAa\u0002\u0001\t\u0003\u0011I\u0001C\u0005\u0003\u0012\u0001\t\n\u0011\"\u0001\u0003\u0014!9!q\u0003\u0001\u0005\u0002\te\u0001\"\u0003B+\u0001E\u0005I\u0011\u0001B,\u0011%\u0011y\u0006AI\u0001\n\u0003\u0011\t\u0007C\u0004\u0003j\u0001!\tAa\u001b\t\u0013\tu\u0004!%A\u0005\u0002\t}\u0004b\u0002BB\u0001\u0011\u0005!Q\u0011\u0005\n\u0005\u001f\u0003\u0011\u0013!C\u0001\u0005\u007fBqA!%\u0001\t\u0003\u0011\u0019\nC\u0005\u00032\u0002\t\n\u0011\"\u0001\u0003\u0000!9!1\u0017\u0001\u0005\u0002\tU\u0006\"\u0003B_\u0001E\u0005I\u0011\u0001B@\u0011\u001d\u0011y\f\u0001C\u0001\u0005\u0003D\u0011Ba2\u0001#\u0003%\tAa \t\u000f\t}\u0006\u0001\"\u0001\u0003J\"9!1\u001b\u0001\u0005\u0002\tU\u0007b\u0002Bj\u0001\u0011\u0005!\u0011\u001c\u0005\b\u0005;\u0004A\u0011\u0001Bp\u0011\u001d\u0011\u0019\u000f\u0001C\u0001\u0005K\u0014\u0001b\u0012:ba\"|\u0005o\u001d\u0006\u0003U-\naa\u001a:ba\"D(B\u0001\u0017.\u0003-9'/\u00199iMJ\fW.Z:\u000b\u00059z\u0013!B:qCJ\\'B\u0001\u00192\u0003\u0019\t\u0007/Y2iK*\t!'A\u0002pe\u001e\u001c\u0001!F\u00026\u001ff\u001b2\u0001\u0001\u001c=!\t9$(D\u00019\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0005\u0019\te.\u001f*fMB\u0011Q(\u0012\b\u0003}\rs!a\u0010\"\u000e\u0003\u0001S!!Q\u001a\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0014B\u0001#9\u0003\u001d\u0001\u0018mY6bO\u0016L!AR$\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\u0011C\u0014!B4sCBD\u0007\u0003\u0002&L\u001bbk\u0011!K\u0005\u0003\u0019&\u0012Qa\u0012:ba\"\u0004\"AT(\r\u0001\u0011)\u0001\u000b\u0001b\u0001#\n\u0011a\u000bR\t\u0003%V\u0003\"aN*\n\u0005QC$a\u0002(pi\"Lgn\u001a\t\u0003oYK!a\u0016\u001d\u0003\u0007\u0005s\u0017\u0010\u0005\u0002O3\u0012)!\f\u0001b\u0001#\n\u0011Q\tR\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004cA/a\u001b6\taL\u0003\u0002`q\u00059!/\u001a4mK\u000e$\u0018BA1_\u0005!\u0019E.Y:t)\u0006<\u0017AC3wS\u0012,gnY3%eA\u0019Q\f\u0019-\u0002\rqJg.\u001b;?)\t1'\u000eF\u0002hQ&\u0004BA\u0013\u0001N1\")1\f\u0002a\u00029\")!\r\u0002a\u0002G\")\u0001\n\u0002a\u0001\u0013\u0006Aa.^7FI\u001e,7/F\u0001n!\t9d.\u0003\u0002pq\t!Aj\u001c8hQ\t)\u0011\u000f\u0005\u00028e&\u00111\u000f\u000f\u0002\niJ\fgn]5f]R\f1B\\;n-\u0016\u0014H/[2fg\"\u0012a!]\u0001\nS:$Um\u001a:fKN,\u0012\u0001\u001f\t\u0004\u0015f\\\u0018B\u0001>*\u0005%1VM\u001d;fqJ#E\t\u0005\u00028y&\u0011Q\u0010\u000f\u0002\u0004\u0013:$\bFA\u0004r\u0003)yW\u000f\u001e#fOJ,Wm\u001d\u0015\u0003\u0011E\fq\u0001Z3he\u0016,7\u000f\u000b\u0002\nc\u0006QA-Z4sK\u0016\u001c(\u000b\u0012#\u0015\u0007a\fY\u0001C\u0004\u0002\u000e)\u0001\r!a\u0004\u0002\u001b\u0015$w-\u001a#je\u0016\u001cG/[8o!\rQ\u0015\u0011C\u0005\u0004\u0003'I#!D#eO\u0016$\u0015N]3di&|g.\u0001\nd_2dWm\u0019;OK&<\u0007NY8s\u0013\u0012\u001cH\u0003BA\r\u0003[\u0001BAS=\u0002\u001cA)q'!\b\u0002\"%\u0019\u0011q\u0004\u001d\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005\r\u0012q\u0005\b\u0004\u0015\u0006\u0015\u0012B\u0001#*\u0013\u0011\tI#a\u000b\u0003\u0011Y+'\u000f^3y\u0013\u0012T!\u0001R\u0015\t\u000f\u000551\u00021\u0001\u0002\u0010\u0005\u00012m\u001c7mK\u000e$h*Z5hQ\n|'o\u001d\u000b\u0005\u0003g\ti\u0004\u0005\u0003Ks\u0006U\u0002#B\u001c\u0002\u001e\u0005]\u0002CB\u001c\u0002:\u0005\u0005R*C\u0002\u0002<a\u0012a\u0001V;qY\u0016\u0014\u0004bBA\u0007\u0019\u0001\u0007\u0011qB\u0001\rG>dG.Z2u\u000b\u0012<Wm\u001d\u000b\u0005\u0003\u0007\ni\u0005\u0005\u0003Ks\u0006\u0015\u0003#B\u001c\u0002\u001e\u0005\u001d\u0003\u0003\u0002&\u0002JaK1!a\u0013*\u0005\u0011)EmZ3\t\u000f\u00055Q\u00021\u0001\u0002\u0010\u0005y!/Z7pm\u0016\u001cV\r\u001c4FI\u001e,7\u000fF\u0001J\u00031Qw.\u001b8WKJ$\u0018nY3t+\u0011\t9&!\u001a\u0015\t\u0005e\u00131\u000f\u000b\u0005\u00037\nI\u0007F\u0002J\u0003;B\u0011\"a\u0018\u0010\u0003\u0003\u0005\u001d!!\u0019\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$3\u0007\u0005\u0003^A\u0006\r\u0004c\u0001(\u0002f\u00111\u0011qM\bC\u0002E\u0013\u0011!\u0016\u0005\b\u0003Wz\u0001\u0019AA7\u0003\u001di\u0017\r\u001d$v]\u000e\u0004\u0012bNA8\u0003Ci\u00151M'\n\u0007\u0005E\u0004HA\u0005Gk:\u001cG/[8og!9\u0011QO\bA\u0002\u0005]\u0014!\u0002;bE2,\u0007CBA=\u0003\u007f\n\u0019)\u0004\u0002\u0002|)\u0019\u0011QP\u0017\u0002\u0007I$G-\u0003\u0003\u0002\u0002\u0006m$a\u0001*E\tB9q'!\u000f\u0002\"\u0005\r\u0014A\u00024jYR,'/\u0006\u0004\u0002\n\u0006U\u0015\u0011\u0015\u000b\t\u0003\u0017\u000b)+!-\u0002DR)\u0011*!$\u0002\u001a\"I\u0011q\u0012\t\u0002\u0002\u0003\u000f\u0011\u0011S\u0001\u000bKZLG-\u001a8dK\u0012\"\u0004\u0003B/a\u0003'\u00032ATAK\t\u0019\t9\n\u0005b\u0001#\n\u0019a\u000b\u0012\u001a\t\u0013\u0005m\u0005#!AA\u0004\u0005u\u0015AC3wS\u0012,gnY3%kA!Q\fYAP!\rq\u0015\u0011\u0015\u0003\u0007\u0003G\u0003\"\u0019A)\u0003\u0007\u0015#%\u0007C\u0004\u0002(B\u0001\r!!+\u0002\u0015A\u0014X\r\u001d:pG\u0016\u001c8\u000f\u0005\u00048\u0003WK\u0015qV\u0005\u0004\u0003[C$!\u0003$v]\u000e$\u0018n\u001c82!\u0019Q5*a%\u0002 \"I\u00111\u0017\t\u0011\u0002\u0003\u0007\u0011QW\u0001\u0006KB\u0014X\r\u001a\t\bo\u0005-\u0016qWA_!\u001dQ\u0015\u0011XAJ\u0003?K1!a/*\u0005-)EmZ3Ue&\u0004H.\u001a;\u0011\u0007]\ny,C\u0002\u0002Bb\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002FB\u0001\n\u00111\u0001\u0002H\u0006)a\u000f\u001d:fIBIq'!3\u0002\"\u0005M\u0015QX\u0005\u0004\u0003\u0017D$!\u0003$v]\u000e$\u0018n\u001c83\u0003A1\u0017\u000e\u001c;fe\u0012\"WMZ1vYR$#'\u0006\u0004\u0002R\u0006m\u0017q\\\u000b\u0003\u0003'TC!!6\u0002bB9q'a+\u0002X\u0006u\u0006c\u0002&\u0002:\u0006e\u0017Q\u001c\t\u0004\u001d\u0006mGABAL#\t\u0007\u0011\u000bE\u0002O\u0003?$a!a)\u0012\u0005\u0004\t6FAAr!\u0011\t)/a<\u000e\u0005\u0005\u001d(\u0002BAu\u0003W\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u00055\b(\u0001\u0006b]:|G/\u0019;j_:LA!!=\u0002h\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002!\u0019LG\u000e^3sI\u0011,g-Y;mi\u0012\u001aTCBA|\u0003\u007f\u0014\t!\u0006\u0002\u0002z*\"\u00111`Aq!%9\u0014\u0011ZA\u0011\u0003{\fi\fE\u0002O\u0003\u007f$a!a&\u0013\u0005\u0004\tFABAR%\t\u0007\u0011+\u0001\tqS\u000e\\'+\u00198e_64VM\u001d;fqR\u0011\u0011\u0011E\u0001\u0018G>tg/\u001a:u)>\u001c\u0015M\\8oS\u000e\fG.\u00123hKN$2!\u0013B\u0006\u0011%\u0011i\u0001\u0006I\u0001\u0002\u0004\u0011y!A\u0005nKJ<WMR;oGB1q'!3Y1b\u000b\u0011eY8om\u0016\u0014H\u000fV8DC:|g.[2bY\u0016#w-Z:%I\u00164\u0017-\u001e7uIE*\"A!\u0006+\t\t=\u0011\u0011]\u0001\u0007aJ,w-\u001a7\u0016\t\tm!\u0011\u0006\u000b\t\u0005;\u0011IE!\u0014\u0003RQA!q\u0004B\u0017\u0005g\u0011\u0019\u0005F\u0002J\u0005CA\u0011Ba\t\u0017\u0003\u0003\u0005\u001dA!\n\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$c\u0007\u0005\u0003^A\n\u001d\u0002c\u0001(\u0003*\u00111!1\u0006\fC\u0002E\u0013\u0011!\u0011\u0005\b\u0005_1\u0002\u0019\u0001B\u0019\u0003\u00151\bO]8h!%9\u0014qNA\u0011\u001b\n\u001dR\nC\u0004\u00036Y\u0001\rAa\u000e\u0002\u000fM,g\u000eZ'tOB9q'a+\u0003:\tm\u0002#\u0002&\u0002:6C\u0006#B\u001f\u0003>\t\u0005\u0013b\u0001B \u000f\nA\u0011\n^3sCR|'\u000fE\u00048\u0003s\t\tCa\n\t\u000f\t\u0015c\u00031\u0001\u0003H\u0005AQ.\u001a:hK6\u001bx\rE\u00058\u0003\u0013\u00149Ca\n\u0003(!9!1\n\fA\u0002\t\u001d\u0012AC5oSRL\u0017\r\\'tO\"A!q\n\f\u0011\u0002\u0003\u000710A\u0007nCbLE/\u001a:bi&|gn\u001d\u0005\n\u0005'2\u0002\u0013!a\u0001\u0003\u001f\tq\"Y2uSZ,G)\u001b:fGRLwN\\\u0001\u0011aJ,w-\u001a7%I\u00164\u0017-\u001e7uII*BA!\u0017\u0003^U\u0011!1\f\u0016\u0004w\u0006\u0005HA\u0002B\u0016/\t\u0007\u0011+\u0001\tqe\u0016<W\r\u001c\u0013eK\u001a\fW\u000f\u001c;%gU!!1\rB4+\t\u0011)G\u000b\u0003\u0002\u0010\u0005\u0005HA\u0002B\u00161\t\u0007\u0011+\u0001\u0005qC\u001e,'+\u00198l)\u0019\u0011iG!\u001e\u0003zA1!j\u0013B8\u0005_\u00022a\u000eB9\u0013\r\u0011\u0019\b\u000f\u0002\u0007\t>,(\r\\3\t\u000f\t]\u0014\u00041\u0001\u0003p\u0005\u0019Ao\u001c7\t\u0013\tm\u0014\u0004%AA\u0002\t=\u0014!\u0003:fg\u0016$\bK]8c\u0003I\u0001\u0018mZ3SC:\\G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t\u0005%\u0006\u0002B8\u0003C\fA\u0003]3sg>t\u0017\r\\5{K\u0012\u0004\u0016mZ3SC:\\G\u0003\u0003B7\u0005\u000f\u0013YI!$\t\u000f\t%5\u00041\u0001\u0002\"\u0005\u00191O]2\t\u000f\t]4\u00041\u0001\u0003p!I!1P\u000e\u0011\u0002\u0003\u0007!qN\u0001\u001fa\u0016\u00148o\u001c8bY&TX\r\u001a)bO\u0016\u0014\u0016M\\6%I\u00164\u0017-\u001e7uIM\n!e\u001d;bi&\u001c\u0007+\u0019:bY2,G\u000eU3sg>t\u0017\r\\5{K\u0012\u0004\u0016mZ3SC:\\G\u0003\u0003BK\u0005O\u0013YKa,\u0011\r)[%q\u0013B8!\u0011\u0011IJa)\u000e\u0005\tm%\u0002\u0002BO\u0005?\u000ba\u0001\\5oC2<'b\u0001BQ[\u0005\u0011Q\u000e\\\u0005\u0005\u0005K\u0013YJ\u0001\u0004WK\u000e$xN\u001d\u0005\b\u0005Sk\u0002\u0019AA\u000e\u0003\u001d\u0019x.\u001e:dKNDaA!,\u001e\u0001\u0004Y\u0018a\u00028v[&#XM\u001d\u0005\n\u0005wj\u0002\u0013!a\u0001\u0005_\nAf\u001d;bi&\u001c\u0007+\u0019:bY2,G\u000eU3sg>t\u0017\r\\5{K\u0012\u0004\u0016mZ3SC:\\G\u0005Z3gCVdG\u000fJ\u001a\u00025M$\u0018\r^5d!\u0016\u00148o\u001c8bY&TX\r\u001a)bO\u0016\u0014\u0016M\\6\u0015\u0011\t5$q\u0017B]\u0005wCqA!# \u0001\u0004\t\t\u0003\u0003\u0004\u0003.~\u0001\ra\u001f\u0005\n\u0005wz\u0002\u0013!a\u0001\u0005_\nAe\u001d;bi&\u001c\u0007+\u001a:t_:\fG.\u001b>fIB\u000bw-\u001a*b].$C-\u001a4bk2$HeM\u0001\u000fgR\fG/[2QC\u001e,'+\u00198l)\u0019\u0011iGa1\u0003F\"1!QV\u0011A\u0002mD\u0011Ba\u001f\"!\u0003\u0005\rAa\u001c\u00021M$\u0018\r^5d!\u0006<WMU1oW\u0012\"WMZ1vYR$#\u0007\u0006\u0005\u0003n\t-'Q\u001aBh\u0011\u0019\u0011ik\ta\u0001w\"9!1P\u0012A\u0002\t=\u0004b\u0002BiG\u0001\u0007!QN\u0001\faJ,\u0007+Y4f%\u0006t7.A\nd_:tWm\u0019;fI\u000e{W\u000e]8oK:$8\u000f\u0006\u0002\u0003XB)!jSA\u00111R!!q\u001bBn\u0011\u0019\u0011y%\na\u0001w\u0006iAO]5b]\u001edWmQ8v]R$\"A!9\u0011\t)[5\u0010W\u0001\u001cgR\u0014xN\\4ms\u000e{gN\\3di\u0016$7i\\7q_:,g\u000e^:\u0015\t\t]'q\u001d\u0005\u0007\u0005[;\u0003\u0019A>")
public class GraphOps<VD, ED>
implements Serializable {
    private transient long numEdges;
    private transient long numVertices;
    private transient VertexRDD<Object> inDegrees;
    private transient VertexRDD<Object> outDegrees;
    private transient VertexRDD<Object> degrees;
    private final Graph<VD, ED> graph;
    private final ClassTag<VD> evidence$1;
    private final ClassTag<ED> evidence$2;
    private volatile transient byte bitmap$trans$0;

    private long numEdges$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.numEdges = this.graph.edges().count();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.numEdges;
    }

    public long numEdges() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.numEdges$lzycompute();
        }
        return this.numEdges;
    }

    private long numVertices$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.numVertices = this.graph.vertices().count();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.numVertices;
    }

    public long numVertices() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.numVertices$lzycompute();
        }
        return this.numVertices;
    }

    private VertexRDD<Object> inDegrees$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.inDegrees = (VertexRDD)this.degreesRDD(EdgeDirection$.MODULE$.In()).setName("GraphOps.inDegrees");
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.inDegrees;
    }

    public VertexRDD<Object> inDegrees() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.inDegrees$lzycompute();
        }
        return this.inDegrees;
    }

    private VertexRDD<Object> outDegrees$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.outDegrees = (VertexRDD)this.degreesRDD(EdgeDirection$.MODULE$.Out()).setName("GraphOps.outDegrees");
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.outDegrees;
    }

    public VertexRDD<Object> outDegrees() {
        if ((byte)(this.bitmap$trans$0 & 8) == 0) {
            return this.outDegrees$lzycompute();
        }
        return this.outDegrees;
    }

    private VertexRDD<Object> degrees$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.degrees = (VertexRDD)this.degreesRDD(EdgeDirection$.MODULE$.Either()).setName("GraphOps.degrees");
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.degrees;
    }

    public VertexRDD<Object> degrees() {
        if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
            return this.degrees$lzycompute();
        }
        return this.degrees;
    }

    private VertexRDD<Object> degreesRDD(EdgeDirection edgeDirection) {
        EdgeDirection edgeDirection2 = edgeDirection;
        EdgeDirection edgeDirection3 = EdgeDirection$.MODULE$.In();
        if (!(edgeDirection2 != null ? !((Object)edgeDirection2).equals(edgeDirection3) : edgeDirection3 != null)) {
            return this.graph.aggregateMessages((Function1 & Serializable)x$1 -> {
                x$1.sendToDst(BoxesRunTime.boxToInteger((int)1));
                return BoxedUnit.UNIT;
            }, (JFunction2.mcIII.sp & Serializable)(x$2, x$3) -> x$2 + x$3, TripletFields.None, ClassTag$.MODULE$.Int());
        }
        EdgeDirection edgeDirection4 = edgeDirection;
        EdgeDirection edgeDirection5 = EdgeDirection$.MODULE$.Out();
        if (!(edgeDirection4 != null ? !((Object)edgeDirection4).equals(edgeDirection5) : edgeDirection5 != null)) {
            return this.graph.aggregateMessages((Function1 & Serializable)x$4 -> {
                x$4.sendToSrc(BoxesRunTime.boxToInteger((int)1));
                return BoxedUnit.UNIT;
            }, (JFunction2.mcIII.sp & Serializable)(x$5, x$6) -> x$5 + x$6, TripletFields.None, ClassTag$.MODULE$.Int());
        }
        return this.graph.aggregateMessages((Function1 & Serializable)ctx -> {
            GraphOps.$anonfun$degreesRDD$5(ctx);
            return BoxedUnit.UNIT;
        }, (JFunction2.mcIII.sp & Serializable)(x$7, x$8) -> x$7 + x$8, TripletFields.None, ClassTag$.MODULE$.Int());
    }

    public VertexRDD<long[]> collectNeighborIds(EdgeDirection edgeDirection) {
        VertexRDD vertexRDD;
        EdgeDirection edgeDirection2 = edgeDirection;
        EdgeDirection edgeDirection3 = EdgeDirection$.MODULE$.Either();
        if (!(edgeDirection2 != null ? !((Object)edgeDirection2).equals(edgeDirection3) : edgeDirection3 != null)) {
            vertexRDD = this.graph.aggregateMessages((Function1 & Serializable)ctx -> {
                GraphOps.$anonfun$collectNeighborIds$1(ctx);
                return BoxedUnit.UNIT;
            }, (Function2 & Serializable)(x$9, x$10) -> (long[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.longArrayOps(x$9), x$10, (ClassTag)ClassTag$.MODULE$.Long()), TripletFields.None, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
        } else {
            EdgeDirection edgeDirection4 = edgeDirection;
            EdgeDirection edgeDirection5 = EdgeDirection$.MODULE$.Out();
            if (!(edgeDirection4 != null ? !((Object)edgeDirection4).equals(edgeDirection5) : edgeDirection5 != null)) {
                vertexRDD = this.graph.aggregateMessages((Function1 & Serializable)ctx -> {
                    ctx.sendToSrc(new long[]{ctx.dstId()});
                    return BoxedUnit.UNIT;
                }, (Function2 & Serializable)(x$11, x$12) -> (long[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.longArrayOps(x$11), x$12, (ClassTag)ClassTag$.MODULE$.Long()), TripletFields.None, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
            } else {
                EdgeDirection edgeDirection6 = edgeDirection;
                EdgeDirection edgeDirection7 = EdgeDirection$.MODULE$.In();
                if (!(edgeDirection6 != null ? !((Object)edgeDirection6).equals(edgeDirection7) : edgeDirection7 != null)) {
                    vertexRDD = this.graph.aggregateMessages((Function1 & Serializable)ctx -> {
                        ctx.sendToDst(new long[]{ctx.srcId()});
                        return BoxedUnit.UNIT;
                    }, (Function2 & Serializable)(x$13, x$14) -> (long[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.longArrayOps(x$13), x$14, (ClassTag)ClassTag$.MODULE$.Long()), TripletFields.None, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
                } else {
                    throw new SparkException("It doesn't make sense to collect neighbor ids without a direction. (EdgeDirection.Both is not supported; use EdgeDirection.Either instead.)");
                }
            }
        }
        VertexRDD nbrs = vertexRDD;
        return this.graph.vertices().leftZipJoin(nbrs, (Function3 & Serializable)(x$15, x$16, nbrsOpt) -> GraphOps.$anonfun$collectNeighborIds$7(BoxesRunTime.unboxToLong((Object)x$15), x$16, nbrsOpt), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
    }

    public VertexRDD<Tuple2<Object, VD>[]> collectNeighbors(EdgeDirection edgeDirection) {
        VertexRDD vertexRDD;
        EdgeDirection edgeDirection2 = edgeDirection;
        EdgeDirection edgeDirection3 = EdgeDirection$.MODULE$.Either();
        EdgeDirection edgeDirection4 = edgeDirection2;
        if (!(edgeDirection3 != null ? !((Object)edgeDirection3).equals(edgeDirection4) : edgeDirection4 != null)) {
            vertexRDD = this.graph.aggregateMessages((Function1 & Serializable)ctx -> {
                GraphOps.$anonfun$collectNeighbors$1(ctx);
                return BoxedUnit.UNIT;
            }, (Function2 & Serializable)(a, b) -> (Tuple2[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])a), b, ClassTag$.MODULE$.apply(Tuple2.class)), TripletFields.All, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
        } else {
            EdgeDirection edgeDirection5 = EdgeDirection$.MODULE$.In();
            EdgeDirection edgeDirection6 = edgeDirection2;
            if (!(edgeDirection5 != null ? !((Object)edgeDirection5).equals(edgeDirection6) : edgeDirection6 != null)) {
                vertexRDD = this.graph.aggregateMessages((Function1 & Serializable)ctx -> {
                    ctx.sendToDst((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)ctx.srcId()), ctx.srcAttr())});
                    return BoxedUnit.UNIT;
                }, (Function2 & Serializable)(a, b) -> (Tuple2[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])a), b, ClassTag$.MODULE$.apply(Tuple2.class)), TripletFields.Src, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
            } else {
                EdgeDirection edgeDirection7 = EdgeDirection$.MODULE$.Out();
                EdgeDirection edgeDirection8 = edgeDirection2;
                if (!(edgeDirection7 != null ? !((Object)edgeDirection7).equals(edgeDirection8) : edgeDirection8 != null)) {
                    vertexRDD = this.graph.aggregateMessages((Function1 & Serializable)ctx -> {
                        ctx.sendToSrc((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)ctx.dstId()), ctx.dstAttr())});
                        return BoxedUnit.UNIT;
                    }, (Function2 & Serializable)(a, b) -> (Tuple2[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])a), b, ClassTag$.MODULE$.apply(Tuple2.class)), TripletFields.Dst, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
                } else {
                    EdgeDirection edgeDirection9 = EdgeDirection$.MODULE$.Both();
                    EdgeDirection edgeDirection10 = edgeDirection2;
                    if (!(edgeDirection9 != null ? !((Object)edgeDirection9).equals(edgeDirection10) : edgeDirection10 != null)) {
                        throw new SparkException("collectEdges does not support EdgeDirection.Both. UseEdgeDirection.Either instead.");
                    }
                    throw new SparkException("Unknown edge direction");
                }
            }
        }
        VertexRDD nbrs = vertexRDD;
        return this.graph.vertices().leftJoin(nbrs, (Function3 & Serializable)(x$17, x$18, nbrsOpt) -> GraphOps.$anonfun$collectNeighbors$7(BoxesRunTime.unboxToLong((Object)x$17), x$18, nbrsOpt), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
    }

    public VertexRDD<Edge<ED>[]> collectEdges(EdgeDirection edgeDirection) {
        EdgeDirection edgeDirection2 = edgeDirection;
        EdgeDirection edgeDirection3 = EdgeDirection$.MODULE$.Either();
        EdgeDirection edgeDirection4 = edgeDirection2;
        if (!(edgeDirection3 != null ? !((Object)edgeDirection3).equals(edgeDirection4) : edgeDirection4 != null)) {
            return this.graph.aggregateMessages((Function1 & Serializable)ctx -> {
                GraphOps.$anonfun$collectEdges$1(ctx);
                return BoxedUnit.UNIT;
            }, (Function2 & Serializable)(a, b) -> (Edge[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])a), b, ClassTag$.MODULE$.apply(Edge.class)), TripletFields.EdgeOnly, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Edge.class)));
        }
        EdgeDirection edgeDirection5 = EdgeDirection$.MODULE$.In();
        EdgeDirection edgeDirection6 = edgeDirection2;
        if (!(edgeDirection5 != null ? !((Object)edgeDirection5).equals(edgeDirection6) : edgeDirection6 != null)) {
            return this.graph.aggregateMessages((Function1 & Serializable)ctx -> {
                ctx.sendToDst((Object[])new Edge[]{new Edge(ctx.srcId(), ctx.dstId(), ctx.attr())});
                return BoxedUnit.UNIT;
            }, (Function2 & Serializable)(a, b) -> (Edge[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])a), b, ClassTag$.MODULE$.apply(Edge.class)), TripletFields.EdgeOnly, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Edge.class)));
        }
        EdgeDirection edgeDirection7 = EdgeDirection$.MODULE$.Out();
        EdgeDirection edgeDirection8 = edgeDirection2;
        if (!(edgeDirection7 != null ? !((Object)edgeDirection7).equals(edgeDirection8) : edgeDirection8 != null)) {
            return this.graph.aggregateMessages((Function1 & Serializable)ctx -> {
                ctx.sendToSrc((Object[])new Edge[]{new Edge(ctx.srcId(), ctx.dstId(), ctx.attr())});
                return BoxedUnit.UNIT;
            }, (Function2 & Serializable)(a, b) -> (Edge[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])a), b, ClassTag$.MODULE$.apply(Edge.class)), TripletFields.EdgeOnly, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Edge.class)));
        }
        EdgeDirection edgeDirection9 = EdgeDirection$.MODULE$.Both();
        EdgeDirection edgeDirection10 = edgeDirection2;
        if (!(edgeDirection9 != null ? !((Object)edgeDirection9).equals(edgeDirection10) : edgeDirection10 != null)) {
            throw new SparkException("collectEdges does not support EdgeDirection.Both. UseEdgeDirection.Either instead.");
        }
        throw new SparkException("Unknown edge direction");
    }

    public Graph<VD, ED> removeSelfEdges() {
        return this.graph.subgraph((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)GraphOps.$anonfun$removeSelfEdges$1(e)), this.graph.subgraph$default$2());
    }

    public <U> Graph<VD, ED> joinVertices(RDD<Tuple2<Object, U>> table, Function3<Object, VD, U, VD> mapFunc, ClassTag<U> evidence$3) {
        Function3 & Serializable uf = (Function3 & Serializable)(id, data, o) -> GraphOps.$anonfun$joinVertices$1(mapFunc, BoxesRunTime.unboxToLong((Object)id), data, o);
        return this.graph.outerJoinVertices(table, uf, evidence$3, this.evidence$1, $less$colon$less$.MODULE$.refl());
    }

    public <VD2, ED2> Graph<VD, ED> filter(Function1<Graph<VD, ED>, Graph<VD2, ED2>> preprocess, Function1<EdgeTriplet<VD2, ED2>, Object> epred, Function2<Object, VD2, Object> vpred, ClassTag<VD2> evidence$4, ClassTag<ED2> evidence$5) {
        return this.graph.mask(((Graph)preprocess.apply(this.graph)).subgraph(epred, vpred), evidence$4, evidence$5);
    }

    public <VD2, ED2> Function1<EdgeTriplet<VD2, ED2>, Object> filter$default$2() {
        return (Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)GraphOps.$anonfun$filter$default$2$1(x$19));
    }

    public <VD2, ED2> Function2<Object, VD2, Object> filter$default$3() {
        return (Function2 & Serializable)(x$20, x$21) -> BoxesRunTime.boxToBoolean((boolean)GraphOps.$anonfun$filter$default$3$1(BoxesRunTime.unboxToLong((Object)x$20), x$21));
    }

    public long pickRandomVertex() {
        double probability = 50.0 / (double)Graph$.MODULE$.graphToGraphOps(this.graph, this.evidence$1, this.evidence$2).numVertices();
        boolean found = false;
        long retVal = BoxesRunTime.unboxToLong(null);
        while (!found) {
            RDD selectedVertices = this.graph.vertices().flatMap((Function1 & Serializable)vidVvals -> {
                if (Random$.MODULE$.nextDouble() < probability) {
                    return new Some((Object)BoxesRunTime.boxToLong((long)vidVvals._1$mcJ$sp()));
                }
                return None$.MODULE$;
            }, ClassTag$.MODULE$.apply(Long.TYPE));
            if (selectedVertices.count() <= 0L) continue;
            found = true;
            long[] collectedVertices = (long[])selectedVertices.collect();
            retVal = collectedVertices[Random$.MODULE$.nextInt(collectedVertices.length)];
        }
        return retVal;
    }

    public Graph<VD, ED> convertToCanonicalEdges(Function2<ED, ED, ED> mergeFunc) {
        RDD newEdges = RDD$.MODULE$.rddToPairRDDFunctions(this.graph.edges().map((Function1 & Serializable)x0$1 -> {
            Edge edge = x0$1;
            if (edge.srcId() < edge.dstId()) {
                return new Tuple2((Object)new Tuple2.mcJJ.sp(edge.srcId(), edge.dstId()), edge.attr());
            }
            return new Tuple2((Object)new Tuple2.mcJJ.sp(edge.dstId(), edge.srcId()), edge.attr());
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), this.evidence$2, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$)).reduceByKey(mergeFunc).map((Function1 & Serializable)e -> new Edge<Object>(((Tuple2)e._1())._1$mcJ$sp(), ((Tuple2)e._1())._2$mcJ$sp(), e._2()), ClassTag$.MODULE$.apply(Edge.class));
        return Graph$.MODULE$.apply(this.graph.vertices(), newEdges, Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), this.evidence$1, this.evidence$2);
    }

    public Function2<ED, ED, ED> convertToCanonicalEdges$default$1() {
        return (Function2 & Serializable)(e1, x$22) -> e1;
    }

    public <A> Graph<VD, ED> pregel(A initialMsg, int maxIterations, EdgeDirection activeDirection, Function3<Object, VD, A, VD> vprog, Function1<EdgeTriplet<VD, ED>, Iterator<Tuple2<Object, A>>> sendMsg, Function2<A, A, A> mergeMsg, ClassTag<A> evidence$6) {
        return Pregel$.MODULE$.apply(this.graph, initialMsg, maxIterations, activeDirection, vprog, sendMsg, mergeMsg, this.evidence$1, this.evidence$2, evidence$6);
    }

    public <A> int pregel$default$2() {
        return Integer.MAX_VALUE;
    }

    public <A> EdgeDirection pregel$default$3() {
        return EdgeDirection$.MODULE$.Either();
    }

    public Graph<Object, Object> pageRank(double tol, double resetProb) {
        return PageRank$.MODULE$.runUntilConvergence(this.graph, tol, resetProb, this.evidence$1, this.evidence$2);
    }

    public double pageRank$default$2() {
        return 0.15;
    }

    public Graph<Object, Object> personalizedPageRank(long src, double tol, double resetProb) {
        return PageRank$.MODULE$.runUntilConvergenceWithOptions(this.graph, tol, resetProb, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)src)), this.evidence$1, this.evidence$2);
    }

    public double personalizedPageRank$default$3() {
        return 0.15;
    }

    public Graph<Vector, Object> staticParallelPersonalizedPageRank(long[] sources, int numIter, double resetProb) {
        return PageRank$.MODULE$.runParallelPersonalizedPageRank(this.graph, numIter, resetProb, sources, this.evidence$1, this.evidence$2);
    }

    public double staticParallelPersonalizedPageRank$default$3() {
        return 0.15;
    }

    public Graph<Object, Object> staticPersonalizedPageRank(long src, int numIter, double resetProb) {
        return PageRank$.MODULE$.runWithOptions(this.graph, numIter, resetProb, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)src)), this.evidence$1, this.evidence$2);
    }

    public double staticPersonalizedPageRank$default$3() {
        return 0.15;
    }

    public Graph<Object, Object> staticPageRank(int numIter, double resetProb) {
        return PageRank$.MODULE$.run(this.graph, numIter, resetProb, this.evidence$1, this.evidence$2);
    }

    public Graph<Object, Object> staticPageRank(int numIter, double resetProb, Graph<Object, Object> prePageRank) {
        return PageRank$.MODULE$.runWithOptionsWithPreviousPageRank(this.graph, numIter, resetProb, (Option<Object>)None$.MODULE$, prePageRank, this.evidence$1, this.evidence$2);
    }

    public double staticPageRank$default$2() {
        return 0.15;
    }

    public Graph<Object, ED> connectedComponents() {
        return ConnectedComponents$.MODULE$.run(this.graph, this.evidence$1, this.evidence$2);
    }

    public Graph<Object, ED> connectedComponents(int maxIterations) {
        return ConnectedComponents$.MODULE$.run(this.graph, maxIterations, this.evidence$1, this.evidence$2);
    }

    public Graph<Object, ED> triangleCount() {
        return TriangleCount$.MODULE$.run(this.graph, this.evidence$1, this.evidence$2);
    }

    public Graph<Object, ED> stronglyConnectedComponents(int numIter) {
        return StronglyConnectedComponents$.MODULE$.run(this.graph, numIter, this.evidence$1, this.evidence$2);
    }

    public static final /* synthetic */ void $anonfun$degreesRDD$5(EdgeContext ctx) {
        ctx.sendToSrc(BoxesRunTime.boxToInteger((int)1));
        ctx.sendToDst(BoxesRunTime.boxToInteger((int)1));
    }

    public static final /* synthetic */ void $anonfun$collectNeighborIds$1(EdgeContext ctx) {
        ctx.sendToSrc(new long[]{ctx.dstId()});
        ctx.sendToDst(new long[]{ctx.srcId()});
    }

    public static final /* synthetic */ long[] $anonfun$collectNeighborIds$7(long x$15, Object x$16, Option nbrsOpt) {
        return (long[])nbrsOpt.getOrElse((Function0 & Serializable)() -> (long[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Long.TYPE)));
    }

    public static final /* synthetic */ void $anonfun$collectNeighbors$1(EdgeContext ctx) {
        ctx.sendToSrc((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)ctx.dstId()), ctx.dstAttr())});
        ctx.sendToDst((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)ctx.srcId()), ctx.srcAttr())});
    }

    public static final /* synthetic */ Tuple2[] $anonfun$collectNeighbors$7(long x$17, Object x$18, Option nbrsOpt) {
        return (Tuple2[])nbrsOpt.getOrElse((Function0 & Serializable)() -> (Tuple2[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public static final /* synthetic */ void $anonfun$collectEdges$1(EdgeContext ctx) {
        ctx.sendToSrc((Object[])new Edge[]{new Edge(ctx.srcId(), ctx.dstId(), ctx.attr())});
        ctx.sendToDst((Object[])new Edge[]{new Edge(ctx.srcId(), ctx.dstId(), ctx.attr())});
    }

    public static final /* synthetic */ boolean $anonfun$removeSelfEdges$1(EdgeTriplet e) {
        return e.srcId() != e.dstId();
    }

    public static final /* synthetic */ Object $anonfun$joinVertices$1(Function3 mapFunc$1, long id, Object data, Option o) {
        Option option = o;
        if (option instanceof Some) {
            Some some = (Some)option;
            Object u = some.value();
            return mapFunc$1.apply((Object)BoxesRunTime.boxToLong((long)id), data, u);
        }
        if (None$.MODULE$.equals(option)) {
            return data;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$filter$default$2$1(EdgeTriplet x$19) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$filter$default$3$1(long x$20, Object x$21) {
        return true;
    }

    public GraphOps(Graph<VD, ED> graph, ClassTag<VD> evidence$1, ClassTag<ED> evidence$2) {
        this.graph = graph;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
    }
}

