/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.qtplain;

import org.tinspin.index.Index;
import org.tinspin.index.PointDistance;

class QUtil {
    static final double EPS_MUL = 1.000000001;

    private QUtil() {
    }

    public static boolean isPointEnclosed(double[] point, double[] min2, double[] max) {
        for (int d = 0; d < min2.length; ++d) {
            if (!(point[d] < min2[d]) && !(point[d] > max[d])) continue;
            return false;
        }
        return true;
    }

    public static boolean fitsIntoNode(double[] point, double[] center, double radius) {
        for (int d = 0; d < center.length; ++d) {
            if (!(point[d] < center[d] - radius) && !(point[d] >= center[d] + radius)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPointEqual(double[] p1, double[] p2) {
        for (int d = 0; d < p1.length; ++d) {
            if (p1[d] == p2[d]) continue;
            return false;
        }
        return true;
    }

    public static boolean isRectEqual(double[] p1L, double[] p1U, double[] p2L, double[] p2U) {
        return QUtil.isPointEqual(p1L, p2L) && QUtil.isPointEqual(p1U, p2U);
    }

    public static boolean isRectEqual(Index.BoxEntry<?> e, double[] keyL, double[] keyU) {
        return QUtil.isRectEqual(e.min(), e.max(), keyL, keyU);
    }

    public static boolean isRectEqual(Index.BoxEntry<?> e, Index.BoxEntry<?> e2) {
        return QUtil.isRectEqual(e.min(), e.max(), e2.min(), e2.max());
    }

    public static boolean overlap(double[] min2, double[] max, double[] min22, double[] max2) {
        for (int d = 0; d < min2.length; ++d) {
            if (!(max[d] < min22[d]) && !(min2[d] > max2[d])) continue;
            return false;
        }
        return true;
    }

    public static boolean overlap(double[] min2, double[] max, double[] center, double radius) {
        for (int d = 0; d < min2.length; ++d) {
            if (!(max[d] < center[d] - radius) && !(min2[d] > center[d] + radius)) continue;
            return false;
        }
        return true;
    }

    public static boolean overlap(double[] center, double radius, double[] center2, double radius2) {
        for (int d = 0; d < center.length; ++d) {
            if (!(center[d] + radius < center2[d] - radius2) && !(center[d] - radius > center2[d] + radius2)) continue;
            return false;
        }
        return true;
    }

    public static boolean fitsIntoNode(double[] minEnclosed, double[] maxEnclosed, double[] centerNode, double radiusNode) {
        for (int d = 0; d < centerNode.length; ++d) {
            if (!(centerNode[d] + radiusNode <= maxEnclosed[d]) && !(centerNode[d] - radiusNode > minEnclosed[d])) continue;
            return false;
        }
        return true;
    }

    public static boolean isNodeEnclosed(double[] centerEnclosed, double radiusEnclosed, double[] centerOuter, double radiusOuter) {
        for (int d = 0; d < centerOuter.length; ++d) {
            if (!(centerOuter[d] + radiusOuter < centerEnclosed[d] + radiusEnclosed) && !(centerOuter[d] - radiusOuter > centerEnclosed[d] - radiusEnclosed)) continue;
            return false;
        }
        return true;
    }

    public static double distance(double[] p1, double[] p2) {
        double dist = 0.0;
        for (int i = 0; i < p1.length; ++i) {
            double d = p1[i] - p2[i];
            dist += d * d;
        }
        return Math.sqrt(dist);
    }

    static double distToRectEdge(double[] point, double[] rLower, double[] rUpper) {
        double dist = 0.0;
        for (int i = 0; i < point.length; ++i) {
            double d = 0.0;
            if (point[i] > rUpper[i]) {
                d = point[i] - rUpper[i];
            } else if (point[i] < rLower[i]) {
                d = rLower[i] - point[i];
            }
            dist += d * d;
        }
        return Math.sqrt(dist);
    }

    public static double distToRectEdge(double[] p, Index.BoxEntry<?> e) {
        return QUtil.distToRectEdge(p, e.min(), e.max());
    }

    static double distToRectNode(double[] point, double[] nodeCenter, double nodeRadius, PointDistance distFn) {
        double[] dist = new double[point.length];
        for (int i = 0; i < point.length; ++i) {
            double d = point[i];
            if (point[i] > nodeCenter[i] + nodeRadius) {
                d = nodeCenter[i] + nodeRadius;
            } else if (point[i] < nodeCenter[i] - nodeRadius) {
                d = nodeCenter[i] - nodeRadius;
            }
            dist[i] = d;
        }
        return distFn.dist(dist, point);
    }

    static double distToRectNodeEDGE(double[] point, double[] nodeCenter, double nodeRadius) {
        double[] dist = new double[point.length];
        for (int i = 0; i < point.length; ++i) {
            double d = point[i];
            if (point[i] > nodeCenter[i] + nodeRadius) {
                d = nodeCenter[i] + nodeRadius;
            } else if (point[i] < nodeCenter[i] - nodeRadius) {
                d = nodeCenter[i] - nodeRadius;
            }
            dist[i] = d;
        }
        return PointDistance.L2.dist(point, dist);
    }
}

