/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.triangulate;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class HashSet<T> {
    private Entry<T>[] table;
    private int count;
    private int threshold;
    private float loadFactor;
    private ArrayList<Entry<T>> entryCache;

    public HashSet() {
        this(20, 0.75f);
    }

    public HashSet(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
        this.entryCache = new ArrayList(initialCapacity);
    }

    public HashSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(T o) {
        if (o == null) {
            return false;
        }
        int hash = o.hashCode();
        Entry<T>[] tab = this.table;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<T> e = tab[index];
        while (e != null) {
            if (e.hash == hash && (o == e.value || o.equals(e.value))) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public void retainAll(HashSet<T> set) {
        if (set == null) {
            return;
        }
        for (int i = 0; i < this.table.length; ++i) {
            Entry<T> e = this.table[i];
            while (e != null) {
                Entry next = e.next;
                if (!set.contains(e.value)) {
                    this.remove(e.value);
                }
                e = next;
            }
        }
    }

    public void retainAll(HashSet<T> set, HashSet<T> diff) {
        if (set == null) {
            return;
        }
        if (diff == null) {
            this.retainAll(set);
        } else {
            for (int i = 0; i < this.table.length; ++i) {
                Entry<T> e = this.table[i];
                while (e != null) {
                    Entry next = e.next;
                    if (!set.contains(e.value)) {
                        diff.add(e.value);
                        this.remove(e.value);
                    }
                    e = next;
                }
            }
        }
    }

    public boolean add(T o) {
        if (o == null) {
            return false;
        }
        int hash = o.hashCode();
        Entry<T>[] tab = this.table;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<T> e = tab[index];
        while (e != null) {
            if (e.hash == hash && (o == e.value || o.equals(e.value))) {
                return false;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        e = this.getNewEntry();
        e.set(hash, o, tab[index]);
        tab[index] = e;
        ++this.count;
        return true;
    }

    public boolean remove(T o) {
        if (o == null) {
            return false;
        }
        Entry<T>[] tab = this.table;
        int hash = o.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<T> e = tab[index];
        Entry<T> prev = null;
        while (e != null) {
            if (e.hash == hash && (o == e.value || o.equals(e.value))) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                e.value = null;
                this.releaseEntry(e);
                return true;
            }
            prev = e;
            e = e.next;
        }
        return false;
    }

    public void clear() {
        if (this.count == 0) {
            return;
        }
        Entry<T>[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            Entry<T> e = tab[index];
            if (e == null) continue;
            while (e.next != null) {
                e.value = null;
                this.releaseEntry(e);
                Entry n = e.next;
                e.next = null;
                e = n;
            }
            e.value = null;
            this.releaseEntry(e);
            tab[index] = null;
        }
        this.count = 0;
    }

    public boolean addAll(Collection<T> c) {
        boolean modified = false;
        Iterator<T> e = c.iterator();
        while (e.hasNext()) {
            if (!this.add(e.next())) continue;
            modified = true;
        }
        return modified;
    }

    public boolean addAll(HashSet<T> hs) {
        boolean modified = false;
        Entry<T>[] table = hs.table;
        for (int i = 0; i < table.length; ++i) {
            Entry<T> e = table[i];
            while (e != null) {
                if (this.add(e.value)) {
                    modified = true;
                }
                e = e.next;
            }
        }
        return modified;
    }

    public boolean removeAll(Collection<T> c) {
        if (c.size() == 0) {
            return false;
        }
        boolean modified = false;
        for (T obj : c) {
            if (!this.remove(obj)) continue;
            modified = true;
        }
        return modified;
    }

    public boolean removeAll(HashSet<T> hs) {
        boolean modified = false;
        Entry<T>[] table = hs.table;
        for (int i = 0; i < table.length; ++i) {
            Entry<T> e = table[i];
            while (e != null) {
                if (this.remove(e.value)) {
                    modified = true;
                }
                e = e.next;
            }
        }
        return modified;
    }

    public Object[] toArray() {
        Object[] ret_val = new Object[this.count];
        int cnt = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry<T> e = this.table[i];
            while (e != null) {
                ret_val[cnt++] = e.value;
                e = e.next;
            }
        }
        return ret_val;
    }

    public T[] toArray(T[] array) {
        int size = this.count;
        if (array.length < size) {
            Class<?> cls = array.getClass();
            array = (Object[])Array.newInstance(cls.getComponentType(), size);
        }
        int cnt = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry<T> e = this.table[i];
            while (e != null) {
                array[cnt++] = e.value;
                e = e.next;
            }
        }
        return array;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HashSet)) {
            return false;
        }
        HashSet hs = (HashSet)o;
        if (hs.size() != this.size()) {
            return false;
        }
        boolean ret_val = true;
        block0: for (int i = 0; i < this.table.length; ++i) {
            Entry<T> e = this.table[i];
            while (e != null) {
                if (!hs.contains(e.value)) {
                    ret_val = false;
                    continue block0;
                }
                e = e.next;
            }
        }
        return ret_val;
    }

    public int hashCode() {
        int h2 = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry<T> e = this.table[i];
            while (e != null) {
                h2 += e.value.hashCode();
                e = e.next;
            }
        }
        return h2;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        int cnt = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry<T> e = this.table[i];
            while (e != null) {
                buf.append(e.value);
                if (++cnt < this.count) {
                    buf.append(", ");
                }
                e = e.next;
            }
        }
        buf.append("]");
        return buf.toString();
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        Entry<T>[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry<T> old = oldMap[i];
            while (old != null) {
                Entry<T> e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    private Entry<T> getNewEntry() {
        int size = this.entryCache.size();
        Entry ret_val = size == 0 ? new Entry() : this.entryCache.remove(size - 1);
        return ret_val;
    }

    private void releaseEntry(Entry<T> e) {
        this.entryCache.add(e);
    }

    private static class Entry<T> {
        int hash;
        T value;
        Entry<T> next;

        protected Entry() {
        }

        protected Entry(int hash, T value, Entry<T> next) {
            this.hash = hash;
            this.value = value;
            this.next = next;
        }

        protected void set(int hash, T value, Entry<T> next) {
            this.hash = hash;
            this.value = value;
            this.next = next;
        }
    }
}

