/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.phtree;

import ch.ethz.globis.phtree.PhTreeSolidF;
import org.tinspin.index.BoxMap;
import org.tinspin.index.Index;
import org.tinspin.index.phtree.PHStats;

public class PHTreeR<T>
implements BoxMap<T> {
    private final PhTreeSolidF<T> tree;

    private PHTreeR(int dims) {
        this.tree = PhTreeSolidF.create(dims);
    }

    public static <T> PHTreeR<T> createPHTree(int dims) {
        return new PHTreeR<T>(dims);
    }

    @Override
    public int getDims() {
        return this.tree.getDims();
    }

    @Override
    public int size() {
        return this.tree.size();
    }

    @Override
    public void clear() {
        this.tree.clear();
    }

    @Override
    public PHStats getStats() {
        return new PHStats(this.tree.getInternalTree().getStats(), this.tree.getDims());
    }

    @Override
    public int getNodeCount() {
        return this.tree.getInternalTree().getStats().getNodeCount();
    }

    @Override
    public int getDepth() {
        return this.tree.getInternalTree().getStats().getBitDepth();
    }

    @Override
    public String toStringTree() {
        return this.tree.getInternalTree().toStringTree();
    }

    @Override
    public void insert(double[] lower, double[] upper, T value) {
        this.tree.put(lower, upper, value);
    }

    @Override
    public T remove(double[] lower, double[] upper) {
        return this.tree.remove(lower, upper);
    }

    @Override
    public T update(double[] lo1, double[] up1, double[] lo2, double[] up2) {
        return this.tree.update(lo1, up1, lo2, up2);
    }

    @Override
    public boolean contains(double[] min2, double[] max) {
        return this.tree.contains(min2, max);
    }

    @Override
    public T queryExact(double[] lower, double[] upper) {
        return this.tree.get(lower, upper);
    }

    @Override
    public Index.BoxIterator<T> iterator() {
        return new ExtentWrapper();
    }

    @Override
    public Index.BoxIterator<T> queryIntersect(double[] min2, double[] max) {
        return new QueryIteratorPH<T>(this.tree.queryIntersect(min2, max));
    }

    @Override
    public Index.BoxIteratorKnn<T> queryKnn(double[] center, int k) {
        return new QueryIteratorKnnPH<T>(this.tree.nearestNeighbour(k, null, center));
    }

    private static class QueryIteratorKnnPH<T>
    implements Index.BoxIteratorKnn<T> {
        private final PhTreeSolidF.PhKnnQuerySF<T> iter;

        private QueryIteratorKnnPH(PhTreeSolidF.PhKnnQuerySF<T> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Index.BoxEntryKnn<T> next() {
            PhTreeSolidF.PhEntrySF e = this.iter.nextEntryReuse();
            return new Index.BoxEntryKnn((double[])e.lower().clone(), (double[])e.upper().clone(), e.value(), ((PhTreeSolidF.PhEntryDistSF)e).dist());
        }

        @Override
        public QueryIteratorKnnPH<T> reset(double[] center, int k) {
            this.iter.reset(k, null, center);
            return this;
        }
    }

    private static class QueryIteratorPH<T>
    implements Index.BoxIterator<T> {
        private final PhTreeSolidF.PhQuerySF<T> iter;

        private QueryIteratorPH(PhTreeSolidF.PhQuerySF<T> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Index.BoxEntry<T> next() {
            Object e = this.iter.nextEntryReuse();
            return new Index.BoxEntry((double[])((PhTreeSolidF.PhEntrySF)e).lower().clone(), (double[])((PhTreeSolidF.PhEntrySF)e).upper().clone(), ((PhTreeSolidF.PhEntrySF)e).value());
        }

        @Override
        public Index.BoxIterator<T> reset(double[] min2, double[] max) {
            this.iter.reset(min2, max);
            return this;
        }
    }

    private class ExtentWrapper
    implements Index.BoxIterator<T> {
        private PhTreeSolidF.PhIteratorSF<T> iter;

        private ExtentWrapper() {
            this.reset(null, null);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Index.BoxEntry<T> next() {
            Object e = this.iter.nextEntryReuse();
            return new Index.BoxEntry((double[])((PhTreeSolidF.PhEntrySF)e).lower().clone(), (double[])((PhTreeSolidF.PhEntrySF)e).upper().clone(), ((PhTreeSolidF.PhEntrySF)e).value());
        }

        @Override
        public Index.BoxIterator<T> reset(double[] min2, double[] max) {
            if (min2 != null || max != null) {
                throw new UnsupportedOperationException("min/max must be `null`");
            }
            this.iter = PHTreeR.this.tree.iterator();
            return this;
        }
    }
}

