/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.vecmath.Tuple3d;
import org.tinspin.index.Index;
import org.tinspin.index.kdtree.KDTree;
import org.twak.camp.Chain;
import org.twak.camp.CoSitedCollision;
import org.twak.camp.Corner;
import org.twak.camp.Edge;
import org.twak.camp.EdgeCollision;
import org.twak.camp.HeightEvent;
import org.twak.camp.Skeleton;
import org.twak.utils.Pair;
import org.twak.utils.collections.CloneConfirmIterator;
import org.twak.utils.collections.ConsecutivePairs;

public class HeightCollision
implements HeightEvent {
    double height;
    List<EdgeCollision> coHeighted;
    private Set<Corner> newHoriz = new LinkedHashSet<Corner>();

    public HeightCollision() {
    }

    public HeightCollision(List<EdgeCollision> coHeighted) {
        this.coHeighted = coHeighted;
        this.height = coHeighted.get(0).getHeight();
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public boolean process(Skeleton skel) {
        if (this.coHeighted.isEmpty()) {
            this.processHoriz(skel);
            return false;
        }
        boolean changed = false;
        KDTree<CoSitedCollision> kdTree = KDTree.create(2);
        double tolerance = 0.01;
        ArrayList<CoSitedCollision> coSited = new ArrayList<CoSitedCollision>();
        EdgeCollision first = this.coHeighted.get(0);
        double[] firstPoint = new double[]{first.loc.x, first.loc.y};
        CoSitedCollision firstCollision = new CoSitedCollision(first.loc, first, this);
        kdTree.insert(firstPoint, firstCollision);
        coSited.add(firstCollision);
        int len = this.coHeighted.size();
        for (int i = 1; i < len; ++i) {
            EdgeCollision ec = this.coHeighted.get(i);
            double[] dArray = new double[]{ec.loc.x, ec.loc.y};
            double[] qp = dArray;
            Index.PointEntryKnn nearest = kdTree.query1nn(qp);
            if (nearest.dist() < 0.01) {
                ((CoSitedCollision)nearest.value()).add(ec);
                continue;
            }
            CoSitedCollision newCollision = new CoSitedCollision(ec.loc, ec, this);
            kdTree.insert(qp, newCollision);
            coSited.add(newCollision);
        }
        coSited.removeIf(css -> !css.findChains(skel));
        skel.qu.holdRemoves();
        for (CoSitedCollision css2 : coSited) {
            css2.validateChains(skel);
            changed |= css2.processChains(skel);
        }
        skel.qu.resumeRemoves();
        this.processHoriz(skel);
        return changed;
    }

    public void processHoriz(Skeleton skel) {
        LinkedHashSet<Chain> chains = new LinkedHashSet<Chain>();
        while (this.newHoriz.size() > 0) {
            chains.add(CoSitedCollision.buildChain2(this.newHoriz.iterator().next(), this.newHoriz));
        }
        if (chains.size() == 0) {
            return;
        }
        LinkedHashSet<Corner> intraface = new LinkedHashSet<Corner>();
        for (Chain chain : chains) {
            ArrayList<Edge> priority = new ArrayList<Edge>();
            for (Corner c : chain.chain) {
                priority.add(c.nextL);
                priority.add(c.prevL);
            }
            Comparator<Edge> hComp = skel.getHorizontalComparator();
            Collections.sort(priority, hComp);
            LinkedHashSet<Edge> winners = new LinkedHashSet<Edge>();
            Edge winner = (Edge)priority.remove(0);
            winners.add(winner);
            while (!priority.isEmpty() && hComp.compare(winner, (Edge)priority.get(0)) == 0) {
                winners.add((Edge)priority.remove(0));
            }
            Corner first = chain.chain.get(0);
            if (!winners.contains(first.prevL)) {
                if (!intraface.contains(first.prevC)) {
                    Corner newFirst = new Corner(Edge.collide(first.prevC, first.z));
                    skel.output.addOutputSideTo(first.prevC, (Tuple3d)newFirst, first.prevL, first.prevC.prevL);
                    Corner.replace(first.prevC, newFirst, skel);
                    chain.chain.add(0, newFirst);
                    intraface.add(newFirst);
                    first = newFirst;
                } else {
                    chain.chain.add(0, first.prevC);
                }
            } else {
                first = first.prevC;
                chain.chain.add(0, first);
            }
            Corner last = chain.chain.get(chain.chain.size() - 1);
            if (!winners.contains(last.nextL)) {
                if (!intraface.contains(last.nextC)) {
                    Corner newLast = new Corner(Edge.collide(last.nextC, last.z));
                    skel.output.addOutputSideTo(last.nextC, (Tuple3d)newLast, last.nextL, last.nextC.nextL);
                    Corner.replace(last.nextC, newLast, skel);
                    chain.chain.add(newLast);
                    intraface.add(newLast);
                    last = newLast;
                } else {
                    chain.chain.add(last.nextC);
                }
            } else {
                last = last.nextC;
                chain.chain.add(last);
            }
            for (Pair<Corner, Corner> pair : new ConsecutivePairs<Corner>(chain.chain, false)) {
                Corner s2 = pair.first();
                Corner e = pair.second();
                assert (s2.nextL == e.prevL);
                if (winners.contains(s2.nextL)) {
                    if (s2.nextL != winner) {
                        skel.output.merge(winner.start, s2);
                    }
                    s2.nextL.currentCorners.remove(e);
                    s2.nextL.currentCorners.remove(s2);
                } else {
                    s2.nextL.currentCorners.remove(s2);
                    s2.nextL.currentCorners.remove(e);
                    skel.output.addOutputSideTo(true, (Tuple3d)s2, e, s2.nextL, winner);
                }
                skel.liveCorners.remove(s2);
                skel.liveCorners.remove(e);
            }
            skel.liveCorners.add(first);
            skel.liveCorners.add(last);
            winner.currentCorners.add(first);
            winner.currentCorners.add(last);
            first.nextC = last;
            last.prevC = first;
            first.nextL = winner;
            last.prevL = winner;
            for (Corner corner : chain.chain) {
                if (corner.nextL.currentCorners.size() != 0) continue;
                skel.liveEdges.remove(corner.nextL);
            }
        }
        skel.qu.clearFaceEvents();
        for (Corner lc : new CloneConfirmIterator<Corner>(skel.liveCorners)) {
            skel.qu.addCorner(lc, this);
        }
        assert (this.newHoriz.size() == 0);
        skel.validate();
    }

    public void newHoriz(Corner toAdd) {
        this.newHoriz.add(toAdd);
    }

    public String toString() {
        return "collisions at " + this.height;
    }
}

