/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.ui;

import java.awt.Color;
import javax.vecmath.Point3d;
import org.twak.utils.Mathz;

public class Colourz {
    static float hue;
    static float sat;
    static float bri;
    public static Color sky;

    public static Color nextColor() {
        hue = (float)((double)hue + 0.03183098861837907);
        return new Color(Color.HSBtoRGB(hue, sat, bri));
    }

    public static void reset() {
        hue = 0.0f;
        sat = 0.7f;
        bri = 1.0f;
    }

    public static Color transparent(Color color, int i) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), i);
    }

    public static Color toGrayscale(Color color) {
        int a = 0;
        a += color.getRed();
        a += color.getGreen();
        return new Color((a += color.getBlue()) / 3, a / 3, a / 3);
    }

    public static Color toGrayscale(Color color, float tween) {
        int a = 0;
        a += color.getRed();
        a += color.getGreen();
        return new Color((int)(((double)(a += color.getBlue()) / 3.0 * (double)tween + (double)((float)color.getRed() * (1.0f - tween))) / 2.0), (int)(((double)a / 3.0 * (double)tween + (double)((float)color.getGreen() * (1.0f - tween))) / 2.0), (int)(((double)a / 3.0 * (double)tween + (double)((float)color.getBlue() * (1.0f - tween))) / 2.0));
    }

    public static float[] toF4(Color color) {
        return new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f};
    }

    public static double[] toD4(Color color) {
        return new double[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f};
    }

    public static String toHex(Color color) {
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    public static int asInt(int r, int g2, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g2 & 0xFF) << 8 | (b & 0xFF) << 0;
    }

    public static int asInt(int r, int g2, int b) {
        return Colourz.asInt(r, g2, b, 255);
    }

    public static Color lighter(Color c) {
        float[] hsb = new float[3];
        Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), hsb);
        hsb[2] = Math.max(1.0f, hsb[1] * 1.2f);
        return Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
    }

    public static Color to4(float[] c) {
        return new Color(c[0], c[1], c[2], c[3]);
    }

    public static Color to4(double[] c) {
        return new Color((float)c[0], (float)c[1], (float)c[2], (float)c[3]);
    }

    public static Color to3(double[] c) {
        return new Color((float)c[0], (float)c[1], (float)c[2]);
    }

    public static Color to3(int[] c) {
        return new Color(c[0], c[1], c[2]);
    }

    public static double distance(int a, int b) {
        int[] t1 = new int[3];
        int[] t2 = new int[3];
        Colourz.toComp(a, t1);
        Colourz.toComp(b, t2);
        return Mathz.L2(t1, t2);
    }

    public static void toComp(int c, int[] t2) {
        t2[0] = c >> 16 & 0xFF;
        t2[1] = c >> 8 & 0xFF;
        t2[2] = c & 0xFF;
    }

    public static int[] toComp(int c) {
        int[] out = new int[3];
        Colourz.toComp(c, out);
        return out;
    }

    public static double colDist(Color a, Color b) {
        return new Point3d(a.getRed(), a.getGreen(), a.getBlue()).distance(new Point3d(b.getRed(), b.getGreen(), b.getBlue())) / 442.0;
    }

    static {
        Colourz.reset();
        sky = new Color(180, 225, 246);
    }
}

