/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.S2Geography;

import com.google.common.geometry.S1ChordAngle;
import com.google.common.geometry.S2BestDistanceTarget;
import com.google.common.geometry.S2BestEdgesQueryBase;
import com.google.common.geometry.S2ClosestEdgeQuery;
import com.google.common.geometry.S2Edge;
import com.google.common.geometry.S2EdgeUtil;
import com.google.common.geometry.S2FurthestEdgeQuery;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Shape;
import com.google.common.geometry.S2ShapeIndex;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sedona.common.S2Geography.ShapeIndexGeography;

public class Distance {
    public double S2_distance(ShapeIndexGeography geo1, ShapeIndexGeography geo2) {
        S2ClosestEdgeQuery.ShapeIndexTarget queryTarget;
        S2ShapeIndex index1 = geo1.shapeIndex;
        S2ShapeIndex index2 = geo2.shapeIndex;
        S2ClosestEdgeQuery.Query query = S2ClosestEdgeQuery.builder().build(index1);
        Optional resultVisitor = query.findClosestEdge((S2BestDistanceTarget)(queryTarget = S2ClosestEdgeQuery.createShapeIndexTarget((S2ShapeIndex)index2)));
        if (!resultVisitor.isPresent()) {
            return Double.POSITIVE_INFINITY;
        }
        S2BestEdgesQueryBase.Result result = (S2BestEdgesQueryBase.Result)resultVisitor.get();
        S1ChordAngle chordAngle = (S1ChordAngle)result.distance();
        return chordAngle.toAngle().radians();
    }

    public double S2_maxDistance(ShapeIndexGeography geo1, ShapeIndexGeography geo2) {
        S2FurthestEdgeQuery.ShapeIndexTarget queryTarget;
        S2ShapeIndex index1 = geo1.shapeIndex;
        S2ShapeIndex index2 = geo2.shapeIndex;
        S2FurthestEdgeQuery.Query query = S2FurthestEdgeQuery.builder().build(index1);
        Optional resultVisitor = query.findFurthestEdge((S2BestDistanceTarget)(queryTarget = S2FurthestEdgeQuery.createShapeIndexTarget((S2ShapeIndex)index2)));
        if (!resultVisitor.isPresent()) {
            return Double.POSITIVE_INFINITY;
        }
        S2BestEdgesQueryBase.Result result = (S2BestEdgesQueryBase.Result)resultVisitor.get();
        S1ChordAngle chordAngle = (S1ChordAngle)result.distance();
        return chordAngle.toAngle().radians();
    }

    public S2Point S2_closestPoint(ShapeIndexGeography geo1, ShapeIndexGeography geo2) throws Exception {
        return (S2Point)this.S2_minimumClearanceLineBetween(geo1, geo2).getLeft();
    }

    public Pair<S2Point, S2Point> S2_minimumClearanceLineBetween(ShapeIndexGeography geo1, ShapeIndexGeography geo2) throws Exception {
        S2ClosestEdgeQuery.ShapeIndexTarget queryTarget;
        S2ShapeIndex index1 = geo1.shapeIndex;
        S2ShapeIndex index2 = geo2.shapeIndex;
        S2ClosestEdgeQuery.Query query = S2ClosestEdgeQuery.builder().setIncludeInteriors(false).build(index1);
        Optional resultVisitor = query.findClosestEdge((S2BestDistanceTarget)(queryTarget = S2ClosestEdgeQuery.createShapeIndexTarget((S2ShapeIndex)index2)));
        if (!resultVisitor.isPresent() || ((S2BestEdgesQueryBase.Result)resultVisitor.get()).edgeId() == -1) {
            return Pair.of((Object)new S2Point(0.0, 0.0, 0.0), (Object)new S2Point(0.0, 0.0, 0.0));
        }
        S2BestEdgesQueryBase.Result edge = (S2BestEdgesQueryBase.Result)resultVisitor.get();
        int shapeId = edge.shapeId();
        int edgeNum = edge.edgeId();
        S2Shape.MutableEdge mutableEdge = new S2Shape.MutableEdge();
        ((S2Shape)index1.getShapes().get(shapeId)).getEdge(edgeNum, mutableEdge);
        S2Edge s2edge = new S2Edge(mutableEdge.getStart(), mutableEdge.getEnd());
        S2ClosestEdgeQuery.Query queryReverse = S2ClosestEdgeQuery.builder().setIncludeInteriors(false).build(index2);
        S2ClosestEdgeQuery.EdgeTarget queryTargetReverse = new S2ClosestEdgeQuery.EdgeTarget(s2edge.getStart(), s2edge.getEnd());
        Optional resultVisitorReverse = queryReverse.findClosestEdge((S2BestDistanceTarget)queryTargetReverse);
        if (((S2BestEdgesQueryBase.Result)resultVisitorReverse.get()).isInterior()) {
            throw new Exception("S2ClosestEdgeQuery result is interior!");
        }
        S2BestEdgesQueryBase.Result edge2 = (S2BestEdgesQueryBase.Result)resultVisitorReverse.get();
        int shapeId2 = edge2.shapeId();
        int edgeNum2 = edge2.edgeId();
        S2Shape.MutableEdge mutableEdge2 = new S2Shape.MutableEdge();
        ((S2Shape)index2.getShapes().get(shapeId2)).getEdge(edgeNum2, mutableEdge2);
        S2Edge s2edge2 = new S2Edge(mutableEdge2.getStart(), mutableEdge2.getEnd());
        S2Edge s2edgeReverse = new S2Edge(s2edge2.getStart(), s2edge2.getEnd());
        return Distance.getEdgePairClosestPoints(s2edge.getStart(), s2edge.getEnd(), s2edgeReverse.getStart(), s2edgeReverse.getEnd());
    }

    public static Pair<S2Point, S2Point> getEdgePairClosestPoints(S2Point a0, S2Point a1, S2Point b0, S2Point b1) {
        S2Shape.MutableEdge resultEdge = new S2Shape.MutableEdge();
        S2EdgeUtil.getEdgePairClosestPoints((S2Point)a0, (S2Point)a1, (S2Point)b0, (S2Point)b1, (S2Shape.MutableEdge)resultEdge);
        return Pair.of((Object)resultEdge.getStart(), (Object)resultEdge.getEnd());
    }
}

