/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.kernel.internal.guarantee;

import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.kernel.internal.config.ConfigurationService;
import org.apache.shardingsphere.elasticjob.kernel.internal.guarantee.GuaranteeNode;
import org.apache.shardingsphere.elasticjob.kernel.internal.storage.JobNodeStorage;
import org.apache.shardingsphere.elasticjob.kernel.listener.AbstractDistributeOnceElasticJobListener;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.base.LeaderExecutionCallback;
import org.apache.shardingsphere.elasticjob.spi.listener.param.ShardingContexts;

public final class GuaranteeService {
    private final JobNodeStorage jobNodeStorage;
    private final ConfigurationService configService;

    public GuaranteeService(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobNodeStorage = new JobNodeStorage(regCenter, jobName);
        this.configService = new ConfigurationService(regCenter, jobName);
    }

    public void registerStart(Collection<Integer> shardingItems) {
        for (int each : shardingItems) {
            this.jobNodeStorage.createJobNodeIfNeeded(GuaranteeNode.getStartedNode(each));
        }
    }

    public boolean isRegisterStartSuccess(Collection<Integer> shardingItems) {
        for (int each : shardingItems) {
            if (this.jobNodeStorage.isJobNodeExisted(GuaranteeNode.getStartedNode(each))) continue;
            return false;
        }
        return true;
    }

    public boolean isAllStarted() {
        return this.jobNodeStorage.isJobNodeExisted("guarantee/started") && this.configService.load(false).getShardingTotalCount() == this.jobNodeStorage.getJobNodeChildrenKeys("guarantee/started").size();
    }

    public void clearAllStartedInfo() {
        this.jobNodeStorage.removeJobNodeIfExisted("guarantee/started");
    }

    public void registerComplete(Collection<Integer> shardingItems) {
        for (int each : shardingItems) {
            this.jobNodeStorage.createJobNodeIfNeeded(GuaranteeNode.getCompletedNode(each));
        }
    }

    public boolean isRegisterCompleteSuccess(Collection<Integer> shardingItems) {
        for (int each : shardingItems) {
            if (this.jobNodeStorage.isJobNodeExisted(GuaranteeNode.getCompletedNode(each))) continue;
            return false;
        }
        return true;
    }

    public boolean isAllCompleted() {
        return this.jobNodeStorage.isJobNodeExisted("guarantee/completed") && this.configService.load(false).getShardingTotalCount() <= this.jobNodeStorage.getJobNodeChildrenKeys("guarantee/completed").size();
    }

    public void clearAllCompletedInfo() {
        this.jobNodeStorage.removeJobNodeIfExisted("guarantee/completed");
    }

    public void executeInLeaderForLastStarted(AbstractDistributeOnceElasticJobListener listener, ShardingContexts shardingContexts) {
        this.jobNodeStorage.executeInLeader("guarantee/started-latch", new LeaderExecutionCallbackForLastStarted(listener, shardingContexts));
    }

    public void executeInLeaderForLastCompleted(AbstractDistributeOnceElasticJobListener listener, ShardingContexts shardingContexts) {
        this.jobNodeStorage.executeInLeader("guarantee/completed-latch", new LeaderExecutionCallbackForLastCompleted(listener, shardingContexts));
    }

    class LeaderExecutionCallbackForLastStarted
    implements LeaderExecutionCallback {
        private final AbstractDistributeOnceElasticJobListener listener;
        private final ShardingContexts shardingContexts;

        public void execute() {
            try {
                if (!GuaranteeService.this.isAllStarted()) {
                    return;
                }
                this.listener.doBeforeJobExecutedAtLastStarted(this.shardingContexts);
            }
            finally {
                GuaranteeService.this.clearAllStartedInfo();
            }
        }

        @Generated
        public LeaderExecutionCallbackForLastStarted(AbstractDistributeOnceElasticJobListener listener, ShardingContexts shardingContexts) {
            this.listener = listener;
            this.shardingContexts = shardingContexts;
        }
    }

    class LeaderExecutionCallbackForLastCompleted
    implements LeaderExecutionCallback {
        private final AbstractDistributeOnceElasticJobListener listener;
        private final ShardingContexts shardingContexts;

        public void execute() {
            try {
                if (!GuaranteeService.this.isAllCompleted()) {
                    return;
                }
                this.listener.doAfterJobExecutedAtLastCompleted(this.shardingContexts);
            }
            finally {
                GuaranteeService.this.clearAllCompletedInfo();
            }
        }

        @Generated
        public LeaderExecutionCallbackForLastCompleted(AbstractDistributeOnceElasticJobListener listener, ShardingContexts shardingContexts) {
            this.listener = listener;
            this.shardingContexts = shardingContexts;
        }
    }
}

