/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.HashMap;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstanceCustomizer;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ProtocolPortsMetadataCustomizer
implements ServiceInstanceCustomizer {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(ProtocolPortsMetadataCustomizer.class);

    @Override
    public void customize(ServiceInstance serviceInstance, ApplicationModel applicationModel) {
        MetadataInfo metadataInfo = serviceInstance.getServiceMetadata();
        if (metadataInfo == null || CollectionUtils.isEmptyMap(metadataInfo.getExportedServiceURLs())) {
            return;
        }
        HashMap<String, Integer> protocols = new HashMap<String, Integer>();
        Set<URL> urls = metadataInfo.collectExportedURLSet();
        urls.forEach(url -> {
            String protocol = url.getProtocol();
            Integer oldPort = (Integer)protocols.get(protocol);
            int newPort = url.getPort();
            if (oldPort != null && oldPort != newPort) {
                LOGGER.warn("4-19", "the protocol is listening multiple ports", "", "Same protocol [" + protocol + "] listens on different ports [" + oldPort + "," + newPort + "] will override with each other. The port [" + oldPort + "] is overridden with port [" + newPort + "].");
            }
            protocols.put(protocol, newPort);
        });
        if (protocols.size() > 0) {
            ServiceInstanceMetadataUtils.setEndpoints(serviceInstance, protocols);
        }
    }
}

