/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.reporter.common;

import com.alipay.common.tracer.core.appender.builder.XStringBuilder;
import com.alipay.common.tracer.core.appender.encoder.SpanEncoder;
import com.alipay.common.tracer.core.appender.self.Timestamp;
import com.alipay.common.tracer.core.context.span.SofaTracerSpanContext;
import com.alipay.common.tracer.core.span.CommonLogSpan;
import com.alipay.common.tracer.core.tags.SpanTags;
import java.io.IOException;

public class CommonSpanEncoder
implements SpanEncoder<CommonLogSpan> {
    @Override
    public String encode(CommonLogSpan commonLogSpan) throws IOException {
        if (commonLogSpan.getSofaTracerSpanContext() == null) {
            return "";
        }
        SofaTracerSpanContext spanContext = commonLogSpan.getSofaTracerSpanContext();
        XStringBuilder xsb = new XStringBuilder();
        xsb.append(Timestamp.format(commonLogSpan.getStartTime())).append(commonLogSpan.getTagsWithStr().get(SpanTags.CURR_APP_TAG.getKey())).append(spanContext.getTraceId()).append(spanContext.getSpanId());
        this.appendStr(xsb, commonLogSpan);
        return xsb.toString();
    }

    private void appendStr(XStringBuilder xsb, CommonLogSpan commonLogSpan) {
        int slotSize = commonLogSpan.getSlots().size();
        for (int i = 0; i < slotSize; ++i) {
            if (i + 1 != slotSize) {
                xsb.append(commonLogSpan.getSlots().get(i));
                continue;
            }
            xsb.appendRaw(commonLogSpan.getSlots().get(i));
        }
        xsb.appendRaw("\r\n");
    }
}

