/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.internal.shared;

import java.io.InputStream;
import java.io.Reader;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import org.apache.sis.util.logging.Logging;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public final class InputFactory {
    private static final XMLInputFactory FACTORY = XMLInputFactory.newInstance();

    private InputFactory() {
    }

    public static XMLEventReader createXMLEventReader(InputStream in) throws XMLStreamException {
        return FACTORY.createXMLEventReader(in, "UTF-8");
    }

    public static XMLEventReader createXMLEventReader(Reader in) throws XMLStreamException {
        return FACTORY.createXMLEventReader(in);
    }

    public static XMLEventReader createXMLEventReader(InputSource in) throws XMLStreamException {
        return FACTORY.createXMLEventReader(new SAXSource(in));
    }

    public static XMLEventReader createXMLEventReader(Node in) throws XMLStreamException {
        return FACTORY.createXMLEventReader(new DOMSource(in));
    }

    public static XMLEventReader createXMLEventReader(Source in) throws XMLStreamException {
        return FACTORY.createXMLEventReader(in);
    }

    public static XMLEventReader createXMLEventReader(XMLStreamReader in) throws XMLStreamException {
        return FACTORY.createXMLEventReader(new StreamReaderDelegate(in){

            @Override
            public void close() throws XMLStreamException {
            }
        });
    }

    static {
        try {
            if (FACTORY.isPropertySupported("http://javax.xml.XMLConstants/feature/secure-processing")) {
                FACTORY.setProperty("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            }
            if ("all".equals(FACTORY.getProperty("http://javax.xml.XMLConstants/property/accessExternalDTD"))) {
                FACTORY.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            }
        }
        catch (IllegalArgumentException e) {
            Logging.unexpectedException((Logger)Logger.getLogger("org.apache.sis.xml"), InputFactory.class, (String)"createXMLEventReader", (Throwable)e);
        }
    }
}

