/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.jfr.type;

import lombok.Generated;
import one.jfr.StackTrace;

public abstract class Classifier {
    public Category getCategory(StackTrace stackTrace) {
        long[] methods = stackTrace.methods;
        byte[] types = stackTrace.types;
        Category category = this.detectGcJit(methods, types);
        if (category == null && (category = this.detectClassLoading(methods, types)) == null) {
            category = this.detectOther(methods, types);
        }
        return category;
    }

    private Category detectGcJit(long[] methods, byte[] types) {
        boolean vmThread = false;
        int i = types.length;
        while (--i >= 0) {
            if (types[i] == 4) {
                switch (this.getMethodName(methods[i], types[i])) {
                    case "CompileBroker::compiler_thread_loop": {
                        return Category.JIT;
                    }
                    case "GCTaskThread::run": 
                    case "WorkerThread::run": {
                        return Category.GC;
                    }
                    case "java_start": 
                    case "thread_native_entry": {
                        vmThread = true;
                    }
                }
                continue;
            }
            if (types[i] == 3) continue;
        }
        return vmThread ? Category.VM : null;
    }

    private Category detectClassLoading(long[] methods, byte[] types) {
        for (int i = 0; i < methods.length; ++i) {
            String methodName = this.getMethodName(methods[i], types[i]);
            if (methodName.equals("Verifier::verify")) {
                return Category.CLASS_VERIFY;
            }
            if (methodName.startsWith("InstanceKlass::initialize")) {
                return Category.CLASS_INIT;
            }
            if (methodName.startsWith("LinkResolver::") || methodName.startsWith("InterpreterRuntime::resolve") || methodName.startsWith("SystemDictionary::resolve")) {
                return Category.CLASS_RESOLVE;
            }
            if (methodName.endsWith("ClassLoader.loadClass")) {
                return Category.CLASS_LOAD;
            }
            if (methodName.endsWith("LambdaMetafactory.metafactory") || methodName.endsWith("LambdaMetafactory.altMetafactory")) {
                return Category.LAMBDA_INIT;
            }
            if (methodName.endsWith("table stub")) {
                return Category.VTABLE_STUBS;
            }
            if (methodName.equals("Interpreter")) {
                return Category.INTERPRETER;
            }
            if (!methodName.startsWith("I2C/C2I")) continue;
            return i + 1 < types.length && types[i + 1] == 0 ? Category.INTERPRETER : Category.ADAPTER;
        }
        return null;
    }

    private Category detectOther(long[] methods, byte[] types) {
        boolean inJava = true;
        block18: for (int i = 0; i < types.length; ++i) {
            switch (types[i]) {
                case 0: {
                    return inJava ? Category.INTERPRETER : Category.NATIVE;
                }
                case 1: {
                    return inJava ? Category.C2_COMP : Category.NATIVE;
                }
                case 2: {
                    inJava = true;
                    continue block18;
                }
                case 3: {
                    String methodName = this.getMethodName(methods[i], types[i]);
                    if (methodName.startsWith("JVM_") || methodName.startsWith("Unsafe_") || methodName.startsWith("MHN_") || methodName.startsWith("jni_")) {
                        return Category.VM;
                    }
                    switch (methodName) {
                        case "call_stub": 
                        case "deoptimization": 
                        case "unknown_Java": 
                        case "not_walkable_Java": 
                        case "InlineCacheBuffer": {
                            return Category.VM;
                        }
                    }
                    if (methodName.endsWith("_arraycopy") || methodName.contains("pthread_cond")) continue block18;
                    inJava = false;
                    continue block18;
                }
                case 4: {
                    String methodName = this.getMethodName(methods[i], types[i]);
                    if (!methodName.startsWith("Runtime1::")) continue block18;
                    return Category.C1_COMP;
                }
                case 6: {
                    return inJava ? Category.C1_COMP : Category.NATIVE;
                }
            }
        }
        return Category.NATIVE;
    }

    public abstract String getMethodName(long var1, byte var3);

    public static enum Category {
        GC("[gc]", 4),
        JIT("[jit]", 4),
        VM("[vm]", 4),
        VTABLE_STUBS("[vtable_stubs]", 3),
        NATIVE("[native]", 3),
        INTERPRETER("[Interpreter]", 3),
        C1_COMP("[c1_comp]", 6),
        C2_COMP("[c2_comp]", 2),
        ADAPTER("[c2i_adapter]", 2),
        CLASS_INIT("[class_init]", 4),
        CLASS_LOAD("[class_load]", 4),
        CLASS_RESOLVE("[class_resolve]", 4),
        CLASS_VERIFY("[class_verify]", 4),
        LAMBDA_INIT("[lambda_init]", 4);

        private final String title;
        private final byte type;

        private Category(String title, byte type) {
            this.title = title;
            this.type = type;
        }

        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public byte getType() {
            return this.type;
        }
    }
}

