/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.graphql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.stream.NoopSubscription;
import com.linecorp.armeria.server.graphql.GraphqlSubProtocol;
import graphql.ExecutionResult;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ExecutionResultSubscriber
implements Subscriber<ExecutionResult> {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionResultSubscriber.class);
    private final GraphqlSubProtocol protocol;
    private final String operationId;
    @Nullable
    private Subscription subscription;

    ExecutionResultSubscriber(String operationId, GraphqlSubProtocol protocol) {
        this.operationId = operationId;
        this.protocol = protocol;
    }

    public void onSubscribe(Subscription s) {
        if (this.subscription != null) {
            s.cancel();
            return;
        }
        this.subscription = s;
        this.requestMore();
    }

    public void onNext(ExecutionResult executionResult) {
        block5: {
            assert (this.subscription != null);
            try {
                if (executionResult.getErrors().isEmpty()) {
                    this.protocol.sendResult(this.operationId, executionResult);
                    this.requestMore();
                } else {
                    this.protocol.sendGraphqlErrors(executionResult.getErrors());
                    this.subscription.cancel();
                }
            }
            catch (JsonProcessingException e) {
                this.protocol.completeWithError(e);
                if (this.subscription == null) break block5;
                this.subscription.cancel();
            }
        }
    }

    public void onError(Throwable t) {
        logger.trace("onError", t);
        this.subscription = null;
        this.protocol.completeWithError(t);
    }

    public void onComplete() {
        logger.trace("onComplete");
        this.subscription = null;
        this.protocol.complete();
    }

    public void setCompleted() {
        if (this.subscription == null) {
            this.subscription = NoopSubscription.get();
        }
        this.subscription.cancel();
    }

    private void requestMore() {
        if (this.subscription != null) {
            this.subscription.request(1L);
        }
    }
}

