/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.guava.common.collect;

import java.util.Set;
import org.apache.jackrabbit.guava.common.annotations.GwtCompatible;
import org.apache.jackrabbit.guava.common.annotations.GwtIncompatible;
import org.apache.jackrabbit.guava.common.annotations.J2ktIncompatible;
import org.apache.jackrabbit.guava.common.collect.ImmutableList;
import org.apache.jackrabbit.guava.common.collect.IndexedImmutableSet;
import org.jspecify.annotations.Nullable;

@GwtCompatible(serializable=true)
final class JdkBackedImmutableSet<E>
extends IndexedImmutableSet<E> {
    private final Set<?> delegate;
    private final ImmutableList<E> delegateList;

    JdkBackedImmutableSet(Set<?> delegate, ImmutableList<E> delegateList) {
        this.delegate = delegate;
        this.delegateList = delegateList;
    }

    @Override
    E get(int index) {
        return this.delegateList.get(index);
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.delegate.contains(object);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int size() {
        return this.delegateList.size();
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }
}

