/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.collections;

import java.util.HashSet;

public class HyperLogLog {
    private final double amm2;
    private final int m;
    private final byte[] counters;
    private final int maxSmallSetSize;
    private HashSet<Long> smallSet;

    public HyperLogLog(int m, int maxSmallSetSize) {
        double am;
        this.maxSmallSetSize = maxSmallSetSize;
        this.smallSet = maxSmallSetSize > 0 ? new HashSet() : null;
        if (m < 16) {
            throw new IllegalArgumentException("Must be >= 16, is " + m);
        }
        if (Integer.bitCount(m) != 1) {
            throw new IllegalArgumentException("Must be a power of 2, is " + m);
        }
        this.m = m;
        switch (m) {
            case 32: {
                am = 0.697;
                break;
            }
            case 64: {
                am = 0.709;
                break;
            }
            default: {
                am = 0.7213 / (1.0 + 1.079 / (double)m);
            }
        }
        this.amm2 = am * (double)m * (double)m;
        this.counters = new byte[m];
    }

    public void add(long hash) {
        if (this.smallSet != null) {
            this.smallSet.add(hash);
            if (this.smallSet.size() > this.maxSmallSetSize) {
                this.smallSet = null;
            }
        }
        int i = (int)(hash & (long)(this.m - 1));
        this.counters[i] = (byte)Math.max(this.counters[i], 1 + Long.numberOfLeadingZeros(hash));
    }

    public long estimate() {
        long est;
        if (this.smallSet != null) {
            return this.smallSet.size();
        }
        double sum = 0.0;
        int countZero = 0;
        for (byte c : this.counters) {
            countZero += c == 0 ? 1 : 0;
            sum += 1.0 / (double)(1L << (c & 0xFF));
        }
        if (sum == 0.0) {
            sum = 1.0;
        }
        if ((est = (long)(1.0 / sum * this.amm2)) <= (long)(5 * this.m) && countZero > 0) {
            est = (long)((double)this.m * Math.log((double)this.m / (double)countZero));
        }
        return est;
    }
}

