/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.internal.graph;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.collections4.FluentIterable;
import org.apache.commons.collections4.iterators.UnmodifiableIterator;
import org.jetbrains.annotations.NotNull;

public class Traverser {
    private Traverser() {
    }

    @NotNull
    public static <T> FluentIterable<T> preOrderTraversal(final T root, final @NotNull Function<T, Iterable<? extends T>> childExtractor) {
        Objects.requireNonNull(root, "root must not be null");
        Objects.requireNonNull(childExtractor, "Children extractor function must not be null");
        return FluentIterable.of((Iterable)new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return UnmodifiableIterator.unmodifiableIterator(new PreOrderIterator<Object>(root, childExtractor));
            }
        });
    }

    @NotNull
    public static <T> FluentIterable<T> breadthFirstTraversal(final T root, final @NotNull Function<T, Iterable<? extends T>> childExtractor) {
        Objects.requireNonNull(root, "root must not be null");
        Objects.requireNonNull(childExtractor, "Children extractor function must not be null");
        return FluentIterable.of((Iterable)new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return UnmodifiableIterator.unmodifiableIterator(new BreadthFirstIterator<Object>(root, childExtractor));
            }
        });
    }

    public static <T> FluentIterable<T> postOrderTraversal(final T root, final Function<T, Iterable<? extends T>> childExtractor) {
        Objects.requireNonNull(root, "root must not be null");
        Objects.requireNonNull(childExtractor, "Children extractor function must not be null");
        return FluentIterable.of((Iterable)new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return UnmodifiableIterator.unmodifiableIterator(new PostOrderIterator<Object>(root, childExtractor));
            }
        });
    }

    private static class PostOrderNode<T> {
        final T node;
        final Iterator<? extends T> childIterator;

        PostOrderNode(T node, Iterator<? extends T> childItr) {
            this.node = node;
            this.childIterator = childItr;
        }
    }

    private static final class PostOrderIterator<T>
    implements Iterator<T> {
        private final Deque<PostOrderNode<T>> stack;
        private final Function<T, Iterable<? extends T>> childExtractor;

        PostOrderIterator(T root, Function<T, Iterable<? extends T>> childExtractor) {
            this.childExtractor = childExtractor;
            this.stack = new ArrayDeque<PostOrderNode<T>>();
            this.pushChildren(root, childExtractor);
        }

        @Override
        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more nodes in the tree");
            }
            while (!this.stack.isEmpty()) {
                PostOrderNode<T> frame = this.stack.getLast();
                if (frame.childIterator.hasNext()) {
                    Object nextChild = frame.childIterator.next();
                    Objects.requireNonNull(nextChild, "Child nodes must not be null");
                    this.pushChildren(nextChild, this.childExtractor);
                    continue;
                }
                this.stack.removeLast();
                return frame.node;
            }
            throw new AssertionError((Object)"Should not reach here");
        }

        private void pushChildren(T node, Function<T, Iterable<? extends T>> childExtractor) {
            T current = node;
            Objects.requireNonNull(node, "node must not be null");
            while (current != null) {
                Iterator<T> childItr = childExtractor.apply(current).iterator();
                this.stack.addLast(new PostOrderNode<T>(current, childItr));
                if (childItr.hasNext()) {
                    T child = childItr.next();
                    current = Objects.requireNonNull(child, "Child nodes must not be null");
                    continue;
                }
                current = null;
            }
        }
    }

    private static final class BreadthFirstIterator<T>
    implements Iterator<T> {
        private final Deque<T> queue = new ArrayDeque<T>();
        private final Function<T, Iterable<? extends T>> childExtractor;

        public BreadthFirstIterator(T root, Function<T, Iterable<? extends T>> childExtractor) {
            this.childExtractor = childExtractor;
            this.queue.add(root);
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more nodes in the tree");
            }
            T current = this.queue.removeFirst();
            for (T child : this.childExtractor.apply(current)) {
                this.queue.addLast(child);
            }
            return current;
        }
    }

    private static final class PreOrderIterator<T>
    implements Iterator<T> {
        private final Deque<Iterator<? extends T>> stack;
        private final Function<T, Iterable<? extends T>> childExtractor;

        public PreOrderIterator(T root, Function<T, Iterable<? extends T>> childExtractor) {
            this.childExtractor = childExtractor;
            this.stack = new ArrayDeque<Iterator<? extends T>>();
            this.stack.addLast(Collections.singletonList(root).iterator());
        }

        @Override
        public boolean hasNext() {
            while (!this.stack.isEmpty() && !this.stack.peek().hasNext()) {
                this.stack.pop();
            }
            return !this.stack.isEmpty();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more nodes in the tree");
            }
            T current = this.stack.peek().next();
            Iterator<T> childIter = this.childExtractor.apply(current).iterator();
            if (childIter.hasNext()) {
                this.stack.push(childIter);
            }
            return current;
        }
    }
}

