/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.cow;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.apache.jackrabbit.oak.api.jmx.CopyOnWriteStoreMBean;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.cow.COWNodeStore;
import org.apache.jackrabbit.oak.spi.commit.ObserverTracker;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.state.NodeStoreProvider;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardExecutor;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={})
public class COWNodeStoreService {
    private static final Logger LOG = LoggerFactory.getLogger(COWNodeStoreService.class);
    public static final String PROP_ROLE = "role";
    private NodeStoreProvider nodeStoreProvider;
    private String nodeStoreDescription;
    private ComponentContext context;
    private ServiceRegistration nsReg;
    private Registration mbeanReg;
    private ObserverTracker observerTracker;
    private Whiteboard whiteboard;
    private WhiteboardExecutor executor;
    private String role;

    @Activate
    protected void activate(ComponentContext context, Map<String, ?> config) {
        this.role = PropertiesUtil.toString(config.get(PROP_ROLE), null);
        this.context = context;
        this.registerNodeStore();
    }

    @Deactivate
    protected void deactivate() {
        this.unregisterNodeStore();
    }

    private void registerNodeStore() {
        if (this.nsReg != null) {
            return;
        }
        if (this.nodeStoreProvider == null) {
            LOG.info("Waiting for the NodeStoreProvider with role=copy-on-write");
            return;
        }
        if (this.context == null) {
            LOG.info("Waiting for the component activation");
            return;
        }
        COWNodeStore store = new COWNodeStore(this.nodeStoreProvider.getNodeStore());
        this.whiteboard = new OsgiWhiteboard(this.context.getBundleContext());
        this.executor = new WhiteboardExecutor();
        this.executor.start(this.whiteboard);
        this.mbeanReg = WhiteboardUtils.registerMBean(this.whiteboard, CopyOnWriteStoreMBean.class, store.new COWNodeStore.MBeanImpl(), "CopyOnWriteStoreManager", "Copy-on-write: " + this.nodeStoreDescription);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.pid", COWNodeStore.class.getName());
        ((Dictionary)props).put("oak.nodestore.description", new String[]{"nodeStoreType=cowStore"});
        if (this.role == null) {
            LOG.info("Registering the COW node store");
            this.observerTracker = new ObserverTracker(store);
            this.observerTracker.start(this.context.getBundleContext());
            this.nsReg = this.context.getBundleContext().registerService(new String[]{NodeStore.class.getName()}, (Object)store, props);
        } else {
            LOG.info("Registering the COW node store provider");
            ((Dictionary)props).put(PROP_ROLE, this.role);
            this.nsReg = this.context.getBundleContext().registerService(new String[]{NodeStoreProvider.class.getName()}, () -> store, props);
        }
    }

    private void unregisterNodeStore() {
        if (this.mbeanReg != null) {
            this.mbeanReg.unregister();
            this.mbeanReg = null;
        }
        if (this.executor != null) {
            this.executor.stop();
            this.executor = null;
        }
        if (this.observerTracker != null) {
            this.observerTracker.stop();
            this.observerTracker = null;
        }
        if (this.nsReg != null) {
            LOG.info("Unregistering the COW node store");
            this.nsReg.unregister();
            this.nsReg = null;
        }
    }

    @Reference(name="nodeStoreProvider", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, target="(role=copy-on-write)")
    protected void bindNodeStoreProvider(NodeStoreProvider ns, Map<String, ?> config) {
        this.nodeStoreProvider = ns;
        this.nodeStoreDescription = PropertiesUtil.toString(config.get("oak.nodestore.description"), ns.getClass().getName());
        this.registerNodeStore();
    }

    protected void unbindNodeStoreProvider(NodeStoreProvider ns) {
        this.nodeStoreProvider = null;
        this.nodeStoreDescription = null;
        this.unregisterNodeStore();
    }
}

