/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property.jmx;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import org.apache.jackrabbit.oak.api.jmx.Description;
import org.apache.jackrabbit.oak.api.jmx.Name;

public interface PropertyIndexStatsMBean {
    public static final String TYPE = "PropertyIndexStats";

    @Description(value="Determines statistics related to specific property index which can be used to optimize property index definition. Various limits below are provided to ensure that estimation logic does not consume too much resources. If any limits are reached then report would not be considered conclusive and would not have paths set determined")
    public CompositeData getStatsForSpecificIndex(@Name(value="indexPath") @Description(value="Index path for which stats are to be determined") String var1, @Name(value="maxValueCount") @Description(value="Maximum number of values to examine. E.g. 100. Stats calculation would break out after this limit") int var2, @Description(value="Maximum depth to examine. E.g. 5. Stats calculation would break out after this limit") @Name(value="maxDepth") int var3, @Description(value="Maximum number of unique paths to examine. E.g. 100. Stats calculation would break out after this limit") @Name(value="maxPathCount") int var4) throws OpenDataException;

    @Description(value="Determines statistics related to property index for all property index under given path. Various limits below are provided to ensure that estimation logic does not consume too much resources. If any limits are reached then report would not be considered conclusive and would not have paths set determined")
    public TabularData getStatsForAllIndexes(@Name(value="path") @Description(value="Path under which all indexes are to be examined like '/'. Path should not include oak:index") String var1, @Name(value="maxValueCount") @Description(value="Maximum number of values to examine. E.g. 100. Stats calculation would break out after this limit") int var2, @Description(value="Maximum depth to examine. E.g. 5. Stats calculation would break out after this limit") @Name(value="maxDepth") int var3, @Description(value="Maximum number of unique paths to examine. E.g. 100. Stats calculation would break out after this limit") @Name(value="maxPathCount") int var4) throws OpenDataException;
}

