/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.whiteboard;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.spi.whiteboard.Tracker;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractServiceTracker<T> {
    private final Tracker<T> stopped = new Tracker<T>(){

        @Override
        public List<T> getServices() {
            return Collections.emptyList();
        }

        @Override
        public void stop() {
        }
    };
    private final Class<T> type;
    private final Map<String, String> filterProperties;
    private volatile Tracker<T> tracker = this.stopped;

    protected AbstractServiceTracker(@NotNull Class<T> type) {
        this.type = Objects.requireNonNull(type);
        this.filterProperties = null;
    }

    protected AbstractServiceTracker(@NotNull Class<T> type, @NotNull Map<String, String> filterProperties) {
        this.type = Objects.requireNonNull(type);
        this.filterProperties = filterProperties;
    }

    public synchronized void start(Whiteboard whiteboard) {
        Validate.checkState(this.tracker == this.stopped);
        this.tracker = this.filterProperties == null ? whiteboard.track(this.type) : whiteboard.track(this.type, this.filterProperties);
    }

    public synchronized void stop() {
        if (this.tracker != this.stopped) {
            Tracker<T> t = this.tracker;
            this.tracker = this.stopped;
            t.stop();
        }
    }

    protected List<T> getServices() {
        return this.tracker.getServices();
    }
}

