/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.stats;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.GaugeStats;
import org.apache.jackrabbit.oak.stats.HistogramStats;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.SimpleStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.apache.jackrabbit.stats.RepositoryStatisticsImpl;

public final class DefaultStatisticsProvider
implements StatisticsProvider {
    private final RepositoryStatisticsImpl repoStats;
    private final Map<String, SimpleStats> statsMeters = new HashMap<String, SimpleStats>();

    public DefaultStatisticsProvider(ScheduledExecutorService executor) {
        this.repoStats = new RepositoryStatisticsImpl(executor);
    }

    @Override
    public RepositoryStatistics getStats() {
        return this.repoStats;
    }

    @Override
    public MeterStats getMeter(String name, StatsOptions options) {
        return this.getStats(name, true, SimpleStats.Type.METER, options);
    }

    @Override
    public CounterStats getCounterStats(String name, StatsOptions options) {
        return this.getStats(name, false, SimpleStats.Type.COUNTER, options);
    }

    @Override
    public TimerStats getTimer(String name, StatsOptions options) {
        return this.getStats(name, true, SimpleStats.Type.TIMER, options);
    }

    @Override
    public HistogramStats getHistogram(String name, StatsOptions options) {
        return this.getStats(name, true, SimpleStats.Type.HISTOGRAM, options);
    }

    @Override
    public <T> GaugeStats<T> getGauge(String name, Supplier<T> supplier) {
        return this.statsMeters.computeIfAbsent(name, k -> new SimpleStats(new AtomicLong(), SimpleStats.Type.GAUGE, supplier.get()));
    }

    private synchronized SimpleStats getStats(String type, boolean resetValueEachSecond, SimpleStats.Type statsType, StatsOptions options) {
        SimpleStats stats = this.statsMeters.get(type);
        if (stats == null) {
            RepositoryStatistics.Type enumType = RepositoryStatistics.Type.getType(type);
            stats = enumType != null ? new SimpleStats(this.repoStats.getCounter(enumType), statsType) : (options.isTimeSeriesEnabled() ? new SimpleStats(this.repoStats.getCounter(type, resetValueEachSecond), statsType) : new SimpleStats(new AtomicLong(), statsType));
            this.statsMeters.put(type, stats);
        }
        return stats;
    }
}

