/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming.ui;

import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.spark.sql.streaming.ui.StreamingQueryDataSource;
import org.apache.spark.sql.streaming.ui.StreamingQueryTab;
import org.apache.spark.sql.streaming.ui.StreamingQueryUIData;
import org.apache.spark.sql.streaming.ui.StructuredStreamingRow;
import org.apache.spark.sql.streaming.ui.UIUtils$;
import org.apache.spark.ui.PagedDataSource;
import org.apache.spark.ui.PagedTable;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0005\u0005Uc!B\u000f\u001f\u0001yQ\u0003\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\t\u0011\u0019\u0003!\u0011!Q\u0001\n\u001dC\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t5\u0002\u0011\t\u0011)A\u00057\"A1\r\u0001B\u0001B\u0003%A\r\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003\\\u0011!A\u0007A!A!\u0002\u0013Y\u0006\"B5\u0001\t\u0003Q\u0007BC:\u0001!\u0003\u0005\u0019\u0011)A\u0005i\"9!\u0010\u0001b\u0001\n\u0013Y\bB\u0002?\u0001A\u0003%1\fC\u0004~\u0001\t\u0007I\u0011\u0002@\t\r}\u0004\u0001\u0015!\u0003e\u0011%\t\t\u0001\u0001b\u0001\n\u0013\t\u0019\u0001C\u0004\u0002\u0006\u0001\u0001\u000b\u0011B<\t\u0011\u0005\u001d\u0001A1A\u0005\nmDq!!\u0003\u0001A\u0003%1\fC\u0005\u0002\f\u0001\u0011\r\u0011\"\u0003\u0002\u000e!A\u0011Q\u0004\u0001!\u0002\u0013\ty\u0001\u0003\u0004\u0002 \u0001!\te\u001f\u0005\u0007\u0003C\u0001A\u0011I>\t\r\u0005\r\u0002\u0001\"\u0011|\u0011\u0019\t)\u0003\u0001C!w\"9\u0011q\u0005\u0001\u0005B\u0005%\u0002BBA\u0018\u0001\u0011\u00053\u0010C\u0004\u00022\u0001!\t%a\r\t\u000f\u0005m\u0002\u0001\"\u0011\u0002>!9\u0011Q\n\u0001\u0005B\u0005=#\u0001G*ue\u0016\fW.\u001b8h#V,'/\u001f)bO\u0016$G+\u00192mK*\u0011q\u0004I\u0001\u0003k&T!!\t\u0012\u0002\u0013M$(/Z1nS:<'BA\u0012%\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003K\u0019\nQa\u001d9be.T!a\n\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0013aA8sON\u0019\u0001aK\u0019\u0011\u00051zS\"A\u0017\u000b\u00039\nQa]2bY\u0006L!\u0001M\u0017\u0003\r\u0005s\u0017PU3g!\r\u0011DGN\u0007\u0002g)\u0011q\u0004J\u0005\u0003kM\u0012!\u0002U1hK\u0012$\u0016M\u00197f!\t9\u0004(D\u0001\u001f\u0013\tIdD\u0001\fTiJ,8\r^;sK\u0012\u001cFO]3b[&twMU8x\u0003\u001d\u0011X-];fgR\u001c\u0001\u0001\u0005\u0002>\t6\taH\u0003\u0002@\u0001\u0006!\u0001\u000e\u001e;q\u0015\t\t%)A\u0004tKJ4H.\u001a;\u000b\u0003\r\u000bQA[1wCbL!!\u0012 \u0003%!#H\u000f]*feZdW\r\u001e*fcV,7\u000f^\u0001\u0007a\u0006\u0014XM\u001c;\u0011\u0005]B\u0015BA%\u001f\u0005E\u0019FO]3b[&tw-U;fef$\u0016MY\u0001\u0005I\u0006$\u0018\rE\u0002M)^s!!\u0014*\u000f\u00059\u000bV\"A(\u000b\u0005A[\u0014A\u0002\u001fs_>$h(C\u0001/\u0013\t\u0019V&A\u0004qC\u000e\\\u0017mZ3\n\u0005U3&aA*fc*\u00111+\f\t\u0003oaK!!\u0017\u0010\u0003)M#(/Z1nS:<\u0017+^3ssVKE)\u0019;b\u0003!!\u0018M\u00197f)\u0006<\u0007C\u0001/a\u001d\tif\f\u0005\u0002O[%\u0011q,L\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0014'AB*ue&twM\u0003\u0002`[\u0005A\u0011n]!di&4X\r\u0005\u0002-K&\u0011a-\f\u0002\b\u0005>|G.Z1o\u0003!\u0011\u0017m]3QCRD\u0017aB:vEB\u000bG\u000f[\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011-dWN\\8qcJ\u0004\"a\u000e\u0001\t\u000biB\u0001\u0019\u0001\u001f\t\u000b\u0019C\u0001\u0019A$\t\u000b)C\u0001\u0019A&\t\u000biC\u0001\u0019A.\t\u000b\rD\u0001\u0019\u00013\t\u000b\u001dD\u0001\u0019A.\t\u000b!D\u0001\u0019A.\u0002\u0007a$C\u0007E\u0003-kn#w/\u0003\u0002w[\t1A+\u001e9mKN\u0002\"\u0001\f=\n\u0005el#aA%oi\u0006Q1o\u001c:u\u0007>dW/\u001c8\u0016\u0003m\u000b1b]8si\u000e{G.^7oA\u0005A1o\u001c:u\t\u0016\u001c8-F\u0001e\u0003%\u0019xN\u001d;EKN\u001c\u0007%\u0001\u0005qC\u001e,7+\u001b>f+\u00059\u0018!\u00039bO\u0016\u001c\u0016N_3!\u00035\u0001\u0018M]1nKR,'\u000fU1uQ\u0006q\u0001/\u0019:b[\u0016$XM\u001d)bi\"\u0004\u0013!E3oG>$W\rZ*peR\u001cu\u000e\\;n]V\u0011\u0011q\u0002\t\u0005\u0003#\tY\"\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003\u0011a\u0017M\\4\u000b\u0005\u0005e\u0011\u0001\u00026bm\u0006L1!YA\n\u0003I)gnY8eK\u0012\u001cvN\u001d;D_2,XN\u001c\u0011\u0002\u000fQ\f'\r\\3JI\u0006iA/\u00192mK\u000e\u001b8o\u00117bgN\f\u0011\u0003]1hKNK'0\u001a$pe64\u0015.\u001a7e\u0003M\u0001\u0018mZ3Ok6\u0014WM\u001d$pe64\u0015.\u001a7e\u0003!\u0001\u0018mZ3MS:\\GcA.\u0002,!1\u0011Q\u0006\rA\u0002]\fA\u0001]1hK\u0006\u0001rm\u001c\"viR|gNR8s[B\u000bG\u000f[\u0001\u000bI\u0006$\u0018mU8ve\u000e,WCAA\u001b!\u0011\u0011\u0014q\u0007\u001c\n\u0007\u0005e2GA\bQC\u001e,G\rR1uCN{WO]2f\u0003\u001dAW-\u00193feN,\"!a\u0010\u0011\t1#\u0016\u0011\t\t\u0005\u0003\u0007\nI%\u0004\u0002\u0002F)\u0019\u0011qI\u0017\u0002\u0007alG.\u0003\u0003\u0002L\u0005\u0015#\u0001\u0002(pI\u0016\f1A]8x)\u0011\ty$!\u0015\t\r\u0005MC\u00041\u00017\u0003\u0015\tX/\u001a:z\u0001")
public class StreamingQueryPagedTable
implements PagedTable<StructuredStreamingRow> {
    private final HttpServletRequest request;
    private final StreamingQueryTab parent;
    private final scala.collection.immutable.Seq<StreamingQueryUIData> data;
    private final String tableTag;
    private final boolean isActive;
    private final /* synthetic */ Tuple3 x$4;
    private final String sortColumn;
    private final boolean sortDesc;
    private final int pageSize;
    private final String parameterPath;
    private final String encodedSortColumn;

    public scala.collection.immutable.Seq<Node> table(int page) {
        return PagedTable.table$((PagedTable)this, (int)page);
    }

    public scala.collection.immutable.Seq<Node> pageNavigation(int page, int pageSize, int totalPages, String navigationId) {
        return PagedTable.pageNavigation$((PagedTable)this, (int)page, (int)pageSize, (int)totalPages, (String)navigationId);
    }

    public String pageNavigation$default$4() {
        return PagedTable.pageNavigation$default$4$((PagedTable)this);
    }

    public String getParameterOtherTable(HttpServletRequest request, String tableTag) {
        return PagedTable.getParameterOtherTable$((PagedTable)this, (HttpServletRequest)request, (String)tableTag);
    }

    public Tuple3<String, Object, Object> getTableParameters(HttpServletRequest request, String tableTag, String defaultSortColumn) {
        return PagedTable.getTableParameters$((PagedTable)this, (HttpServletRequest)request, (String)tableTag, (String)defaultSortColumn);
    }

    public void isSortColumnValid(scala.collection.immutable.Seq<Tuple3<String, Object, Option<String>>> headerInfo, String sortColumn) {
        PagedTable.isSortColumnValid$((PagedTable)this, headerInfo, (String)sortColumn);
    }

    public scala.collection.immutable.Seq<Node> headerRow(scala.collection.immutable.Seq<Tuple3<String, Object, Option<String>>> headerInfo, boolean desc, int pageSize, String sortColumn, String parameterPath, String tableTag, String headerId) {
        return PagedTable.headerRow$((PagedTable)this, headerInfo, (boolean)desc, (int)pageSize, (String)sortColumn, (String)parameterPath, (String)tableTag, (String)headerId);
    }

    private String sortColumn() {
        return this.sortColumn;
    }

    private boolean sortDesc() {
        return this.sortDesc;
    }

    private int pageSize() {
        return this.pageSize;
    }

    private String parameterPath() {
        return this.parameterPath;
    }

    private String encodedSortColumn() {
        return this.encodedSortColumn;
    }

    public String tableId() {
        return new StringBuilder(6).append(this.tableTag).append("-table").toString();
    }

    public String tableCssClass() {
        return "table table-bordered table-sm table-striped table-head-clickable table-cell-width-limited";
    }

    public String pageSizeFormField() {
        return new StringBuilder(9).append(this.tableTag).append(".pageSize").toString();
    }

    public String pageNumberFormField() {
        return new StringBuilder(5).append(this.tableTag).append(".page").toString();
    }

    public String pageLink(int page) {
        return new StringBuilder(0).append(this.parameterPath()).append(new StringBuilder(2).append("&").append(this.pageNumberFormField()).append("=").append(page).toString()).append(new StringBuilder(7).append("&").append(this.tableTag).append(".sort=").append(this.encodedSortColumn()).toString()).append(new StringBuilder(7).append("&").append(this.tableTag).append(".desc=").append(this.sortDesc()).toString()).append(new StringBuilder(2).append("&").append(this.pageSizeFormField()).append("=").append(this.pageSize()).toString()).append(new StringBuilder(1).append("#").append(this.tableTag).toString()).toString();
    }

    public String goButtonFormPath() {
        return new StringBuilder(15).append(this.parameterPath()).append("&").append(this.tableTag).append(".sort=").append(this.encodedSortColumn()).append("&").append(this.tableTag).append(".desc=").append(this.sortDesc()).append("#").append(this.tableTag).toString();
    }

    public PagedDataSource<StructuredStreamingRow> dataSource() {
        return new StreamingQueryDataSource(this.data, this.sortColumn(), this.sortDesc(), this.pageSize(), this.isActive);
    }

    public scala.collection.immutable.Seq<Node> headers() {
        scala.collection.immutable.Seq headerAndCss = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"Name", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Status", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"ID", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Run ID", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Start Time", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Duration", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Avg Input /sec", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Avg Process /sec", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Latest Batch", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$)})).$plus$plus((IterableOnce)(!this.isActive ? package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"Error", (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)None$.MODULE$)})) : package$.MODULE$.Nil()));
        this.isSortColumnValid((scala.collection.immutable.Seq<Tuple3<String, Object, Option<String>>>)headerAndCss, this.sortColumn());
        return this.headerRow((scala.collection.immutable.Seq<Tuple3<String, Object, Option<String>>>)headerAndCss, this.sortDesc(), this.pageSize(), this.sortColumn(), this.parameterPath(), this.tableTag, this.tableTag);
    }

    public scala.collection.immutable.Seq<Node> row(StructuredStreamingRow query) {
        StreamingQueryUIData streamingQuery = query.streamingUIData();
        String statisticsLink = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s/%s/statistics/?id=%s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri(this.request, this.parent.basePath(), org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri$default$3()), this.parent.prefix(), streamingQuery.summary().runId()}));
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)UIUtils$.MODULE$.getQueryName(streamingQuery));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)UIUtils$.MODULE$.getQueryStatus(streamingQuery));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)streamingQuery.summary().id());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("href", statisticsLink, (MetaData)$md);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)streamingQuery.summary().runId());
        $buf5.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.formatDate(streamingQuery.summary().startTimestamp()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.formatDurationVerbose(query.duration()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)UIUtils$.MODULE$.withNoProgress(streamingQuery, (Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%.2f"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)query.avgInput())})), "NaN"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)UIUtils$.MODULE$.withNoProgress(streamingQuery, (Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%.2f"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)query.avgProcess())})), "NaN"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)UIUtils$.MODULE$.withNoProgress(streamingQuery, (JFunction0.mcJ.sp & Serializable)() -> streamingQuery.lastProgress().batchId(), "NaN"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)this.details$1(streamingQuery.summary().exception().getOrElse((Function0 & Serializable)() -> "-")));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    private final scala.collection.immutable.Seq details$1(Object detail) {
        if (this.isActive) {
            return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        }
        String detailString = (String)detail;
        boolean isMultiline = detailString.indexOf(10) >= 0;
        String summary = StringEscapeUtils.escapeHtml4((String)(isMultiline ? detailString.substring(0, detailString.indexOf(10)) : detailString));
        scala.collection.immutable.Seq details = org.apache.spark.ui.UIUtils$.MODULE$.detailsUINode(isMultiline, detailString);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)summary);
        $buf.$amp$plus((Object)details);
        return new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    public StreamingQueryPagedTable(HttpServletRequest request, StreamingQueryTab parent, scala.collection.immutable.Seq<StreamingQueryUIData> data, String tableTag, boolean isActive, String basePath, String subPath) {
        this.request = request;
        this.parent = parent;
        this.data = data;
        this.tableTag = tableTag;
        this.isActive = isActive;
        PagedTable.$init$((PagedTable)this);
        Tuple3<String, Object, Object> tuple3 = this.getTableParameters(request, tableTag, "Start Time");
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String sortColumn = (String)tuple3._1();
        boolean sortDesc = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
        int pageSize = BoxesRunTime.unboxToInt((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)sortColumn, (Object)BoxesRunTime.boxToBoolean((boolean)sortDesc), (Object)BoxesRunTime.boxToInteger((int)pageSize));
        this.x$4 = tuple32;
        this.sortColumn = (String)this.x$4._1();
        this.sortDesc = BoxesRunTime.unboxToBoolean((Object)this.x$4._2());
        this.pageSize = BoxesRunTime.unboxToInt((Object)this.x$4._3());
        this.parameterPath = new StringBuilder(3).append(basePath).append("/").append(subPath).append("/?").append(this.getParameterOtherTable(request, tableTag)).toString();
        this.encodedSortColumn = URLEncoder.encode(this.sortColumn(), StandardCharsets.UTF_8.name());
    }
}

