/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import org.apache.spark.unsafe.types.UTF8String;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Statics;

public final class HashingTF$
implements Serializable {
    public static final HashingTF$ MODULE$ = new HashingTF$();
    private static final String Native = "native";
    private static final String Murmur3 = "murmur3";
    private static final int seed = 42;

    public String Native() {
        return Native;
    }

    public String Murmur3() {
        return Murmur3;
    }

    public int seed() {
        return seed;
    }

    public int nativeHash(Object term) {
        return Statics.anyHash((Object)term);
    }

    public int murmur3Hash(Object term) {
        Object object = term;
        if (object == null) {
            return this.seed();
        }
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            return Murmur3_x86_32.hashInt((int)(bl ? 1 : 0), (int)this.seed());
        }
        if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            return Murmur3_x86_32.hashInt((int)by, (int)this.seed());
        }
        if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            return Murmur3_x86_32.hashInt((int)s, (int)this.seed());
        }
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            return Murmur3_x86_32.hashInt((int)n, (int)this.seed());
        }
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            return Murmur3_x86_32.hashLong((long)l, (int)this.seed());
        }
        if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            return Murmur3_x86_32.hashInt((int)Float.floatToIntBits(f), (int)this.seed());
        }
        if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            return Murmur3_x86_32.hashLong((long)Double.doubleToLongBits(d), (int)this.seed());
        }
        if (object instanceof String) {
            String string = (String)object;
            UTF8String utf8 = UTF8String.fromString((String)string);
            return Murmur3_x86_32.hashUnsafeBytes((Object)utf8.getBaseObject(), (long)utf8.getBaseOffset(), (int)utf8.numBytes(), (int)this.seed());
        }
        throw new SparkException("HashingTF with murmur3 algorithm does not support type " + term.getClass().getCanonicalName() + " of input data.");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HashingTF$.class);
    }

    private HashingTF$() {
    }
}

