/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg.distributed;

import breeze.generic.UFunc;
import breeze.gymnastics.NotGiven$;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.LU;
import breeze.linalg.MatrixSingularException;
import breeze.linalg.NumericOps;
import breeze.linalg.inv$;
import breeze.linalg.operators.HasOps$;
import breeze.linalg.qr;
import breeze.linalg.svd;
import breeze.linalg.svd$;
import breeze.numerics.package;
import breeze.storage.Zero$;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.ml.stat.SummarizerBuffer;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.EigenValueDecomposition$;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.QRDecomposition;
import org.apache.spark.mllib.linalg.SingularValueDecomposition;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.linalg.distributed.CoordinateMatrix;
import org.apache.spark.mllib.linalg.distributed.DistributedMatrix;
import org.apache.spark.mllib.linalg.distributed.MatrixEntry;
import org.apache.spark.mllib.linalg.distributed.RowMatrix$;
import org.apache.spark.mllib.linalg.distributed.RowMatrix$SVDMode$1$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import org.apache.spark.mllib.stat.Statistics$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\t\u001de\u0001B\u0015+\u0001]B\u0001\u0002\u0013\u0001\u0003\u0006\u0004%\t!\u0013\u0005\t;\u0002\u0011\t\u0011)A\u0005\u0015\"Aq\f\u0001BA\u0002\u0013%\u0001\r\u0003\u0005e\u0001\t\u0005\r\u0011\"\u0003f\u0011!Y\u0007A!A!B\u0013\t\u0007\u0002\u00037\u0001\u0005\u0003\u0007I\u0011B7\t\u0011E\u0004!\u00111A\u0005\nID\u0001\u0002\u001e\u0001\u0003\u0002\u0003\u0006KA\u001c\u0005\u0006k\u0002!\tA\u001e\u0005\u0006k\u0002!\t! \u0005\b\u0003\u0003\u0001A\u0011IA\u0002\u0011\u001d\t9\u0001\u0001C!\u0003\u0007A\u0001\"a\u0003\u0001\t\u0003q\u0013Q\u0002\u0005\b\u0003O\u0001A\u0011AA\u0015\u0011\u001d\t\u0019\u0004\u0001C\u0005\u0003kAq!a\u0011\u0001\t\u0013\t)\u0005C\u0004\u0002N\u0001!I!a\u0014\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X!I\u00111\u000f\u0001\u0012\u0002\u0013\u0005\u0011Q\u000f\u0005\n\u0003\u0013\u0003\u0011\u0013!C\u0001\u0003\u0017C\u0001\"!\u0016\u0001\t\u0003q\u0013q\u0012\u0005\b\u0003s\u0003A\u0011BA^\u0011\u001d\ti\f\u0001C\u0001\u0003SAq!!1\u0001\t\u0003\t\u0019\rC\u0004\u0002T\u0002!\t!!6\t\u000f\u0005m\u0007\u0001\"\u0001\u0002^\"9\u0011Q\u001e\u0001\u0005\u0002\u0005=\bbBA|\u0001\u0011\u0005\u0011\u0011 \u0005\b\u0003o\u0004A\u0011\u0001B\u0004\u0011\u001d\u0011y\u0001\u0001C\u0001\u0005#A\u0011Ba\t\u0001#\u0003%\t!!\u001e\t\u0011\t\u0015\u0002\u0001\"\u0001/\u0005OA\u0001Ba\u000e\u0001\t\u0003r#\u0011\b\u0005\b\u0005\u0003\u0002A\u0011\u0002B\"\u0011!\u00119\u0005\u0001C\u0001a\t%sa\u0002B)U!\u0005!1\u000b\u0004\u0007S)B\tA!\u0016\t\rU,C\u0011\u0001B4\u0011\u001d\u0011I'\nC\u0005\u0005WB\u0011Ba\u001d&\u0003\u0003%IA!\u001e\u0003\u0013I{w/T1ue&D(BA\u0016-\u0003-!\u0017n\u001d;sS\n,H/\u001a3\u000b\u00055r\u0013A\u00027j]\u0006dwM\u0003\u00020a\u0005)Q\u000e\u001c7jE*\u0011\u0011GM\u0001\u0006gB\f'o\u001b\u0006\u0003gQ\na!\u00199bG\",'\"A\u001b\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001AdH\u0011\t\u0003sqj\u0011A\u000f\u0006\u0002w\u0005)1oY1mC&\u0011QH\u000f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005}\u0002U\"\u0001\u0016\n\u0005\u0005S#!\u0005#jgR\u0014\u0018NY;uK\u0012l\u0015\r\u001e:jqB\u00111IR\u0007\u0002\t*\u0011Q\tM\u0001\tS:$XM\u001d8bY&\u0011q\t\u0012\u0002\b\u0019><w-\u001b8h\u0003\u0011\u0011xn^:\u0016\u0003)\u00032a\u0013(Q\u001b\u0005a%BA'1\u0003\r\u0011H\rZ\u0005\u0003\u001f2\u00131A\u0015#E!\t\t&+D\u0001-\u0013\t\u0019FF\u0001\u0004WK\u000e$xN\u001d\u0015\u0004\u0003U[\u0006C\u0001,Z\u001b\u00059&B\u0001-1\u0003)\tgN\\8uCRLwN\\\u0005\u00035^\u0013QaU5oG\u0016\f\u0013\u0001X\u0001\u0006c9\u0002d\u0006M\u0001\u0006e><8\u000f\t\u0015\u0004\u0005U[\u0016!\u00028S_^\u001cX#A1\u0011\u0005e\u0012\u0017BA2;\u0005\u0011auN\\4\u0002\u00139\u0014vn^:`I\u0015\fHC\u00014j!\tIt-\u0003\u0002iu\t!QK\\5u\u0011\u001dQG!!AA\u0002\u0005\f1\u0001\u001f\u00132\u0003\u0019q'k\\<tA\u0005)anQ8mgV\ta\u000e\u0005\u0002:_&\u0011\u0001O\u000f\u0002\u0004\u0013:$\u0018!\u00038D_2\u001cx\fJ3r)\t17\u000fC\u0004k\u000f\u0005\u0005\t\u0019\u00018\u0002\r9\u001cu\u000e\\:!\u0003\u0019a\u0014N\\5u}Q!q\u000f\u001f>|!\ty\u0004\u0001C\u0003I\u0013\u0001\u0007!\nK\u0002y+nCQaX\u0005A\u0002\u0005DQ\u0001\\\u0005A\u00029D3!C+\\)\t9h\u0010C\u0003I\u0015\u0001\u0007!\nK\u0002\u000b+n\u000bqA\\;n\u0007>d7\u000fF\u0001bQ\rYQkW\u0001\b]Vl'k\\<tQ\raQkW\u0001\u0018[VdG/\u001b9ms\u001e\u0013\u0018-\\5b]6\u000bGO]5y\u0005f$B!a\u0004\u0002$A1\u0011\u0011CA\r\u0003;i!!a\u0005\u000b\u00075\n)B\u0003\u0002\u0002\u0018\u00051!M]3fu\u0016LA!a\u0007\u0002\u0014\tYA)\u001a8tKZ+7\r^8s!\rI\u0014qD\u0005\u0004\u0003CQ$A\u0002#pk\ndW\rC\u0004\u0002&5\u0001\r!a\u0004\u0002\u0003Y\fAcY8naV$Xm\u0012:b[&\fg.T1ue&DHCAA\u0016!\r\t\u0016QF\u0005\u0004\u0003_a#AB'biJL\u0007\u0010K\u0002\u000f+n\u000bAdY8naV$X\rR3og\u00164Vm\u0019;pe\u000e{g/\u0019:jC:\u001cW\r\u0006\u0005\u0002,\u0005]\u00121HA \u0011\u0019\tId\u0004a\u0001!\u0006!Q.Z1o\u0011\u0019\tid\u0004a\u0001]\u0006\ta\u000e\u0003\u0004\u0002B=\u0001\r!Y\u0001\u0002[\u0006i2m\\7qkR,7\u000b]1sg\u00164Vm\u0019;pe\u000e{g/\u0019:jC:\u001cW\r\u0006\u0005\u0002,\u0005\u001d\u0013\u0011JA&\u0011\u0019\tI\u0004\u0005a\u0001!\"1\u0011Q\b\tA\u00029Da!!\u0011\u0011\u0001\u0004\t\u0017aD2iK\u000e\\g*^7D_2,XN\\:\u0015\u0007\u0019\f\t\u0006\u0003\u0004\u0002TE\u0001\rA\\\u0001\u0005G>d7/\u0001\u0006d_6\u0004X\u000f^3T-\u0012#\u0002\"!\u0017\u0002`\u0005\r\u0014Q\u000e\t\u0007#\u0006ms/a\u000b\n\u0007\u0005uCF\u0001\u000eTS:<W\u000f\\1s-\u0006dW/\u001a#fG>l\u0007o\\:ji&|g\u000e\u0003\u0004\u0002bI\u0001\rA\\\u0001\u0002W\"I\u0011Q\r\n\u0011\u0002\u0003\u0007\u0011qM\u0001\tG>l\u0007/\u001e;f+B\u0019\u0011(!\u001b\n\u0007\u0005-$HA\u0004C_>dW-\u00198\t\u0013\u0005=$\u0003%AA\u0002\u0005u\u0011!\u0002:D_:$\u0007f\u0001\nV7\u0006!2m\\7qkR,7K\u0016#%I\u00164\u0017-\u001e7uII*\"!a\u001e+\t\u0005\u001d\u0014\u0011P\u0016\u0003\u0003w\u0002B!! \u0002\u00066\u0011\u0011q\u0010\u0006\u0005\u0003\u0003\u000b\u0019)A\u0005v]\u000eDWmY6fI*\u0011\u0001LO\u0005\u0005\u0003\u000f\u000byHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAcY8naV$Xm\u0015,EI\u0011,g-Y;mi\u0012\u001aTCAAGU\u0011\ti\"!\u001f\u0015\u001d\u0005e\u0013\u0011SAJ\u0003+\u000b9*a'\u0002 \"1\u0011\u0011M\u000bA\u00029Dq!!\u001a\u0016\u0001\u0004\t9\u0007C\u0004\u0002pU\u0001\r!!\b\t\r\u0005eU\u00031\u0001o\u0003\u001di\u0017\r_%uKJDq!!(\u0016\u0001\u0004\ti\"A\u0002u_2Dq!!)\u0016\u0001\u0004\t\u0019+\u0001\u0003n_\u0012,\u0007\u0003BAS\u0003gsA!a*\u00020B\u0019\u0011\u0011\u0016\u001e\u000e\u0005\u0005-&bAAWm\u00051AH]8pizJ1!!-;\u0003\u0019\u0001&/\u001a3fM&!\u0011QWA\\\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0017\u001e\u0002\u001d%\u001c8\u000b]1sg\u0016l\u0015\r\u001e:jqV\u0011\u0011qM\u0001\u0012G>l\u0007/\u001e;f\u0007>4\u0018M]5b]\u000e,\u0007fA\fV7\u0006q3m\\7qkR,\u0007K]5oG&\u0004\u0018\r\\\"p[B|g.\u001a8ug\u0006sG-\u0012=qY\u0006Lg.\u001a3WCJL\u0017M\\2f)\u0011\t)-a3\u0011\re\n9-a\u000bQ\u0013\r\tIM\u000f\u0002\u0007)V\u0004H.\u001a\u001a\t\r\u0005\u0005\u0004\u00041\u0001oQ\u0011AR+a4\"\u0005\u0005E\u0017!B\u0019/m9\u0002\u0014AG2p[B,H/\u001a)sS:\u001c\u0017\u000e]1m\u0007>l\u0007o\u001c8f]R\u001cH\u0003BA\u0016\u0003/Da!!\u0019\u001a\u0001\u0004q\u0007fA\rV7\u0006q2m\\7qkR,7i\u001c7v[:\u001cV/\\7bef\u001cF/\u0019;jgRL7m\u001d\u000b\u0003\u0003?\u0004B!!9\u0002h6\u0011\u00111\u001d\u0006\u0004\u0003Kt\u0013\u0001B:uCRLA!!;\u0002d\nqR*\u001e7uSZ\f'/[1uKN#\u0018\r^5ti&\u001c\u0017\r\\*v[6\f'/\u001f\u0015\u00045U[\u0016\u0001C7vYRL\u0007\u000f\\=\u0015\u0007]\f\t\u0010C\u0004\u0002tn\u0001\r!a\u000b\u0002\u0003\tC3aG+\\\u0003I\u0019w\u000e\\;n]NKW.\u001b7be&$\u0018.Z:\u0015\u0005\u0005m\bcA \u0002~&\u0019\u0011q \u0016\u0003!\r{wN\u001d3j]\u0006$X-T1ue&D\b\u0006\u0002\u000fV\u0005\u0007\t#A!\u0002\u0002\u000bEr#G\f\u0019\u0015\t\u0005m(\u0011\u0002\u0005\b\u0005\u0017i\u0002\u0019AA\u000f\u0003%!\bN]3tQ>dG\r\u000b\u0003\u001e+\n\r\u0011\u0001\u0004;bY2\u001c6.\u001b8osF\u0013F\u0003\u0002B\n\u00053\u0001b!\u0015B\u000bo\u0006-\u0012b\u0001B\fY\ty\u0011K\u0015#fG>l\u0007o\\:ji&|g\u000eC\u0005\u0003\u001cy\u0001\n\u00111\u0001\u0002h\u0005A1m\\7qkR,\u0017\u000b\u000b\u0003\u001f+\n}\u0011E\u0001B\u0011\u0003\u0015\td&\u000e\u00181\u0003Y!\u0018\r\u001c7TW&tg._)SI\u0011,g-Y;mi\u0012\n\u0014\u0001G2pYVlgnU5nS2\f'/\u001b;jKN$\u0015*T*V\u001bR1\u00111 B\u0015\u0005gAqAa\u000b!\u0001\u0004\u0011i#A\u0004d_2l\u0015mZ:\u0011\u000be\u0012y#!\b\n\u0007\tE\"HA\u0003BeJ\f\u0017\u0010C\u0004\u00036\u0001\u0002\r!!\b\u0002\u000b\u001d\fW.\\1\u0002\u0011Q|'I]3fu\u0016$\"Aa\u000f\u0011\r\u0005E!QHA\u000f\u0013\u0011\u0011y$a\u0005\u0003\u0017\u0011+gn]3NCR\u0014\u0018\u000e_\u0001\u000ekB$\u0017\r^3Ok6\u0014vn^:\u0015\u0007\u0019\u0014)\u0005\u0003\u0004\u0002B\t\u0002\r!Y\u0001\u001bO\u0016$HK]3f\u0003\u001e<'/Z4bi\u0016LE-Z1m\t\u0016\u0004H\u000f\u001b\u000b\u0004]\n-\u0003B\u0002B'G\u0001\u0007\u0011-A\u000ebO\u001e\u0014XmZ1uK\u0012|%M[3diNK'0Z%o\u0005f$Xm\u001d\u0015\u0004\u0001U[\u0016!\u0003*po6\u000bGO]5y!\tyTe\u0005\u0003&q\t]\u0003\u0003\u0002B-\u0005Gj!Aa\u0017\u000b\t\tu#qL\u0001\u0003S>T!A!\u0019\u0002\t)\fg/Y\u0005\u0005\u0005K\u0012YF\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0003T\u0005QAO]5v)>4U\u000f\u001c7\u0015\r\u0005-\"Q\u000eB8\u0011\u0019\tid\na\u0001]\"9!\u0011O\u0014A\u0002\t5\u0012!A+\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t]\u0004\u0003\u0002B=\u0005\u007fj!Aa\u001f\u000b\t\tu$qL\u0001\u0005Y\u0006tw-\u0003\u0003\u0003\u0002\nm$AB(cU\u0016\u001cG\u000fK\u0002&+nC3\u0001J+\\\u0001")
public class RowMatrix
implements DistributedMatrix,
Logging {
    private final RDD<Vector> rows;
    private long nRows;
    private int nCols;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public RDD<Vector> rows() {
        return this.rows;
    }

    private long nRows() {
        return this.nRows;
    }

    private void nRows_$eq(long x$1) {
        this.nRows = x$1;
    }

    private int nCols() {
        return this.nCols;
    }

    private void nCols_$eq(int x$1) {
        this.nCols = x$1;
    }

    @Override
    public long numCols() {
        if (this.nCols() <= 0) {
            try {
                this.nCols_$eq(((Vector)this.rows().first()).size());
            }
            catch (UnsupportedOperationException err) {
                throw scala.sys.package$.MODULE$.error("Cannot determine the number of cols because it is not specified in the constructor and the rows RDD is empty.");
            }
        }
        return this.nCols();
    }

    @Override
    public long numRows() {
        if (this.nRows() <= 0L) {
            this.nRows_$eq(this.rows().count());
            if (this.nRows() == 0L) {
                throw scala.sys.package$.MODULE$.error("Cannot determine the number of rows because it is not specified in the constructor and the rows RDD is empty.");
            }
        }
        return this.nRows();
    }

    public breeze.linalg.DenseVector<Object> multiplyGramianMatrixBy(breeze.linalg.DenseVector<Object> v) {
        int n = (int)this.numCols();
        Broadcast vbr = this.rows().context().broadcast(v, ClassTag$.MODULE$.apply(breeze.linalg.DenseVector.class));
        Object x$1 = null;
        Function2 & Serializable x$2 = (Function2 & Serializable)(U, r) -> {
            breeze.linalg.Vector<Object> rBrz = r.asBreeze();
            double a = BoxesRunTime.unboxToDouble((Object)rBrz.dot(vbr.value(), HasOps$.MODULE$.castOps_V_V((.less.colon.less)$less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl(), NotGiven$.MODULE$.neq(), (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulInner_V_V_eq_S_Double())));
            breeze.linalg.DenseVector theU = U == null ? breeze.linalg.DenseVector$.MODULE$.zeros$mDc$sp(n, (ClassTag)ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero()) : U;
            breeze.linalg.Vector<Object> vector = rBrz;
            if (vector instanceof breeze.linalg.DenseVector) {
                breeze.linalg.package$.MODULE$.axpy((Object)BoxesRunTime.boxToDouble((double)a), (Object)((breeze.linalg.DenseVector)rBrz), (Object)theU, (UFunc.InPlaceImpl3)HasOps$.MODULE$.impl_scaleAdd_InPlace_DV_T_DV_Double());
            } else if (vector instanceof breeze.linalg.SparseVector) {
                breeze.linalg.package$.MODULE$.axpy((Object)BoxesRunTime.boxToDouble((double)a), (Object)((breeze.linalg.SparseVector)rBrz), (Object)theU, HasOps$.MODULE$.implScaleAdd_DV_S_SV_InPlace_Double());
            } else {
                throw new UnsupportedOperationException("Do not support vector operation from type " + rBrz.getClass().getName() + ".");
            }
            return theU;
        };
        Function2 & Serializable x$3 = (Function2 & Serializable)(U1, U2) -> {
            if (U1 == null) {
                return U2;
            }
            if (U2 == null) {
                return U1;
            }
            U1.$plus$eq(U2, HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double());
            return U1;
        };
        int x$4 = this.rows().treeAggregate$default$4(x$1);
        return (breeze.linalg.DenseVector)this.rows().treeAggregate(x$1, (Function2)x$2, (Function2)x$3, x$4, ClassTag$.MODULE$.apply(breeze.linalg.DenseVector.class));
    }

    public Matrix computeGramianMatrix() {
        int n = (int)this.numCols();
        this.checkNumColumns(n);
        int nt = n % 2 == 0 ? n / 2 * (n + 1) : n * ((n + 1) / 2);
        long gramianSizeInBytes = (long)nt * 8L;
        breeze.linalg.DenseVector GU = (breeze.linalg.DenseVector)this.rows().treeAggregate(null, (Function2 & Serializable)(maybeU, v) -> {
            breeze.linalg.DenseVector U = maybeU == null ? new DenseVector.mcD.sp(nt, (ClassTag)ClassTag$.MODULE$.Double()) : maybeU;
            BLAS$.MODULE$.spr(1.0, (Vector)v, U.data$mcD$sp());
            return U;
        }, (Function2 & Serializable)(U1, U2) -> {
            if (U1 == null) {
                return U2;
            }
            if (U2 == null) {
                return U1;
            }
            return (breeze.linalg.DenseVector)U1.$plus$eq(U2, HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double());
        }, this.getTreeAggregateIdealDepth(gramianSizeInBytes), ClassTag$.MODULE$.apply(breeze.linalg.DenseVector.class));
        return RowMatrix$.MODULE$.org$apache$spark$mllib$linalg$distributed$RowMatrix$$triuToFull(n, GU.data$mcD$sp());
    }

    private Matrix computeDenseVectorCovariance(Vector mean, int n, long m) {
        Broadcast bc = this.rows().context().broadcast((Object)mean, ClassTag$.MODULE$.apply(Vector.class));
        int nt = n % 2 == 0 ? n / 2 * (n + 1) : n * ((n + 1) / 2);
        Object x$1 = null;
        Function2 & Serializable x$2 = (Function2 & Serializable)(maybeU, v) -> {
            breeze.linalg.DenseVector U = maybeU == null ? new DenseVector.mcD.sp(nt, (ClassTag)ClassTag$.MODULE$.Double()) : maybeU;
            int n = v.size();
            double[] na = (double[])Array$.MODULE$.ofDim(n, (ClassTag)ClassTag$.MODULE$.Double());
            Vector means = (Vector)bc.value();
            double[] ta = v.toArray();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), n).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
                na$1[index] = ta[index] - means.apply(index);
            });
            BLAS$.MODULE$.spr(1.0, (Vector)new DenseVector(na), U.data$mcD$sp());
            return U;
        };
        Function2 & Serializable x$3 = (Function2 & Serializable)(U1, U2) -> {
            if (U1 == null) {
                return U2;
            }
            if (U2 == null) {
                return U1;
            }
            return (breeze.linalg.DenseVector)U1.$plus$eq(U2, HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double());
        };
        int x$4 = this.rows().treeAggregate$default$4(x$1);
        breeze.linalg.DenseVector MU = (breeze.linalg.DenseVector)this.rows().treeAggregate(x$1, (Function2)x$2, (Function2)x$3, x$4, ClassTag$.MODULE$.apply(breeze.linalg.DenseVector.class));
        bc.destroy();
        breeze.linalg.Matrix<Object> M = RowMatrix$.MODULE$.org$apache$spark$mllib$linalg$distributed$RowMatrix$$triuToFull(n, MU.data$mcD$sp()).asBreeze();
        int j = 0;
        double m1 = (double)m - 1.0;
        for (int i = 0; i < n; ++i) {
            for (j = i; j < n; ++j) {
                double Mij = M.apply$mcD$sp(i, j) / m1;
                M.update$mcD$sp(i, j, Mij);
                M.update$mcD$sp(j, i, Mij);
            }
        }
        return Matrices$.MODULE$.fromBreeze(M);
    }

    private Matrix computeSparseVectorCovariance(Vector mean, int n, long m) {
        breeze.linalg.Matrix<Object> G = this.computeGramianMatrix().asBreeze();
        int j = 0;
        double m1 = (double)m - 1.0;
        double alpha = 0.0;
        for (int i = 0; i < n; ++i) {
            alpha = (double)m / m1 * mean.apply(i);
            for (j = i; j < n; ++j) {
                double Gij = G.apply$mcD$sp(i, j) / m1 - alpha * mean.apply(j);
                G.update$mcD$sp(i, j, Gij);
                G.update$mcD$sp(j, i, Gij);
            }
        }
        return Matrices$.MODULE$.fromBreeze(G);
    }

    private void checkNumColumns(int cols) {
        if (cols > 65535) {
            throw new IllegalArgumentException("Argument with more than 65535 cols: " + cols);
        }
        if (cols > 10000) {
            long memMB = (long)cols * (long)cols / 125000L;
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " columns will require at least "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_COLUMNS$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)cols))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " megabytes of memory!"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.MEMORY_SIZE$.MODULE$, (Object)BoxesRunTime.boxToLong((long)memMB))})))));
            return;
        }
    }

    public SingularValueDecomposition<RowMatrix, Matrix> computeSVD(int k, boolean computeU, double rCond) {
        int maxIter = package$.MODULE$.max(300, k * 3);
        double tol = 1.0E-10;
        return this.computeSVD(k, computeU, rCond, maxIter, tol, "auto");
    }

    public SingularValueDecomposition<RowMatrix, Matrix> computeSVD(int k, boolean computeU, double rCond, int maxIter, double tol, String mode) {
        breeze.linalg.DenseVector denseVector;
        breeze.linalg.DenseMatrix u;
        Enumeration.Value computeMode;
        int n;
        LazyRef SVDMode$module;
        block31: {
            Tuple2 tuple2;
            block30: {
                Tuple2 tuple22;
                block26: {
                    Enumeration.Value value;
                    block27: {
                        breeze.linalg.DenseMatrix denseMatrix;
                        breeze.linalg.DenseVector sigmaSquaresFull;
                        block29: {
                            svd.SVD sVD;
                            block28: {
                                block25: {
                                    Enumeration.Value value2;
                                    block24: {
                                        SVDMode$module = new LazyRef();
                                        n = (int)this.numCols();
                                        Predef$.MODULE$.require(k > 0 && k <= n, (Function0 & Serializable)() -> "Requested k singular values but got k=" + k + " and numCols=" + n + ".");
                                        String string = mode;
                                        switch (string == null ? 0 : string.hashCode()) {
                                            case -1206360833: {
                                                if (!"local-svd".equals(string)) break;
                                                value2 = this.SVDMode$2(SVDMode$module).LocalLAPACK();
                                                break block24;
                                            }
                                            case 3005871: {
                                                if (!"auto".equals(string)) break;
                                                if (k > 5000) {
                                                    this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"computing svd with k=", " and "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_LEADING_SINGULAR_VALUES$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)k))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"n=", ", please check necessity"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_COLUMNS$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)n))})))));
                                                }
                                                value2 = n < 100 || k > n / 2 && n <= 15000 ? (k < n / 3 ? this.SVDMode$2(SVDMode$module).LocalARPACK() : this.SVDMode$2(SVDMode$module).LocalLAPACK()) : this.SVDMode$2(SVDMode$module).DistARPACK();
                                                break block24;
                                            }
                                            case 304032855: {
                                                if (!"dist-eigs".equals(string)) break;
                                                value2 = this.SVDMode$2(SVDMode$module).DistARPACK();
                                                break block24;
                                            }
                                            case 1257090482: {
                                                if (!"local-eigs".equals(string)) break;
                                                value2 = this.SVDMode$2(SVDMode$module).LocalARPACK();
                                                break block24;
                                            }
                                        }
                                        throw new IllegalArgumentException("Do not support mode " + mode + ".");
                                    }
                                    value = computeMode = value2;
                                    Enumeration.Value value3 = this.SVDMode$2(SVDMode$module).LocalARPACK();
                                    Enumeration.Value value4 = value;
                                    if (value3 != null ? !value3.equals(value4) : value4 != null) break block25;
                                    Predef$.MODULE$.require(k < n, (Function0 & Serializable)() -> "k must be smaller than n in local-eigs mode but got k=" + k + " and n=" + n + ".");
                                    breeze.linalg.DenseMatrix G = (breeze.linalg.DenseMatrix)this.computeGramianMatrix().asBreeze();
                                    tuple22 = EigenValueDecomposition$.MODULE$.symmetricEigs((Function1<breeze.linalg.DenseVector<Object>, breeze.linalg.DenseVector<Object>>)(Function1 & Serializable)v -> (breeze.linalg.DenseVector)G.$times(v, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD()), n, k, tol, maxIter);
                                    break block26;
                                }
                                Enumeration.Value value5 = this.SVDMode$2(SVDMode$module).LocalLAPACK();
                                Enumeration.Value value6 = value;
                                if (value5 != null ? !value5.equals(value6) : value6 != null) break block27;
                                Predef$.MODULE$.require(n < 17515, (Function0 & Serializable)() -> n + " exceeds the breeze svd capability");
                                breeze.linalg.DenseMatrix G = (breeze.linalg.DenseMatrix)this.computeGramianMatrix().asBreeze();
                                sVD = (svd.SVD)svd$.MODULE$.apply((Object)G, (UFunc.UImpl)svd.Svd_DM_Impl$.MODULE$);
                                if (sVD == null) break block28;
                                breeze.linalg.DenseMatrix uFull = (breeze.linalg.DenseMatrix)sVD.leftVectors();
                                sigmaSquaresFull = (breeze.linalg.DenseVector)sVD.singularValues();
                                if (uFull == null) break block28;
                                denseMatrix = uFull;
                                if (sigmaSquaresFull != null) break block29;
                            }
                            throw new MatchError((Object)sVD);
                        }
                        breeze.linalg.DenseVector denseVector2 = sigmaSquaresFull;
                        Tuple2 tuple23 = new Tuple2((Object)denseMatrix, (Object)denseVector2);
                        breeze.linalg.DenseMatrix uFull = (breeze.linalg.DenseMatrix)tuple23._1();
                        breeze.linalg.DenseVector sigmaSquaresFull2 = (breeze.linalg.DenseVector)tuple23._2();
                        tuple22 = new Tuple2((Object)sigmaSquaresFull2, (Object)uFull);
                        break block26;
                    }
                    Enumeration.Value value7 = this.SVDMode$2(SVDMode$module).DistARPACK();
                    Enumeration.Value value8 = value;
                    if (!(value7 != null ? !value7.equals(value8) : value8 != null)) {
                        StorageLevel storageLevel = this.rows().getStorageLevel();
                        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
                        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
                            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "The input data is not directly cached, which may hurt performance if its parent RDDs are also uncached.");
                        }
                        Predef$.MODULE$.require(k < n, (Function0 & Serializable)() -> "k must be smaller than n in dist-eigs mode but got k=" + k + " and n=" + n + ".");
                        tuple22 = EigenValueDecomposition$.MODULE$.symmetricEigs((Function1<breeze.linalg.DenseVector<Object>, breeze.linalg.DenseVector<Object>>)(Function1 & Serializable)v -> this.multiplyGramianMatrixBy((breeze.linalg.DenseVector<Object>)v), n, k, tol, maxIter);
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
                tuple2 = tuple22;
                if (tuple2 == null) break block30;
                breeze.linalg.DenseVector sigmaSquares = (breeze.linalg.DenseVector)tuple2._1();
                u = (breeze.linalg.DenseMatrix)tuple2._2();
                if (sigmaSquares == null) break block30;
                denseVector = sigmaSquares;
                if (u != null) break block31;
            }
            throw new MatchError(tuple2);
        }
        breeze.linalg.DenseMatrix denseMatrix = u;
        Tuple2 tuple2 = new Tuple2((Object)denseVector, (Object)denseMatrix);
        breeze.linalg.DenseVector sigmaSquares = (breeze.linalg.DenseVector)tuple2._1();
        breeze.linalg.DenseMatrix u2 = (breeze.linalg.DenseMatrix)tuple2._2();
        breeze.linalg.DenseVector sigmas = (breeze.linalg.DenseVector)package.sqrt$.MODULE$.apply((Object)sigmaSquares, HasOps$.MODULE$.fromLowOrderCanMapActiveValues(breeze.linalg.DenseVector$.MODULE$.DV_scalarOf(), (UFunc.UImpl)package.sqrt$.sqrtDoubleImpl$.MODULE$, breeze.linalg.DenseVector$.MODULE$.DV_canMapValues$mDDc$sp((ClassTag)ClassTag$.MODULE$.Double())));
        double sigma0 = sigmas.apply$mcD$sp(0);
        double threshold = rCond * sigma0;
        int i = 0;
        if (sigmas.length() < k) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Requested ", " singular "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_LEADING_SINGULAR_VALUES$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)k))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"values but only found ", " converged."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SIGMAS_LENGTH$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)sigmas.length()))})))));
        }
        while (i < package$.MODULE$.min(k, sigmas.length()) && sigmas.apply$mcD$sp(i) >= threshold) {
            ++i;
        }
        int sk = i;
        if (sk < k) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Requested ", " singular "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_LEADING_SINGULAR_VALUES$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)k))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"values but only found ", " nonzeros."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.COUNT$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)sk))})))));
        }
        Enumeration.Value value = computeMode;
        Enumeration.Value value9 = this.SVDMode$2(SVDMode$module).DistARPACK();
        if (!(value != null ? !value.equals(value9) : value9 != null)) {
            StorageLevel storageLevel = this.rows().getStorageLevel();
            StorageLevel storageLevel3 = StorageLevel$.MODULE$.NONE();
            if (!(storageLevel != null ? !storageLevel.equals(storageLevel3) : storageLevel3 != null)) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "The input data was not directly cached, which may hurt performance if its parent RDDs are also uncached.");
            }
        }
        Vector s = Vectors$.MODULE$.dense(Arrays.copyOfRange(sigmas.data$mcD$sp(), 0, sk));
        Matrix V = Matrices$.MODULE$.dense(n, sk, Arrays.copyOfRange(u2.data$mcD$sp(), 0, n * sk));
        if (computeU) {
            DenseMatrix.mcD.sp N = new DenseMatrix.mcD.sp(n, sk, Arrays.copyOfRange(u2.data$mcD$sp(), 0, n * sk));
            int i2 = 0;
            for (int j = 0; j < sk; ++j) {
                i2 = 0;
                double sigma = sigmas.apply$mcD$sp(j);
                while (i2 < n) {
                    int n2 = i2++;
                    int n3 = j;
                    N.update$mcD$sp(n2, n3, N.apply$mcD$sp(n2, n3) / sigma);
                }
            }
            RowMatrix U = this.multiply(Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)N));
            return new SingularValueDecomposition<RowMatrix, Matrix>(U, s, V);
        }
        return new SingularValueDecomposition<Object, Matrix>(null, s, V);
    }

    public boolean computeSVD$default$2() {
        return false;
    }

    public double computeSVD$default$3() {
        return 1.0E-9;
    }

    private boolean isSparseMatrix() {
        return this.rows().filter((Function1 & Serializable)row -> BoxesRunTime.boxToBoolean((boolean)RowMatrix.$anonfun$isSparseMatrix$1(row))).isEmpty();
    }

    public Matrix computeCovariance() {
        int n = (int)this.numCols();
        this.checkNumColumns(n);
        SummarizerBuffer summary = Statistics$.MODULE$.colStats((RDD<Tuple2<Vector, Object>>)this.rows().map((Function1 & Serializable)x$3 -> new Tuple2(x$3, (Object)BoxesRunTime.boxToDouble((double)1.0)), ClassTag$.MODULE$.apply(Tuple2.class)), (Seq<String>)new .colon.colon((Object)"count", (List)new .colon.colon((Object)"mean", (List)Nil$.MODULE$)));
        long m = summary.count();
        Predef$.MODULE$.require(m > 1L, (Function0 & Serializable)() -> "RowMatrix.computeCovariance called on matrix with only " + m + " rows.  Cannot compute the covariance of a RowMatrix with <= 1 row.");
        Vector mean = Vectors$.MODULE$.fromML(summary.mean());
        if (!this.isSparseMatrix()) {
            return this.computeDenseVectorCovariance(mean, n, m);
        }
        return this.computeSparseVectorCovariance(mean, n, m);
    }

    public Tuple2<Matrix, Vector> computePrincipalComponentsAndExplainedVariance(int k) {
        breeze.linalg.DenseMatrix denseMatrix;
        breeze.linalg.DenseVector s;
        int n;
        block6: {
            svd.SVD sVD;
            block5: {
                n = (int)this.numCols();
                Predef$.MODULE$.require(k > 0 && k <= n, (Function0 & Serializable)() -> "k = " + k + " out of range (0, n = " + n + "]");
                if (n > 65535) {
                    SingularValueDecomposition<RowMatrix, Matrix> svd2 = this.computeSVD(k, this.computeSVD$default$2(), this.computeSVD$default$3());
                    double[] s2 = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(svd2.s().toArray()), (Function1)(JFunction1.mcDD.sp & Serializable)eigValue -> eigValue * eigValue / (double)(n - 1), (ClassTag)ClassTag$.MODULE$.Double());
                    double eigenSum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(s2).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                    double[] explainedVariance = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(s2), (Function1)(JFunction1.mcDD.sp & Serializable)x$4 -> x$4 / eigenSum, (ClassTag)ClassTag$.MODULE$.Double());
                    return new Tuple2((Object)svd2.V(), (Object)Vectors$.MODULE$.dense(explainedVariance));
                }
                breeze.linalg.DenseMatrix Cov = (breeze.linalg.DenseMatrix)this.computeCovariance().asBreeze();
                sVD = (svd.SVD)svd$.MODULE$.apply((Object)Cov, (UFunc.UImpl)svd.Svd_DM_Impl$.MODULE$);
                if (sVD == null) break block5;
                breeze.linalg.DenseMatrix u = (breeze.linalg.DenseMatrix)sVD.leftVectors();
                s = (breeze.linalg.DenseVector)sVD.singularValues();
                if (u == null) break block5;
                denseMatrix = u;
                if (s != null) break block6;
            }
            throw new MatchError((Object)sVD);
        }
        breeze.linalg.DenseVector denseVector = s;
        Tuple2 tuple2 = new Tuple2((Object)denseMatrix, (Object)denseVector);
        breeze.linalg.DenseMatrix u = (breeze.linalg.DenseMatrix)tuple2._1();
        breeze.linalg.DenseVector s3 = (breeze.linalg.DenseVector)tuple2._2();
        double eigenSum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(s3.data$mcD$sp()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        double[] explainedVariance = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(s3.data$mcD$sp()), (Function1)(JFunction1.mcDD.sp & Serializable)x$6 -> x$6 / eigenSum, (ClassTag)ClassTag$.MODULE$.Double());
        if (k == n) {
            return new Tuple2((Object)Matrices$.MODULE$.dense(n, k, u.data$mcD$sp()), (Object)Vectors$.MODULE$.dense(explainedVariance));
        }
        return new Tuple2((Object)Matrices$.MODULE$.dense(n, k, Arrays.copyOfRange(u.data$mcD$sp(), 0, n * k)), (Object)Vectors$.MODULE$.dense(Arrays.copyOfRange(explainedVariance, 0, k)));
    }

    public Matrix computePrincipalComponents(int k) {
        return (Matrix)this.computePrincipalComponentsAndExplainedVariance(k)._1();
    }

    public MultivariateStatisticalSummary computeColumnSummaryStatistics() {
        MultivariateOnlineSummarizer x$1 = new MultivariateOnlineSummarizer();
        Function2 & Serializable x$2 = (Function2 & Serializable)(aggregator, data) -> aggregator.add((Vector)data);
        Function2 & Serializable x$3 = (Function2 & Serializable)(aggregator1, aggregator2) -> aggregator1.merge((MultivariateOnlineSummarizer)aggregator2);
        int x$4 = this.rows().treeAggregate$default$4((Object)x$1);
        MultivariateOnlineSummarizer summary = (MultivariateOnlineSummarizer)this.rows().treeAggregate((Object)x$1, (Function2)x$2, (Function2)x$3, x$4, ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
        this.updateNumRows(summary.count());
        return summary;
    }

    public RowMatrix multiply(Matrix B) {
        int n = (int)this.numCols();
        int k = B.numCols();
        Predef$.MODULE$.require(n == B.numRows(), (Function0 & Serializable)() -> "Dimension mismatch: " + n + " vs " + B.numRows());
        Predef$.MODULE$.require(B instanceof DenseMatrix, (Function0 & Serializable)() -> "Only support dense matrix at this time but found " + B.getClass().getName() + ".");
        Broadcast Bb = this.rows().context().broadcast((Object)((breeze.linalg.DenseMatrix)B.asBreeze()).toDenseVector$mcD$sp().toArray$mcD$sp((ClassTag)ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        RDD AB = this.rows().mapPartitions((Function1 & Serializable)iter -> {
            double[] Bi = (double[])Bb.value();
            return iter.map((Function1 & Serializable)row -> {
                breeze.linalg.DenseVector v = breeze.linalg.DenseVector$.MODULE$.zeros$mDc$sp(k, (ClassTag)ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero());
                for (int i = 0; i < k; ++i) {
                    v.update$mcD$sp(i, BoxesRunTime.unboxToDouble((Object)row.asBreeze().dot((Object)new DenseVector.mcD.sp(Bi, i * n, 1, n), HasOps$.MODULE$.castOps_V_V((.less.colon.less)$less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl(), NotGiven$.MODULE$.neq(), (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulInner_V_V_eq_S_Double()))));
                }
                return Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)v);
            });
        }, this.rows().mapPartitions$default$2(), ClassTag$.MODULE$.apply(Vector.class));
        return new RowMatrix((RDD<Vector>)AB, this.nRows(), B.numCols());
    }

    public CoordinateMatrix columnSimilarities() {
        return this.columnSimilarities(0.0);
    }

    public CoordinateMatrix columnSimilarities(double threshold) {
        Predef$.MODULE$.require(threshold >= 0.0, (Function0 & Serializable)() -> "Threshold cannot be negative: " + threshold);
        if (threshold > 1.0) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Threshold is greater than 1: ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.THRESHOLD$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)threshold))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Computation will be more efficient with promoted sparsity, "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"however there is no correctness guarantee."}))).log((Seq)Nil$.MODULE$))));
        }
        double gamma = threshold < 1.0E-6 ? Double.POSITIVE_INFINITY : (double)10 * package$.MODULE$.log((double)this.numCols()) / threshold;
        SummarizerBuffer summary = Statistics$.MODULE$.colStats((RDD<Tuple2<Vector, Object>>)this.rows().map((Function1 & Serializable)x$7 -> new Tuple2(x$7, (Object)BoxesRunTime.boxToDouble((double)1.0)), ClassTag$.MODULE$.apply(Tuple2.class)), (Seq<String>)new .colon.colon((Object)"normL2", (List)Nil$.MODULE$));
        return this.columnSimilaritiesDIMSUM(summary.normL2().toArray(), gamma);
    }

    public QRDecomposition<RowMatrix, Matrix> tallSkinnyQR(boolean computeQ) {
        RowMatrix rowMatrix;
        int col = (int)this.numCols();
        RDD blockQRs = this.rows().retag(Vector.class).glom().filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)RowMatrix.$anonfun$tallSkinnyQR$1(x$8))).map((Function1 & Serializable)partRows -> {
            breeze.linalg.DenseMatrix bdm = DenseMatrix$.MODULE$.zeros$mDc$sp(((Vector[])partRows).length, col, (ClassTag)ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero());
            IntRef i = IntRef.create((int)0);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])partRows), (Function1 & Serializable)row -> {
                RowMatrix.$anonfun$tallSkinnyQR$3(bdm, i, row);
                return BoxedUnit.UNIT;
            });
            return (breeze.linalg.DenseMatrix)((qr.QR)qr.reduced$.MODULE$.apply((Object)bdm, (UFunc.UImpl)qr.reduced$.impl_reduced_DM_Double$.MODULE$)).r();
        }, ClassTag$.MODULE$.apply(breeze.linalg.DenseMatrix.class));
        breeze.linalg.DenseMatrix combinedR = (breeze.linalg.DenseMatrix)blockQRs.treeReduce((Function2 & Serializable)(r1, r2) -> {
            breeze.linalg.DenseMatrix stackedR = DenseMatrix$.MODULE$.vertcat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new breeze.linalg.DenseMatrix[]{r1, r2}), HasOps$.MODULE$.dm_dm_UpdateOp_Double_OpSet(), (ClassTag)ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero());
            return (breeze.linalg.DenseMatrix)((qr.QR)qr.reduced$.MODULE$.apply((Object)stackedR, (UFunc.UImpl)qr.reduced$.impl_reduced_DM_Double$.MODULE$)).r();
        }, blockQRs.treeReduce$default$2());
        Matrix finalR = Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)combinedR.toDenseMatrix$mcD$sp((ClassTag)ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero()));
        if (computeQ) {
            try {
                breeze.linalg.DenseMatrix invR = (breeze.linalg.DenseMatrix)inv$.MODULE$.apply((Object)combinedR, inv$.MODULE$.canInvUsingLU_Double((UFunc.UImpl)LU.primitive$.LU_DM_Impl_Double$.MODULE$));
                rowMatrix = this.multiply(Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)invR));
            }
            catch (MatrixSingularException err) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "R is not invertible and return Q as null");
                rowMatrix = null;
            }
        } else {
            rowMatrix = null;
        }
        RowMatrix finalQ = rowMatrix;
        return new QRDecomposition<Object, Matrix>(finalQ, finalR);
    }

    public boolean tallSkinnyQR$default$1() {
        return false;
    }

    public CoordinateMatrix columnSimilaritiesDIMSUM(double[] colMags, double gamma) {
        Predef$.MODULE$.require(gamma > 1.0, (Function0 & Serializable)() -> "Oversampling should be greater than 1: " + gamma);
        Predef$.MODULE$.require((long)colMags.length == this.numCols(), (Function0 & Serializable)() -> "Number of magnitudes didn't match column dimension");
        double sg = package$.MODULE$.sqrt(gamma);
        double[] colMagsCorrected = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(colMags), (Function1)(JFunction1.mcDD.sp & Serializable)x -> {
            if (x == 0.0) {
                return 1.0;
            }
            return x;
        }, (ClassTag)ClassTag$.MODULE$.Double());
        SparkContext sc = this.rows().context();
        Broadcast pBV = sc.broadcast(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(colMagsCorrected), (Function1)(JFunction1.mcDD.sp & Serializable)c -> sg / c, (ClassTag)ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast qBV = sc.broadcast(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(colMagsCorrected), (Function1)(JFunction1.mcDD.sp & Serializable)c -> package$.MODULE$.min(sg, c), (ClassTag)ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        RDD sims = RDD$.MODULE$.rddToPairRDDFunctions(this.rows().mapPartitionsWithIndex((Function2 & Serializable)(index, iter) -> RowMatrix.$anonfun$columnSimilaritiesDIMSUM$6(pBV, qBV, BoxesRunTime.unboxToInt((Object)index), iter), this.rows().mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), (ClassTag)ClassTag$.MODULE$.Double(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).reduceByKey((Function2)(JFunction2.mcDDD.sp & Serializable)(x$9, x$10) -> x$9 + x$10).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                double sim = tuple2._2$mcD$sp();
                if (tuple22 != null) {
                    int i = tuple22._1$mcI$sp();
                    int j = tuple22._2$mcI$sp();
                    return new MatrixEntry(i, j, sim);
                }
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(MatrixEntry.class));
        return new CoordinateMatrix((RDD<MatrixEntry>)sims, this.numCols(), this.numCols());
    }

    @Override
    public breeze.linalg.DenseMatrix<Object> toBreeze() {
        int m = (int)this.numRows();
        int n = (int)this.numCols();
        breeze.linalg.DenseMatrix mat = DenseMatrix$.MODULE$.zeros$mDc$sp(m, n, (ClassTag)ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero());
        IntRef i = IntRef.create((int)0);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.rows().collect()), (Function1 & Serializable)vector -> {
            RowMatrix.$anonfun$toBreeze$1(mat, i, vector);
            return BoxedUnit.UNIT;
        });
        return mat;
    }

    private void updateNumRows(long m) {
        if (this.nRows() <= 0L) {
            this.nRows_$eq(m);
            return;
        }
        Predef$.MODULE$.require(this.nRows() == m, (Function0 & Serializable)() -> "The number of rows " + m + " is different from what specified or previously computed: " + this.nRows() + ".");
    }

    public int getTreeAggregateIdealDepth(long aggregatedObjectSizeInBytes) {
        double desiredTreeDepth;
        block1: {
            Predef$.MODULE$.require(aggregatedObjectSizeInBytes > 0L, (Function0 & Serializable)() -> "Cannot compute aggregate depth heuristic based on a zero-size object to aggregate");
            long maxDriverResultSizeInBytes = BoxesRunTime.unboxToLong((Object)this.rows().conf().get(org.apache.spark.internal.config.package$.MODULE$.MAX_RESULT_SIZE()));
            if (maxDriverResultSizeInBytes <= 0L) {
                return 1;
            }
            Predef$.MODULE$.require(maxDriverResultSizeInBytes > aggregatedObjectSizeInBytes, (Function0 & Serializable)() -> "Cannot aggregate object of size " + aggregatedObjectSizeInBytes + " Bytes, as it's bigger than maxResultSize (" + maxDriverResultSizeInBytes + " Bytes)");
            double numerator = package$.MODULE$.log((double)this.rows().getNumPartitions());
            double denominator = package$.MODULE$.log((double)maxDriverResultSizeInBytes) - package$.MODULE$.log((double)aggregatedObjectSizeInBytes);
            desiredTreeDepth = package$.MODULE$.ceil(numerator / denominator);
            if (!(desiredTreeDepth > (double)4)) break block1;
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Desired tree depth for treeAggregation is big "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(", "). "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DESIRED_TREE_DEPTH$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)desiredTreeDepth))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Consider increasing driver max result size or reducing number of partitions"}))).log((Seq)Nil$.MODULE$))));
        }
        return (int)package$.MODULE$.min(package$.MODULE$.max(1.0, desiredTreeDepth), 10.0);
    }

    private static final /* synthetic */ RowMatrix$SVDMode$1$ SVDMode$lzycompute$1(LazyRef SVDMode$module$1) {
        RowMatrix$SVDMode$1$ rowMatrix$SVDMode$1$;
        LazyRef lazyRef = SVDMode$module$1;
        synchronized (lazyRef) {
            rowMatrix$SVDMode$1$ = SVDMode$module$1.initialized() ? (RowMatrix$SVDMode$1$)((Object)SVDMode$module$1.value()) : (RowMatrix$SVDMode$1$)((Object)SVDMode$module$1.initialize((Object)new RowMatrix$SVDMode$1$(null)));
        }
        return rowMatrix$SVDMode$1$;
    }

    private final RowMatrix$SVDMode$1$ SVDMode$2(LazyRef SVDMode$module$1) {
        if (SVDMode$module$1.initialized()) {
            return (RowMatrix$SVDMode$1$)((Object)SVDMode$module$1.value());
        }
        return RowMatrix.SVDMode$lzycompute$1(SVDMode$module$1);
    }

    public static final /* synthetic */ boolean $anonfun$isSparseMatrix$1(Vector row) {
        return row.sparsity() < 0.5;
    }

    public static final /* synthetic */ boolean $anonfun$tallSkinnyQR$1(Vector[] x$8) {
        return x$8.length != 0;
    }

    public static final /* synthetic */ void $anonfun$tallSkinnyQR$3(breeze.linalg.DenseMatrix bdm$1, IntRef i$1, Vector row) {
        ((NumericOps)bdm$1.apply((Object)BoxesRunTime.boxToInteger((int)i$1.elem), (Object)scala.package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRow())).$colon$eq(row.asBreeze().t(HasOps$.MODULE$.transposeTensor((.less.colon.less)$less$colon$less$.MODULE$.refl())), HasOps$.MODULE$.liftInPlaceOps(NotGiven$.MODULE$.neq(), HasOps$.MODULE$.canUntranspose(), (UFunc.InPlaceImpl2)HasOps$.MODULE$.impl_Op_InPlace_DV_V_Double_OpSet()));
        ++i$1.elem;
    }

    public static final /* synthetic */ ListBuffer $anonfun$columnSimilaritiesDIMSUM$8(int[] indices$1, double[] scaled$1, XORShiftRandom rand$1, double[] p$1, int nnz$1, int k) {
        ListBuffer buf = new ListBuffer();
        int i = indices$1[k];
        double iVal = scaled$1[k];
        if (iVal != 0.0 && rand$1.nextDouble() < p$1[i]) {
            for (int l = k + 1; l < nnz$1; ++l) {
                int j = indices$1[l];
                double jVal = scaled$1[l];
                Object object = jVal != 0.0 && rand$1.nextDouble() < p$1[j] ? buf.$plus$eq((Object)new Tuple2((Object)new Tuple2.mcII.sp(i, j), (Object)BoxesRunTime.boxToDouble((double)(iVal * jVal)))) : BoxedUnit.UNIT;
            }
        }
        return buf;
    }

    public static final /* synthetic */ ListBuffer $anonfun$columnSimilaritiesDIMSUM$9(double[] scaled$1, XORShiftRandom rand$1, double[] p$1, int n$5, int i) {
        ListBuffer buf = new ListBuffer();
        double iVal = scaled$1[i];
        if (iVal != 0.0 && rand$1.nextDouble() < p$1[i]) {
            for (int j = i + 1; j < n$5; ++j) {
                double jVal = scaled$1[j];
                Object object = jVal != 0.0 && rand$1.nextDouble() < p$1[j] ? buf.$plus$eq((Object)new Tuple2((Object)new Tuple2.mcII.sp(i, j), (Object)BoxesRunTime.boxToDouble((double)(iVal * jVal)))) : BoxedUnit.UNIT;
            }
        }
        return buf;
    }

    public static final /* synthetic */ Iterator $anonfun$columnSimilaritiesDIMSUM$6(Broadcast pBV$1, Broadcast qBV$1, int index, Iterator iter) {
        double[] p = (double[])pBV$1.value();
        double[] q = (double[])qBV$1.value();
        XORShiftRandom rand = new XORShiftRandom((long)index);
        double[] scaled = new double[p.length];
        return iter.flatMap((Function1 & Serializable)row -> {
            DenseVector denseVector;
            Option<double[]> option;
            SparseVector sparseVector;
            Option<Tuple3<Object, int[], double[]>> option2;
            Vector vector = row;
            if (vector instanceof SparseVector && !(option2 = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector)).isEmpty()) {
                int[] indices = (int[])((Tuple3)option2.get())._2();
                double[] values = (double[])((Tuple3)option2.get())._3();
                int nnz = indices.length;
                for (int k2 = 0; k2 < nnz; ++k2) {
                    scaled$1[k2] = values[k2] / q[indices[k2]];
                }
                return scala.package$.MODULE$.Iterator().tabulate(nnz, (Function1 & Serializable)k -> RowMatrix.$anonfun$columnSimilaritiesDIMSUM$8(indices, scaled, rand, p, nnz, BoxesRunTime.unboxToInt((Object)k))).flatten(Predef$.MODULE$.$conforms());
            }
            if (vector instanceof DenseVector && !(option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector)).isEmpty()) {
                double[] values = (double[])option.get();
                int n = values.length;
                for (int i2 = 0; i2 < n; ++i2) {
                    scaled$1[i2] = values[i2] / q[i2];
                }
                return scala.package$.MODULE$.Iterator().tabulate(n, (Function1 & Serializable)i -> RowMatrix.$anonfun$columnSimilaritiesDIMSUM$9(scaled, rand, p, n, BoxesRunTime.unboxToInt((Object)i))).flatten(Predef$.MODULE$.$conforms());
            }
            throw new IllegalArgumentException("Unknown vector type " + vector.getClass() + ".");
        });
    }

    public static final /* synthetic */ void $anonfun$toBreeze$1(breeze.linalg.DenseMatrix mat$1, IntRef i$2, Vector vector) {
        vector.foreachNonZero((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable)(x0$1, x1$1) -> {
            Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(x0$1, x1$1);
            if (sp2 != null) {
                int j = sp2._1$mcI$sp();
                double v = sp2._2$mcD$sp();
                mat$1.update$mcD$sp(i$2.elem, j, v);
                return;
            }
            throw new MatchError((Object)sp2);
        });
        ++i$2.elem;
    }

    public RowMatrix(RDD<Vector> rows, long nRows, int nCols) {
        this.rows = rows;
        this.nRows = nRows;
        this.nCols = nCols;
        Logging.$init$((Logging)this);
    }

    public RowMatrix(RDD<Vector> rows) {
        this(rows, 0L, 0);
    }
}

