/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Locale;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Literal;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcSQLQueryBuilder;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.NoLegacyJDBCError;
import org.apache.spark.sql.jdbc.OracleDialect$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\rUc\u0001B!C\t6CQ!\u001c\u0001\u0005\u00029DQ\u0001\u001d\u0001\u0005BED\u0001b \u0001C\u0002\u0013%\u0011\u0011\u0001\u0005\t\u0003C\u0001\u0001\u0015!\u0003\u0002\u0004!I\u00111\u0005\u0001C\u0002\u0013%\u0011\u0011\u0001\u0005\t\u0003K\u0001\u0001\u0015!\u0003\u0002\u0004!I\u0011q\u0005\u0001C\u0002\u0013%\u0011\u0011\u0001\u0005\t\u0003S\u0001\u0001\u0015!\u0003\u0002\u0004!9\u00111\u0006\u0001\u0005B\u00055bABA\u001a\u0001\u0001\t)\u0004\u0003\u0004n\u0015\u0011\u0005\u0011q\b\u0005\b\u0003\u0007RA\u0011IA#\u0011\u001d\t9F\u0003C!\u00033Bq!a\u001e\u000b\t\u0013\tI\bC\u0004\u0002\b\u0002!\t%!#\t\u000f\u0005U\u0005\u0001\"\u0011\u0002\u0018\"9\u00111\u0019\u0001\u0005B\u0005\u0015\u0007bBAj\u0001\u0011\u0005\u0013Q\u001b\u0005\b\u0003C\u0004A\u0011IAr\u0011\u001d\t9\u000f\u0001C!\u0003SD\u0011\"a=\u0001#\u0003%\t!!>\t\u000f\t-\u0001\u0001\"\u0011\u0003\u000e!9!1\u0004\u0001\u0005B\tu\u0001b\u0002B\u0014\u0001\u0011\u0005#\u0011\u0006\u0005\b\u0005g\u0001A\u0011\tB\u001b\u0011\u001d\u0011\t\u0005\u0001C!\u0005\u00072aA!\u0013\u0001\u0001\t-\u0003\"\u0003B*7\t\u0005\t\u0015!\u0003O\u0011)\u0011)f\u0007B\u0001B\u0003%!q\u000b\u0005\u0007[n!\tA!\u001b\t\u000f\tE4\u0004\"\u0011\u0003t!9!Q\u000f\u0001\u0005B\t]\u0004b\u0002B>\u0001\u0011\u0005#Q\u0010\u0005\b\u0005\u007f\u0002A\u0011\tB?\u0011\u001d\u0011\t\t\u0001C!\u0005{BqAa!\u0001\t\u0003\u0012)\t\u0003\u0005\u00036\u0002\t\t\u0011\"\u0001o\u0011%\u00119\fAA\u0001\n\u0003\u0012I\fC\u0005\u0003<\u0002\t\t\u0011\"\u0001\u0003>\"I!q\u0018\u0001\u0002\u0002\u0013\u0005!\u0011\u0019\u0005\n\u0005\u000f\u0004\u0011\u0011!C!\u0005\u0013D\u0011Ba5\u0001\u0003\u0003%\tA!6\t\u0013\te\u0007!!A\u0005B\tm\u0007\"\u0003Bp\u0001\u0005\u0005I\u0011\tBq\u0011%\u0011\u0019\u000fAA\u0001\n\u0003\u0012)\u000fC\u0005\u0003h\u0002\t\t\u0011\"\u0011\u0003j\u001eA!Q\u001e\"\t\u0002\t\u0013yOB\u0004B\u0005\"\u0005!I!=\t\r5\u0004D\u0011AB\u0002\u0011%\u0019)\u0001\rb\u0001\n\u000b\u00199\u0001\u0003\u0005\u0004\u000eA\u0002\u000bQBB\u0005\u0011%\u0019y\u0001\rb\u0001\n\u000b\u0019\t\u0002\u0003\u0005\u0004\u0018A\u0002\u000bQBB\n\u0011%\u0019I\u0002\rb\u0001\n\u000b\u0019Y\u0002\u0003\u0005\u0004\"A\u0002\u000bQBB\u000f\u0011%\u0019\u0019\u0003\rb\u0001\n\u000b\u0019)\u0003\u0003\u0005\u0004,A\u0002\u000bQBB\u0014\u0011%\u0019i\u0003\rb\u0001\n\u000b\u0019y\u0003\u0003\u0005\u00046A\u0002\u000bQBB\u0019\u0011%\u00199\u0004\rb\u0001\n\u000b\u0019I\u0004\u0003\u0005\u0004@A\u0002\u000bQBB\u001e\u0011!\u0019\t\u0005MA\u0001\n\u0003s\u0007\"CB\"a\u0005\u0005I\u0011QB#\u0011%\u0019Y\u0005MA\u0001\n\u0013\u0019iEA\u0007Pe\u0006\u001cG.\u001a#jC2,7\r\u001e\u0006\u0003\u0007\u0012\u000bAA\u001b3cG*\u0011QIR\u0001\u0004gFd'BA$I\u0003\u0015\u0019\b/\u0019:l\u0015\tI%*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0006\u0019qN]4\u0004\u0001M1\u0001A\u0014*Y7\u0006\u0004\"a\u0014)\u000e\u0003\tK!!\u0015\"\u0003\u0017)#'m\u0019#jC2,7\r\u001e\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+\u0012\u000b\u0001bY1uC2L8\u000f^\u0005\u0003/R\u0013QbU)M\u0007>tg\rS3ma\u0016\u0014\bCA(Z\u0013\tQ&IA\tO_2+w-Y2z\u0015\u0012\u00135)\u0012:s_J\u0004\"\u0001X0\u000e\u0003uS\u0011AX\u0001\u0006g\u000e\fG.Y\u0005\u0003Av\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002cU:\u00111\r\u001b\b\u0003I\u001el\u0011!\u001a\u0006\u0003M2\u000ba\u0001\u0010:p_Rt\u0014\"\u00010\n\u0005%l\u0016a\u00029bG.\fw-Z\u0005\u0003W2\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!![/\u0002\rqJg.\u001b;?)\u0005y\u0007CA(\u0001\u0003%\u0019\u0017M\u001c%b]\u0012dW\r\u0006\u0002skB\u0011Al]\u0005\u0003iv\u0013qAQ8pY\u0016\fg\u000eC\u0003w\u0005\u0001\u0007q/A\u0002ve2\u0004\"\u0001\u001f?\u000f\u0005eT\bC\u00013^\u0013\tYX,\u0001\u0004Qe\u0016$WMZ\u0005\u0003{z\u0014aa\u0015;sS:<'BA>^\u0003\u0015\"\u0017n\u001d;j]\u000e$XK\\:vaB|'\u000f^3e\u0003\u001e<'/Z4bi\u00164UO\\2uS>t7/\u0006\u0002\u0002\u0004A1\u0011QAA\b\u0003'i!!a\u0002\u000b\t\u0005%\u00111B\u0001\nS6lW\u000f^1cY\u0016T1!!\u0004^\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003#\t9AA\u0002TKR\u0004B!!\u0006\u0002 5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"\u0001\u0003mC:<'BAA\u000f\u0003\u0011Q\u0017M^1\n\u0007u\f9\"\u0001\u0014eSN$\u0018N\\2u+:\u001cX\u000f\u001d9peR,G-Q4he\u0016<\u0017\r^3Gk:\u001cG/[8og\u0002\n1d];qa>\u0014H/\u001a3BO\u001e\u0014XmZ1uK\u001a+hn\u0019;j_:\u001c\u0018\u0001H:vaB|'\u000f^3e\u0003\u001e<'/Z4bi\u00164UO\\2uS>t7\u000fI\u0001\u0013gV\u0004\bo\u001c:uK\u00124UO\\2uS>t7/A\ntkB\u0004xN\u001d;fI\u001a+hn\u0019;j_:\u001c\b%A\njgN+\b\u000f]8si\u0016$g)\u001e8di&|g\u000eF\u0002s\u0003_Aa!!\r\n\u0001\u00049\u0018\u0001\u00034v]\u000et\u0015-\\3\u0003!=\u0013\u0018m\u00197f'Fc%)^5mI\u0016\u00148c\u0001\u0006\u00028A!\u0011\u0011HA\u001e\u001b\u0005\u0001\u0011bAA\u001f!\nq!\n\u0012\"D'Fc%)^5mI\u0016\u0014HCAA!!\r\tIDC\u0001\u0017m&\u001c\u0018\u000e^!hOJ,w-\u0019;f\rVt7\r^5p]R9q/a\u0012\u0002J\u00055\u0003BBA\u0019\u0019\u0001\u0007q\u000f\u0003\u0004\u0002L1\u0001\rA]\u0001\u000bSN$\u0015n\u001d;j]\u000e$\bbBA(\u0019\u0001\u0007\u0011\u0011K\u0001\u0007S:\u0004X\u000f^:\u0011\tq\u000b\u0019f^\u0005\u0004\u0003+j&!B!se\u0006L\u0018!\u0006<jg&$()\u001b8bef\u001cu.\u001c9be&\u001cxN\u001c\u000b\bo\u0006m\u0013qLA:\u0011\u0019\ti&\u0004a\u0001o\u0006!a.Y7f\u0011\u001d\t\t'\u0004a\u0001\u0003G\n!\u0001\\3\u0011\t\u0005\u0015\u0014qN\u0007\u0003\u0003ORA!!\u001b\u0002l\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\r\ti\u0007R\u0001\nG>tg.Z2u_JLA!!\u001d\u0002h\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u000f\u0005UT\u00021\u0001\u0002d\u0005\u0011!/Z\u0001\fG>l\u0007/\u0019:f\u00052|'\rF\u0004x\u0003w\ny(a!\t\u000f\u0005ud\u00021\u0001\u0002d\u0005\u0019A\u000e[:\t\r\u0005\u0005e\u00021\u0001x\u0003!y\u0007/\u001a:bi>\u0014\bbBAC\u001d\u0001\u0007\u00111M\u0001\u0004e\"\u001c\u0018!E2p[BLG.Z#yaJ,7o]5p]R!\u00111RAI!\u0011a\u0016QR<\n\u0007\u0005=UL\u0001\u0004PaRLwN\u001c\u0005\b\u0003'{\u0001\u0019AA2\u0003\u0011)\u0007\u0010\u001d:\u0002\u001f\u001d,GoQ1uC2L8\u000f\u001e+za\u0016$\"\"!'\u0002(\u0006E\u0016QWA]!\u0015a\u0016QRAN!\u0011\ti*a)\u000e\u0005\u0005}%bAAQ\t\u0006)A/\u001f9fg&!\u0011QUAP\u0005!!\u0015\r^1UsB,\u0007bBAU!\u0001\u0007\u00111V\u0001\bgFdG+\u001f9f!\ra\u0016QV\u0005\u0004\u0003_k&aA%oi\"1\u00111\u0017\tA\u0002]\f\u0001\u0002^=qK:\u000bW.\u001a\u0005\b\u0003o\u0003\u0002\u0019AAV\u0003\u0011\u0019\u0018N_3\t\u000f\u0005m\u0006\u00031\u0001\u0002>\u0006\u0011Q\u000e\u001a\t\u0005\u0003;\u000by,\u0003\u0003\u0002B\u0006}%aD'fi\u0006$\u0017\r^1Ck&dG-\u001a:\u0002\u0017\u001d,GO\u0013#C\u0007RK\b/\u001a\u000b\u0005\u0003\u000f\fy\rE\u0003]\u0003\u001b\u000bI\rE\u0002P\u0003\u0017L1!!4C\u0005!QEMY2UsB,\u0007bBAi#\u0001\u0007\u00111T\u0001\u0003IR\fAbY8na&dWMV1mk\u0016$B!a6\u0002^B\u0019A,!7\n\u0007\u0005mWLA\u0002B]fDq!a8\u0013\u0001\u0004\t9.A\u0003wC2,X-\u0001\rjg\u000e\u000b7oY1eS:<GK];oG\u0006$X\rV1cY\u0016$\"!!:\u0011\tq\u000biI]\u0001\u0011O\u0016$HK];oG\u0006$X-U;fef$Ra^Av\u0003_Da!!<\u0015\u0001\u00049\u0018!\u0002;bE2,\u0007\"CAy)A\u0005\t\u0019AAs\u0003\u001d\u0019\u0017m]2bI\u0016\f!dZ3u)J,hnY1uKF+XM]=%I\u00164\u0017-\u001e7uII*\"!a>+\t\u0005\u0015\u0018\u0011`\u0016\u0003\u0003w\u0004B!!@\u0003\b5\u0011\u0011q \u0006\u0005\u0005\u0003\u0011\u0019!A\u0005v]\u000eDWmY6fI*\u0019!QA/\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\n\u0005}(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\tr-\u001a;BI\u0012\u001cu\u000e\\;n]F+XM]=\u0015\u000f]\u0014yAa\u0005\u0003\u0018!1!\u0011\u0003\fA\u0002]\f\u0011\u0002^1cY\u0016t\u0015-\\3\t\r\tUa\u00031\u0001x\u0003)\u0019w\u000e\\;n]:\u000bW.\u001a\u0005\u0007\u000531\u0002\u0019A<\u0002\u0011\u0011\fG/\u0019+za\u0016\f\u0001dZ3u+B$\u0017\r^3D_2,XN\u001c+za\u0016\fV/\u001a:z)\u001d9(q\u0004B\u0011\u0005GAaA!\u0005\u0018\u0001\u00049\bB\u0002B\u000b/\u0001\u0007q\u000f\u0003\u0004\u0003&]\u0001\ra^\u0001\f]\u0016<H)\u0019;b)f\u0004X-A\u0010hKR,\u0006\u000fZ1uK\u000e{G.^7o\u001dVdG.\u00192jY&$\u00180U;fef$ra\u001eB\u0016\u0005[\u0011y\u0003\u0003\u0004\u0003\u0012a\u0001\ra\u001e\u0005\u0007\u0005+A\u0002\u0019A<\t\r\tE\u0002\u00041\u0001s\u0003)I7OT;mY\u0006\u0014G.Z\u0001\u000fO\u0016$H*[7ji\u000ec\u0017-^:f)\r9(q\u0007\u0005\b\u0005sI\u0002\u0019\u0001B\u001e\u0003\u0015a\u0017.\\5u!\u0011\t)B!\u0010\n\t\t}\u0012q\u0003\u0002\b\u0013:$XmZ3s\u0003=9W\r^(gMN,Go\u00117bkN,GcA<\u0003F!9!q\t\u000eA\u0002\tm\u0012AB8gMN,GOA\u000bPe\u0006\u001cG.Z*R\u0019F+XM]=Ck&dG-\u001a:\u0014\u0007m\u0011i\u0005E\u0002P\u0005\u001fJ1A!\u0015C\u0005MQEMY2T#2\u000bV/\u001a:z\u0005VLG\u000eZ3s\u0003\u001d!\u0017.\u00197fGR\fqa\u001c9uS>t7\u000f\u0005\u0003\u0003Z\t\u0015TB\u0001B.\u0015\r\u0019%Q\f\u0006\u0005\u0005?\u0012\t'A\u0006eCR\f7o\\;sG\u0016\u001c(b\u0001B2\t\u0006IQ\r_3dkRLwN\\\u0005\u0005\u0005O\u0012YFA\u0006K\t\n\u001bu\n\u001d;j_:\u001cHC\u0002B6\u0005[\u0012y\u0007E\u0002\u0002:mAaAa\u0015\u001f\u0001\u0004q\u0005b\u0002B+=\u0001\u0007!qK\u0001\u0006EVLG\u000e\u001a\u000b\u0002o\u00061r-\u001a;KI\n\u001c7+\u0015'Rk\u0016\u0014\u0018PQ;jY\u0012,'\u000f\u0006\u0003\u0003N\te\u0004b\u0002B+A\u0001\u0007!qK\u0001\u000egV\u0004\bo\u001c:ug2KW.\u001b;\u0016\u0003I\fab];qa>\u0014Ho](gMN,G/\u0001\u0007tkB\u0004xN\u001d;t\u0011&tG/A\tdY\u0006\u001c8/\u001b4z\u000bb\u001cW\r\u001d;j_:$BBa\"\u0003\u001c\n}%1\u0015BW\u0005c\u0013bA!#\u0003\u000e\nMeA\u0002BF\u0001\u0001\u00119I\u0001\u0007=e\u00164\u0017N\\3nK:$h\bE\u0002c\u0005\u001fK1A!%m\u0005%!\u0006N]8xC\ndW\r\u0005\u0003\u0003\u0016\n]U\"\u0001$\n\u0007\teeI\u0001\bTa\u0006\u00148\u000e\u00165s_^\f'\r\\3\t\u000f\tuE\u00051\u0001\u0003\u000e\u0006\tQ\r\u0003\u0004\u0003\"\u0012\u0002\ra^\u0001\nG>tG-\u001b;j_:DqA!*%\u0001\u0004\u00119+A\tnKN\u001c\u0018mZ3QCJ\fW.\u001a;feN\u0004R\u0001\u001fBUo^L1Aa+\u007f\u0005\ri\u0015\r\u001d\u0005\u0007\u0005_#\u0003\u0019A<\u0002\u0017\u0011,7o\u0019:jaRLwN\u001c\u0005\u0007\u0005g#\u0003\u0019\u0001:\u0002\u0013%\u001c(+\u001e8uS6,\u0017\u0001B2paf\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\n\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tY+\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005]'1\u0019\u0005\n\u0005\u000bD\u0013\u0011!a\u0001\u0003W\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001Bf!\u0019\u0011iMa4\u0002X6\u0011\u00111B\u0005\u0005\u0005#\fYA\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001:\u0003X\"I!Q\u0019\u0016\u0002\u0002\u0003\u0007\u0011q[\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\u0014\tu\u0007\"\u0003BcW\u0005\u0005\t\u0019AAV\u0003!A\u0017m\u001d5D_\u0012,GCAAV\u0003!!xn\u0015;sS:<GCAA\n\u0003\u0019)\u0017/^1mgR\u0019!Oa;\t\u0013\t\u0015g&!AA\u0002\u0005]\u0017!D(sC\u000edW\rR5bY\u0016\u001cG\u000f\u0005\u0002PaM)\u0001Ga=\u0003zB\u0019AL!>\n\u0007\t]XL\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0005w\u001c\t!\u0004\u0002\u0003~*!!q`A\u000e\u0003\tIw.C\u0002l\u0005{$\"Aa<\u0002\u0019\tKe*\u0011*Z?\u001acu*\u0011+\u0016\u0005\r%qBAB\u0006;\u0005!\u0017!\u0004\"J\u001d\u0006\u0013\u0016l\u0018$M\u001f\u0006#\u0006%A\u0007C\u0013:\u000b%+W0E\u001fV\u0013E*R\u000b\u0003\u0007'y!a!\u0006\u001e\u0003\u0015\faBQ%O\u0003JKv\fR(V\u00052+\u0005%\u0001\u0007U\u00136+5\u000bV!N!~#&,\u0006\u0002\u0004\u001e=\u00111qD\u000f\u00027\u0007iA+S'F'R\u000bU\nU0U5\u0002\nQ\u0002V%N\u000bN#\u0016)\u0014)`\u0019RSVCAB\u0014\u001f\t\u0019I#H\u0001\u001b\u00049!\u0016*T#T)\u0006k\u0005k\u0018'U5\u0002\n1\"\u0013(U\u000bJ3\u0016\tT0Z\u001bV\u00111\u0011G\b\u0003\u0007gi\u0012!g\u0001\r\u0013:#VI\u0015,B\u0019~KV\nI\u0001\f\u0013:#VI\u0015,B\u0019~#5+\u0006\u0002\u0004<=\u00111QH\u000f\u00021\u0007a\u0011J\u0014+F%Z\u000bEj\u0018#TA\u0005)\u0011\r\u001d9ms\u00069QO\\1qa2LHc\u0001:\u0004H!A1\u0011J \u0002\u0002\u0003\u0007q.A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"aa\u0014\u0011\t\u0005U1\u0011K\u0005\u0005\u0007'\n9B\u0001\u0004PE*,7\r\u001e")
public class OracleDialect
extends JdbcDialect
implements SQLConfHelper,
NoLegacyJDBCError,
Product {
    private final Set<String> org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions;
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedFunctions;

    public static boolean unapply(OracleDialect x$0) {
        return OracleDialect$.MODULE$.unapply(x$0);
    }

    public static OracleDialect apply() {
        return OracleDialect$.MODULE$.apply();
    }

    public static int INTERVAL_DS() {
        return OracleDialect$.MODULE$.INTERVAL_DS();
    }

    public static int INTERVAL_YM() {
        return OracleDialect$.MODULE$.INTERVAL_YM();
    }

    public static int TIMESTAMP_LTZ() {
        return OracleDialect$.MODULE$.TIMESTAMP_LTZ();
    }

    public static int TIMESTAMP_TZ() {
        return OracleDialect$.MODULE$.TIMESTAMP_TZ();
    }

    public static int BINARY_DOUBLE() {
        return OracleDialect$.MODULE$.BINARY_DOUBLE();
    }

    public static int BINARY_FLOAT() {
        return OracleDialect$.MODULE$.BINARY_FLOAT();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:oracle");
    }

    public Set<String> org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions() {
        return this.org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions;
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        OracleSQLBuilder oracleSQLBuilder = new OracleSQLBuilder(this);
        try {
            some = new Some((Object)oracleSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", throwable2);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        int n = sqlType;
        switch (n) {
            case 2: {
                long scale = md != null ? md.build().getLong("scale") : 0L;
                int n2 = size;
                switch (n2) {
                    case 0: {
                        return Option$.MODULE$.apply((Object)new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), 10));
                    }
                }
                if (scale == -127L) {
                    return Option$.MODULE$.apply((Object)new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), 10));
                }
                return None$.MODULE$;
            }
            case -102: 
            case -101: {
                return new Some((Object)TimestampType$.MODULE$);
            }
            case 100: {
                return new Some((Object)FloatType$.MODULE$);
            }
            case 101: {
                return new Some((Object)DoubleType$.MODULE$);
            }
            case -103: {
                return new Some((Object)YearMonthIntervalType$.MODULE$.apply());
            }
            case -104: {
                return new Some((Object)DayTimeIntervalType$.MODULE$.apply());
            }
        }
        return None$.MODULE$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(1)", 16));
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(10)", 4));
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(19)", -5));
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(19, 4)", 6));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(19, 4)", 8));
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(3)", 5));
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(5)", 5));
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("VARCHAR2(255)", 12));
        }
        if (dataType instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)dataType;
            int n = varcharType.length();
            return new Some((Object)new JdbcType("VARCHAR2(" + n + ")", 12));
        }
        if (TimestampType$.MODULE$.equals(dataType) && !this.conf().legacyOracleTimestampMappingEnabled()) {
            return new Some((Object)new JdbcType("TIMESTAMP WITH LOCAL TIME ZONE", -102));
        }
        return None$.MODULE$;
    }

    @Override
    public Object compileValue(Object value2) {
        Object object = value2;
        if (object instanceof String) {
            String string = (String)object;
            return "'" + this.escapeSql(string) + "'";
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return "{ts '" + timestamp + "'}";
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return "{d '" + date + "'}";
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            return Predef$.MODULE$.genericWrapArray(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)objectArray), (Function1 & Serializable)value -> this.compileValue(value), ClassTag$.MODULE$.Any())).mkString(", ");
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(byArray), (Function1 & Serializable)x$1 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02X"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)x$1))})), ClassTag$.MODULE$.apply(String.class))).mkString("HEXTORAW('", "", "')");
        }
        return value2;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        Some some;
        boolean bl;
        Option<Object> option = cascade;
        if (option instanceof Some && (bl = BoxesRunTime.unboxToBoolean((Object)(some = (Some)option).value()))) {
            return "TRUNCATE TABLE " + table + " CASCADE";
        }
        return "TRUNCATE TABLE " + table;
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    @Override
    public String getAddColumnQuery(String tableName, String columnName, String dataType) {
        return "ALTER TABLE " + tableName + " ADD " + this.quoteIdentifier(columnName) + " " + dataType;
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return "ALTER TABLE " + tableName + " MODIFY " + this.quoteIdentifier(columnName) + " " + newDataType;
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "NULL" : "NOT NULL";
        return "ALTER TABLE " + tableName + " MODIFY " + this.quoteIdentifier(columnName) + " " + nullable;
    }

    @Override
    public String getLimitClause(Integer limit) {
        if (Predef$.MODULE$.Integer2int(limit) > 0) {
            return "WHERE rownum <= " + limit;
        }
        return "";
    }

    @Override
    public String getOffsetClause(Integer offset) {
        if (Predef$.MODULE$.Integer2int(offset) > 0) {
            return "WHERE rn > " + offset;
        }
        return "";
    }

    @Override
    public JdbcSQLQueryBuilder getJdbcSQLQueryBuilder(JDBCOptions options) {
        return new OracleSQLQueryBuilder(this, this, options);
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    @Override
    public boolean supportsHint() {
        return true;
    }

    @Override
    public Throwable classifyException(Throwable e, String condition, Map<String, String> messageParameters, String description, boolean isRuntime) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            int n = sQLException.getErrorCode();
            switch (n) {
                case 955: {
                    String string = condition;
                    String string2 = "FAILED_JDBC.RENAME_TABLE";
                    if (string != null ? !string.equals(string2) : string2 != null) break;
                    String newTable = (String)messageParameters.apply((Object)"newName");
                    throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(newTable);
                }
            }
            return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
        }
        return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
    }

    public OracleDialect copy() {
        return new OracleDialect();
    }

    public String productPrefix() {
        return "OracleDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof OracleDialect;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof OracleDialect && ((OracleDialect)x$1).canEqual(this);
    }

    public OracleDialect() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        NoLegacyJDBCError.$init$(this);
        Product.$init$((Product)this);
        this.org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP", "COVAR_POP", "COVAR_SAMP", "CORR", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXY"}));
        this.supportedAggregateFunctions = (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG"}))).$plus$plus(this.org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions());
        this.supportedFunctions = this.supportedAggregateFunctions();
    }

    public class OracleSQLBuilder
    extends JdbcDialect.JDBCSQLBuilder {
        @Override
        public String visitAggregateFunction(String funcName, boolean isDistinct, String[] inputs) {
            if (isDistinct && this.org$apache$spark$sql$jdbc$OracleDialect$OracleSQLBuilder$$$outer().org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions().contains((Object)funcName)) {
                throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3184", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)this.getClass().getSimpleName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)funcName)})));
            }
            return super.visitAggregateFunction(funcName, isDistinct, inputs);
        }

        public String visitBinaryComparison(String name, Expression le, Expression re) {
            Tuple2 tuple2 = new Tuple2((Object)le, (Object)re);
            if (tuple2 != null) {
                Expression lhs = (Expression)tuple2._1();
                Expression rhs = (Expression)tuple2._2();
                if (lhs instanceof Literal) {
                    Literal literal = (Literal)lhs;
                    if (rhs != null) {
                        Expression expression = rhs;
                        DataType dataType = literal.dataType();
                        BinaryType$ binaryType$ = BinaryType$.MODULE$;
                        if (!(dataType != null ? !dataType.equals(binaryType$) : binaryType$ != null)) {
                            return this.compareBlob((Expression)literal, name, expression);
                        }
                    }
                }
            }
            if (tuple2 != null) {
                Expression lhs = (Expression)tuple2._1();
                Expression rhs = (Expression)tuple2._2();
                if (lhs != null) {
                    Expression expression = lhs;
                    if (rhs instanceof Literal) {
                        Literal literal = (Literal)rhs;
                        DataType dataType = literal.dataType();
                        BinaryType$ binaryType$ = BinaryType$.MODULE$;
                        if (!(dataType != null ? !dataType.equals(binaryType$) : binaryType$ != null)) {
                            return this.compareBlob(expression, name, (Expression)literal);
                        }
                    }
                }
            }
            return super.visitBinaryComparison(name, le, re);
        }

        private String compareBlob(Expression lhs, String operator, Expression rhs) {
            String l = this.inputToSQL(lhs);
            String r = this.inputToSQL(rhs);
            String string = operator;
            String string2 = "<=>";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String compare = "DBMS_LOB.COMPARE(" + l + ", " + r + ") = 0";
                return "((" + l + " IS NOT NULL AND " + r + " IS NOT NULL AND " + compare + ") OR (" + l + " IS NULL AND " + r + " IS NULL))";
            }
            return "DBMS_LOB.COMPARE(" + l + ", " + r + ") " + operator + " 0";
        }

        public /* synthetic */ OracleDialect org$apache$spark$sql$jdbc$OracleDialect$OracleSQLBuilder$$$outer() {
            return (OracleDialect)this.$outer;
        }

        public OracleSQLBuilder(OracleDialect $outer) {
            super($outer);
        }
    }

    public class OracleSQLQueryBuilder
    extends JdbcSQLQueryBuilder {
        private final JdbcDialect dialect;
        private final JDBCOptions options;
        public final /* synthetic */ OracleDialect $outer;

        @Override
        public String build() {
            String string;
            String selectStmt = "SELECT " + this.hintClause() + this.columnList() + " FROM " + this.options.tableOrQuery() + " " + this.tableSampleClause() + " " + this.whereClause() + " " + this.groupByClause() + " " + this.orderByClause();
            if (this.limit() > 0) {
                if (this.offset() > 0) {
                    string = "SELECT " + this.columnList() + " FROM (SELECT tab.*, rownum rn FROM (" + selectStmt + ") tab) WHERE rn > " + this.offset() + " AND rn <= " + (this.limit() + this.offset());
                } else {
                    String limitClause = this.dialect.getLimitClause(Predef$.MODULE$.int2Integer(this.limit()));
                    string = "SELECT tab.* FROM (" + selectStmt + ") tab " + limitClause;
                }
            } else if (this.offset() > 0) {
                String offsetClause = this.dialect.getOffsetClause(Predef$.MODULE$.int2Integer(this.offset()));
                string = "SELECT " + this.columnList() + " FROM (SELECT tab.*, rownum rn FROM (" + selectStmt + ") tab) " + offsetClause;
            } else {
                string = selectStmt;
            }
            String finalSelectStmt = string;
            return this.options.prepareQuery() + finalSelectStmt;
        }

        public /* synthetic */ OracleDialect org$apache$spark$sql$jdbc$OracleDialect$OracleSQLQueryBuilder$$$outer() {
            return this.$outer;
        }

        public OracleSQLQueryBuilder(OracleDialect $outer, JdbcDialect dialect, JDBCOptions options) {
            this.dialect = dialect;
            this.options = options;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(dialect, options);
        }
    }
}

