/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

@Description(name="array", value="_FUNC_(n0, n1...) - Creates an array with the given elements ")
public class GenericUDFArray
extends GenericUDF {
    private transient ObjectInspectorConverters.Converter[] converters;
    private transient ArrayList<Object> ret = new ArrayList();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        GenericUDFUtils.ReturnObjectInspectorResolver returnOIResolver = new GenericUDFUtils.ReturnObjectInspectorResolver(true);
        for (int i = 0; i < arguments.length; ++i) {
            if (returnOIResolver.update(arguments[i])) continue;
            throw new UDFArgumentTypeException(i, "Argument type \"" + arguments[i].getTypeName() + "\" is different from preceding arguments. Previous type was \"" + arguments[i - 1].getTypeName() + "\"");
        }
        this.converters = new ObjectInspectorConverters.Converter[arguments.length];
        ObjectInspector returnOI = returnOIResolver.get((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        for (int i = 0; i < arguments.length; ++i) {
            this.converters[i] = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[i], (ObjectInspector)returnOI);
        }
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)returnOI);
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        this.ret.clear();
        for (int i = 0; i < arguments.length; ++i) {
            this.ret.add(this.converters[i].convert(arguments[i].get()));
        }
        return this.ret;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("array", children, ",");
    }
}

