/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.clustering.GaussianMixtureModel$;
import org.apache.spark.ml.clustering.GaussianMixtureModel$GaussianMixtureModelReader$;
import org.apache.spark.ml.clustering.GaussianMixtureModel$GaussianMixtureModelWriter$;
import org.apache.spark.ml.clustering.GaussianMixtureParams;
import org.apache.spark.ml.clustering.GaussianMixtureSummary;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasProbabilityCol;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.stat.distribution.MultivariateGaussian;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.ReadWriteUtils$;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.SizeEstimator$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.hashing.MurmurHash3$;

@ScalaSignature(bytes="\u0006\u0005\r\u0005h\u0001\u0002%J\u0001QC\u0001B\u001b\u0001\u0003\u0006\u0004%\te\u001b\u0005\n\u0003\u000b\u0001!\u0011!Q\u0001\n1D!\"!\u0003\u0001\u0005\u000b\u0007I\u0011AA\u0006\u0011)\ti\u0002\u0001B\u0001B\u0003%\u0011Q\u0002\u0005\u000b\u0003C\u0001!Q1A\u0005\u0002\u0005\r\u0002BCA\u001d\u0001\t\u0005\t\u0015!\u0003\u0002&!A\u0011Q\b\u0001\u0005\u0002-\u000by\u0004\u0003\u0005\u0002>\u0001!\taSA'\u0011)\ty\u0005\u0001EC\u0002\u0013\u0005\u0011\u0011\u000b\u0005\b\u0003?\u0002A\u0011AA1\u0011\u001d\ty\u0007\u0001C\u0001\u0003cBq!a\u001e\u0001\t\u0003\tI\bC\u0004\u0002\u0000\u0001!\t%!!\t\u000f\u0005U\u0005\u0001\"\u0011\u0002\u0018\"9\u0011\u0011\u001d\u0001\u0005B\u0005\r\bbBA|\u0001\u0011\u0005\u0011\u0011 \u0005\b\u0005\u001b\u0001A\u0011\u0001B\b\u0011\u001d\u0011)\u0002\u0001C\u0001\u0005/AqAa\u0007\u0001\t\u0003\u0012i\u0002C\u0004\u0003(\u0001!\tE!\u000b\t\u000f\t5\u0002\u0001\"\u0011\u00030!9!1\u0007\u0001\u0005B\tU\u0002\u0002\u0003B\u001f\u0001\u0011\u0005QJa\u0010\t\u0011\tM\u0003\u0001\"\u0011N\u0005+B\u0001Ba\u0017\u0001\t\u0003j%QL\u0004\b\u0005KJ\u0005\u0012\u0001B4\r\u0019A\u0015\n#\u0001\u0003j!9\u0011QH\u000e\u0005\u0002\t\u001dea\u0002BE7\u0001[%1\u0012\u0005\u000b\u0003\u0013i\"Q3A\u0005\u0002\u0005-\u0001BCA\u000f;\tE\t\u0015!\u0003\u0002\u000e!Q!\u0011U\u000f\u0003\u0016\u0004%\tAa)\t\u0015\tMVD!E!\u0002\u0013\u0011)\u000b\u0003\u0006\u00036v\u0011)\u001a!C\u0001\u0005oC!B!1\u001e\u0005#\u0005\u000b\u0011\u0002B]\u0011\u001d\ti$\bC\u0001\u0005\u0007D\u0011\"a \u001e\u0003\u0003%\tAa4\t\u0013\t]W$%A\u0005\u0002\te\u0007\"\u0003Bw;E\u0005I\u0011\u0001Bx\u0011%\u0011\u00190HI\u0001\n\u0003\u0011)\u0010C\u0005\u0003zv\t\t\u0011\"\u0011\u0003|\"I1qA\u000f\u0002\u0002\u0013\u0005\u0011\u0011\u000b\u0005\n\u0007\u0013i\u0012\u0011!C\u0001\u0007\u0017A\u0011b!\u0005\u001e\u0003\u0003%\tea\u0005\t\u0013\r\u0005R$!A\u0005\u0002\r\r\u0002\"CB\u0017;\u0005\u0005I\u0011IB\u0018\u0011%\u0019\u0019$HA\u0001\n\u0003\u001a)\u0004C\u0005\u0003(u\t\t\u0011\"\u0011\u00048!I1\u0011H\u000f\u0002\u0002\u0013\u000531H\u0004\u000b\u0007\u007fY\u0012\u0011!E\u0001\u0017\u000e\u0005cA\u0003BE7\u0005\u0005\t\u0012A&\u0004D!9\u0011QH\u001a\u0005\u0002\rE\u0003\"\u0003B\u0014g\u0005\u0005IQIB\u001c\u0011%\u0019\u0019fMA\u0001\n\u0003\u001b)\u0006C\u0005\u0004^M\n\t\u0011\"!\u0004`!I1\u0011O\u001a\u0002\u0002\u0013%11\u000f\u0005\t\u0007wZB\u0011A&\u0004~!A1QR\u000e\u0005\u0002-\u001by\tC\u0004\u0004\u001cn!\te!(\t\u000f\r\u001d6\u0004\"\u0011\u0004*\u001a91qV\u000e\u00017\rE\u0006\"CBZ{\t\u0005\t\u0015!\u0003Z\u0011\u001d\ti$\u0010C\u0001\u0007kCqaa/>\t#\u001aiL\u0002\u0004\u0004Bn!11\u0019\u0005\b\u0003{\tE\u0011ABc\u0011%\u0019I-\u0011b\u0001\n\u0013\u0011Y\u0010\u0003\u0005\u0004L\u0006\u0003\u000b\u0011\u0002B\u007f\u0011\u001d\u00199+\u0011C!\u0007\u001bD\u0001b!5\u001c\t\u0003I51\u001b\u0005\n\u0007cZ\u0012\u0011!C\u0005\u0007g\u0012AcR1vgNL\u0017M\\'jqR,(/Z'pI\u0016d'B\u0001&L\u0003)\u0019G.^:uKJLgn\u001a\u0006\u0003\u00196\u000b!!\u001c7\u000b\u00059{\u0015!B:qCJ\\'B\u0001)R\u0003\u0019\t\u0007/Y2iK*\t!+A\u0002pe\u001e\u001c\u0001aE\u0003\u0001+nsF\rE\u0002W/fk\u0011aS\u0005\u00031.\u0013Q!T8eK2\u0004\"A\u0017\u0001\u000e\u0003%\u0003\"A\u0017/\n\u0005uK%!F$bkN\u001c\u0018.\u00198NSb$XO]3QCJ\fWn\u001d\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C.\u000bA!\u001e;jY&\u00111\r\u0019\u0002\u000b\u001b2;&/\u001b;bE2,\u0007cA0fO&\u0011a\r\u0019\u0002\u0013\u0011\u0006\u001cHK]1j]&twmU;n[\u0006\u0014\u0018\u0010\u0005\u0002[Q&\u0011\u0011.\u0013\u0002\u0017\u000f\u0006,8o]5b]6K\u0007\u0010^;sKN+X.\\1ss\u0006\u0019Q/\u001b3\u0016\u00031\u0004\"!\u001c<\u000f\u00059$\bCA8s\u001b\u0005\u0001(BA9T\u0003\u0019a$o\\8u})\t1/A\u0003tG\u0006d\u0017-\u0003\u0002ve\u00061\u0001K]3eK\u001aL!a\u001e=\u0003\rM#(/\u001b8h\u0015\t)(\u000f\u000b\u0003\u0002u\u0006\u0005\u0001CA>\u007f\u001b\u0005a(BA?N\u0003)\tgN\\8uCRLwN\\\u0005\u0003\u007fr\u0014QaU5oG\u0016\f#!a\u0001\u0002\u000bIr\u0003G\f\u0019\u0002\tULG\r\t\u0015\u0005\u0005i\f\t!A\u0004xK&<\u0007\u000e^:\u0016\u0005\u00055\u0001CBA\b\u0003#\t)\"D\u0001s\u0013\r\t\u0019B\u001d\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003\u001f\t9\"C\u0002\u0002\u001aI\u0014a\u0001R8vE2,\u0007\u0006B\u0002{\u0003\u0003\t\u0001b^3jO\"$8\u000f\t\u0015\u0005\ti\f\t!A\u0005hCV\u001c8/[1ogV\u0011\u0011Q\u0005\t\u0007\u0003\u001f\t\t\"a\n\u0011\t\u0005%\u00121G\u0007\u0003\u0003WQA!!\f\u00020\u0005aA-[:ue&\u0014W\u000f^5p]*\u0019\u0011\u0011G&\u0002\tM$\u0018\r^\u0005\u0005\u0003k\tYC\u0001\u000bNk2$\u0018N^1sS\u0006$XmR1vgNL\u0017M\u001c\u0015\u0005\u000bi\f\t!\u0001\u0006hCV\u001c8/[1og\u0002BCA\u0002>\u0002\u0002\u00051A(\u001b8jiz\"r!WA!\u0003\u000b\nI\u0005C\u0003k\u000f\u0001\u0007A\u000eK\u0003\u0002Bi\f\t\u0001C\u0004\u0002\n\u001d\u0001\r!!\u0004)\u000b\u0005\u0015#0!\u0001\t\u000f\u0005\u0005r\u00011\u0001\u0002&!*\u0011\u0011\n>\u0002\u0002Q\t\u0011,A\u0006ok64U-\u0019;ve\u0016\u001cXCAA*!\u0011\ty!!\u0016\n\u0007\u0005]#OA\u0002J]RDC!\u0003>\u0002\\\u0005\u0012\u0011QL\u0001\u0006g9\u0002d\u0006M\u0001\u000fg\u0016$h)Z1ukJ,7oQ8m)\u0011\t\u0019'!\u001a\u000e\u0003\u0001Aa!a\u001a\u000b\u0001\u0004a\u0017!\u0002<bYV,\u0007\u0006\u0002\u0006{\u0003W\n#!!\u001c\u0002\u000bIr\u0013G\f\u0019\u0002!M,G\u000f\u0015:fI&\u001cG/[8o\u0007>dG\u0003BA2\u0003gBa!a\u001a\f\u0001\u0004a\u0007\u0006B\u0006{\u0003W\n\u0011c]3u!J|'-\u00192jY&$\u0018pQ8m)\u0011\t\u0019'a\u001f\t\r\u0005\u001dD\u00021\u0001mQ\u0011a!0a\u001b\u0002\t\r|\u0007/\u001f\u000b\u00043\u0006\r\u0005bBAC\u001b\u0001\u0007\u0011qQ\u0001\u0006Kb$(/\u0019\t\u0005\u0003\u0013\u000by)\u0004\u0002\u0002\f*\u0019\u0011QR&\u0002\u000bA\f'/Y7\n\t\u0005E\u00151\u0012\u0002\t!\u0006\u0014\u0018-\\'ba\"\"QB_A\u0001\u0003%!(/\u00198tM>\u0014X\u000e\u0006\u0003\u0002\u001a\u0006m\u0006\u0003BAN\u0003ksA!!(\u00020:!\u0011qTAV\u001d\u0011\t\t+!+\u000f\t\u0005\r\u0016q\u0015\b\u0004_\u0006\u0015\u0016\"\u0001*\n\u0005A\u000b\u0016B\u0001(P\u0013\r\ti+T\u0001\u0004gFd\u0017\u0002BAY\u0003g\u000bq\u0001]1dW\u0006<WMC\u0002\u0002.6KA!a.\u0002:\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0005\u0003c\u000b\u0019\fC\u0004\u0002>:\u0001\r!a0\u0002\u000f\u0011\fG/Y:fiB\"\u0011\u0011YAg!\u0019\t\u0019-!2\u0002J6\u0011\u00111W\u0005\u0005\u0003\u000f\f\u0019LA\u0004ECR\f7/\u001a;\u0011\t\u0005-\u0017Q\u001a\u0007\u0001\t1\ty-a/\u0002\u0002\u0003\u0005)\u0011AAi\u0005\ryF%M\t\u0005\u0003'\fI\u000e\u0005\u0003\u0002\u0010\u0005U\u0017bAAle\n9aj\u001c;iS:<\u0007\u0003BA\b\u00037L1!!8s\u0005\r\te.\u001f\u0015\u0005\u001di\f\t!A\bue\u0006t7OZ8s[N\u001b\u0007.Z7b)\u0011\t)/!=\u0011\t\u0005\u001d\u0018Q^\u0007\u0003\u0003STA!a;\u00024\u0006)A/\u001f9fg&!\u0011q^Au\u0005)\u0019FO];diRK\b/\u001a\u0005\b\u0003g|\u0001\u0019AAs\u0003\u0019\u00198\r[3nC\"\"qB_A\u0001\u0003\u001d\u0001(/\u001a3jGR$B!a\u0015\u0002|\"9\u0011Q \tA\u0002\u0005}\u0018\u0001\u00034fCR,(/Z:\u0011\t\t\u0005!qA\u0007\u0003\u0005\u0007Q1A!\u0002L\u0003\u0019a\u0017N\\1mO&!!\u0011\u0002B\u0002\u0005\u00191Vm\u0019;pe\"\"\u0001C_A.\u0003I\u0001(/\u001a3jGR\u0004&o\u001c2bE&d\u0017\u000e^=\u0015\t\u0005}(\u0011\u0003\u0005\b\u0003{\f\u0002\u0019AA\u0000Q\u0011\t\"0a\u0017\u0002\u0017\u001d\fWo]:jC:\u001cHIR\u000b\u0003\u00033CCA\u0005>\u0002\u0002\u0005)qO]5uKV\u0011!q\u0004\t\u0004?\n\u0005\u0012b\u0001B\u0012A\nAQ\nT,sSR,'\u000f\u000b\u0003\u0014u\u0006\u0005\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u00031DC\u0001\u0006>\u0002\\\u000591/^7nCJLX#A4)\tUQ\u0018\u0011A\u0001\u000eKN$\u0018.\\1uK\u0012\u001c\u0016N_3\u0016\u0005\t]\u0002\u0003BA\b\u0005sI1Aa\u000fs\u0005\u0011auN\\4\u0002\u001b\r\u0014X-\u0019;f'VlW.\u0019:z)!\u0011\tEa\u0012\u0003L\t=\u0003\u0003BA\b\u0005\u0007J1A!\u0012s\u0005\u0011)f.\u001b;\t\u000f\t%s\u00031\u0001\u0002\u001a\u0006Y\u0001O]3eS\u000e$\u0018n\u001c8t\u0011\u001d\u0011ie\u0006a\u0001\u0003+\tQ\u0002\\8h\u0019&\\W\r\\5i_>$\u0007b\u0002B)/\u0001\u0007\u00111K\u0001\nSR,'/\u0019;j_:\f1b]1wKN+X.\\1ssR!!\u0011\tB,\u0011\u0019\u0011I\u0006\u0007a\u0001Y\u0006!\u0001/\u0019;i\u0003-aw.\u00193Tk6l\u0017M]=\u0015\r\t\u0005#q\fB1\u0011\u0019\u0011I&\u0007a\u0001Y\"9\u0011QX\rA\u0002\u0005e\u0005\u0006\u0002\u0001{\u0003\u0003\tAcR1vgNL\u0017M\\'jqR,(/Z'pI\u0016d\u0007C\u0001.\u001c'\u001dY\"1\u000eB9\u0005o\u0002B!a\u0004\u0003n%\u0019!q\u000e:\u0003\r\u0005s\u0017PU3g!\u0011y&1O-\n\u0007\tU\u0004M\u0001\u0006N\u0019J+\u0017\rZ1cY\u0016\u0004BA!\u001f\u0003\u00046\u0011!1\u0010\u0006\u0005\u0005{\u0012y(\u0001\u0002j_*\u0011!\u0011Q\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003\u0006\nm$\u0001D*fe&\fG.\u001b>bE2,GC\u0001B4\u0005\u0011!\u0015\r^1\u0014\u000fu\u0011YG!$\u0003\u0014B!\u0011q\u0002BH\u0013\r\u0011\tJ\u001d\u0002\b!J|G-^2u!\u0011\u0011)J!(\u000f\t\t]%1\u0014\b\u0004_\ne\u0015\"A:\n\u0007\u0005E&/\u0003\u0003\u0003\u0006\n}%bAAYe\u0006\u0019Q.^:\u0016\u0005\t\u0015\u0006CBA\b\u0003#\u00119\u000b\u0005\u0003\u0003*\nEVB\u0001BV\u0015\u0011\u0011)A!,\u000b\u0007\t=V*A\u0003nY2L'-\u0003\u0003\u0003\n\t-\u0016\u0001B7vg\u0002\naa]5h[\u0006\u001cXC\u0001B]!\u0019\ty!!\u0005\u0003<B!!\u0011\u0016B_\u0013\u0011\u0011yLa+\u0003\r5\u000bGO]5y\u0003\u001d\u0019\u0018nZ7bg\u0002\"\u0002B!2\u0003J\n-'Q\u001a\t\u0004\u0005\u000flR\"A\u000e\t\u000f\u0005%A\u00051\u0001\u0002\u000e!9!\u0011\u0015\u0013A\u0002\t\u0015\u0006b\u0002B[I\u0001\u0007!\u0011\u0018\u000b\t\u0005\u000b\u0014\tNa5\u0003V\"I\u0011\u0011B\u0013\u0011\u0002\u0003\u0007\u0011Q\u0002\u0005\n\u0005C+\u0003\u0013!a\u0001\u0005KC\u0011B!.&!\u0003\u0005\rA!/\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\u001c\u0016\u0005\u0003\u001b\u0011in\u000b\u0002\u0003`B!!\u0011\u001dBu\u001b\t\u0011\u0019O\u0003\u0003\u0003f\n\u001d\u0018!C;oG\",7m[3e\u0015\ti(/\u0003\u0003\u0003l\n\r(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001ByU\u0011\u0011)K!8\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!q\u001f\u0016\u0005\u0005s\u0013i.A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005{\u0004BAa@\u0004\u00065\u00111\u0011\u0001\u0006\u0005\u0007\u0007\u0011y(\u0001\u0003mC:<\u0017bA<\u0004\u0002\u0005a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAm\u0007\u001bA\u0011ba\u0004,\u0003\u0003\u0005\r!a\u0015\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0019)\u0002\u0005\u0004\u0004\u0018\ru\u0011\u0011\\\u0007\u0003\u00073Q1aa\u0007s\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0007?\u0019IB\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BB\u0013\u0007W\u0001B!a\u0004\u0004(%\u00191\u0011\u0006:\u0003\u000f\t{w\u000e\\3b]\"I1qB\u0017\u0002\u0002\u0003\u0007\u0011\u0011\\\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003~\u000eE\u0002\"CB\b]\u0005\u0005\t\u0019AA*\u0003!A\u0017m\u001d5D_\u0012,GCAA*)\t\u0011i0\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0007K\u0019i\u0004C\u0005\u0004\u0010E\n\t\u00111\u0001\u0002Z\u0006!A)\u0019;b!\r\u00119mM\n\u0006g\r\u0015#q\u000f\t\r\u0007\u000f\u001ai%!\u0004\u0003&\ne&QY\u0007\u0003\u0007\u0013R1aa\u0013s\u0003\u001d\u0011XO\u001c;j[\u0016LAaa\u0014\u0004J\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\r\u0005\u0013!B1qa2LH\u0003\u0003Bc\u0007/\u001aIfa\u0017\t\u000f\u0005%a\u00071\u0001\u0002\u000e!9!\u0011\u0015\u001cA\u0002\t\u0015\u0006b\u0002B[m\u0001\u0007!\u0011X\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019\tg!\u001c\u0011\r\u0005=11MB4\u0013\r\u0019)G\u001d\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0015\u0005=1\u0011NA\u0007\u0005K\u0013I,C\u0002\u0004lI\u0014a\u0001V;qY\u0016\u001c\u0004\"CB8o\u0005\u0005\t\u0019\u0001Bc\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0007k\u0002BAa@\u0004x%!1\u0011PB\u0001\u0005\u0019y%M[3di\u0006i1/\u001a:jC2L'0\u001a#bi\u0006$bA!\u0011\u0004\u0000\r\r\u0005bBBAs\u0001\u0007!QY\u0001\u0005I\u0006$\u0018\rC\u0004\u0004\u0006f\u0002\raa\"\u0002\u0007\u0011|7\u000f\u0005\u0003\u0003z\r%\u0015\u0002BBF\u0005w\u0012\u0001\u0003R1uC>+H\u000f];u'R\u0014X-Y7\u0002\u001f\u0011,7/\u001a:jC2L'0\u001a#bi\u0006$BA!2\u0004\u0012\"911\u0013\u001eA\u0002\rU\u0015a\u00013jgB!!\u0011PBL\u0013\u0011\u0019IJa\u001f\u0003\u001f\u0011\u000bG/Y%oaV$8\u000b\u001e:fC6\fAA]3bIV\u00111q\u0014\t\u0005?\u000e\u0005\u0016,C\u0002\u0004$\u0002\u0014\u0001\"\u0014'SK\u0006$WM\u001d\u0015\u0005wi\f\t!\u0001\u0003m_\u0006$GcA-\u0004,\"1!\u0011\f\u001fA\u00021DC\u0001\u0010>\u0002\u0002\tQr)Y;tg&\fg.T5yiV\u0014X-T8eK2<&/\u001b;feN\u0019QHa\b\u0002\u0011%t7\u000f^1oG\u0016$Baa.\u0004:B\u0019!qY\u001f\t\r\rMv\b1\u0001Z\u0003!\u0019\u0018M^3J[BdG\u0003\u0002B!\u0007\u007fCaA!\u0017A\u0001\u0004a'AG$bkN\u001c\u0018.\u00198NSb$XO]3N_\u0012,GNU3bI\u0016\u00148cA!\u0004 R\u00111q\u0019\t\u0004\u0005\u000f\f\u0015!C2mCN\u001ch*Y7f\u0003)\u0019G.Y:t\u001d\u0006lW\r\t\u000b\u00043\u000e=\u0007B\u0002B-\u000b\u0002\u0007A.\u0001\u000bd_6\u0004X\u000f^3Qe>\u0014\u0017MY5mSRLWm\u001d\u000b\t\u0003\u001b\u0019)na6\u0004\\\"9\u0011Q $A\u0002\u0005}\bbBBm\r\u0002\u0007\u0011QE\u0001\u0006I&\u001cHo\u001d\u0005\b\u0003\u00131\u0005\u0019AA\u0007Q\u0011Y\"0!\u0001)\tiQ\u0018\u0011\u0001")
public class GaussianMixtureModel
extends Model<GaussianMixtureModel>
implements GaussianMixtureParams,
MLWritable,
HasTrainingSummary<GaussianMixtureSummary> {
    private int numFeatures;
    private final String uid;
    private final double[] weights;
    private final MultivariateGaussian[] gaussians;
    private Option<GaussianMixtureSummary> trainingSummary;
    private IntParam k;
    private IntParam aggregationDepth;
    private DoubleParam tol;
    private Param<String> probabilityCol;
    private Param<String> weightCol;
    private Param<String> predictionCol;
    private LongParam seed;
    private Param<String> featuresCol;
    private IntParam maxIter;
    private volatile boolean bitmap$0;

    public static GaussianMixtureModel load(String path) {
        return GaussianMixtureModel$.MODULE$.load(path);
    }

    public static MLReader<GaussianMixtureModel> read() {
        return GaussianMixtureModel$.MODULE$.read();
    }

    @Override
    public boolean hasSummary() {
        return HasTrainingSummary.hasSummary$(this);
    }

    @Override
    public HasTrainingSummary<GaussianMixtureSummary> setSummary(Option<GaussianMixtureSummary> summary) {
        return HasTrainingSummary.setSummary$(this, summary);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getK() {
        return GaussianMixtureParams.getK$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return GaussianMixtureParams.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final String getProbabilityCol() {
        return HasProbabilityCol.getProbabilityCol$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final Option<GaussianMixtureSummary> trainingSummary() {
        return this.trainingSummary;
    }

    @Override
    public final void trainingSummary_$eq(Option<GaussianMixtureSummary> x$1) {
        this.trainingSummary = x$1;
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final void org$apache$spark$ml$clustering$GaussianMixtureParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final Param<String> probabilityCol() {
        return this.probabilityCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasProbabilityCol$_setter_$probabilityCol_$eq(Param<String> x$1) {
        this.probabilityCol = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public double[] weights() {
        return this.weights;
    }

    public MultivariateGaussian[] gaussians() {
        return this.gaussians;
    }

    private int numFeatures$lzycompute() {
        GaussianMixtureModel gaussianMixtureModel = this;
        synchronized (gaussianMixtureModel) {
            if (!this.bitmap$0) {
                this.numFeatures = ((MultivariateGaussian)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])this.gaussians()))).mean().size();
                this.bitmap$0 = true;
            }
        }
        return this.numFeatures;
    }

    public int numFeatures() {
        if (!this.bitmap$0) {
            return this.numFeatures$lzycompute();
        }
        return this.numFeatures;
    }

    public GaussianMixtureModel setFeaturesCol(String value) {
        return (GaussianMixtureModel)this.set(this.featuresCol(), value);
    }

    public GaussianMixtureModel setPredictionCol(String value) {
        return (GaussianMixtureModel)this.set(this.predictionCol(), value);
    }

    public GaussianMixtureModel setProbabilityCol(String value) {
        return (GaussianMixtureModel)this.set(this.probabilityCol(), value);
    }

    @Override
    public GaussianMixtureModel copy(ParamMap extra) {
        GaussianMixtureModel copied = this.copyValues(new GaussianMixtureModel(this.uid(), this.weights(), this.gaussians()), extra);
        return (GaussianMixtureModel)((Model)((Object)copied.setSummary(this.trainingSummary()))).setParent(this.parent());
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset outputData;
        block4: {
            StructType outputSchema = this.transformSchema(dataset.schema(), true);
            Column vectorCol = DatasetUtils$.MODULE$.columnToVector(dataset, this.$(this.featuresCol()));
            outputData = dataset;
            int numColsOutput = 0;
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.probabilityCol())))) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
                public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$1(GaussianMixtureModel $outer) {
                    }
                }
                public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator2$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator2$1(GaussianMixtureModel $outer) {
                    }
                }
                UserDefinedFunction probUDF = functions$.MODULE$.udf((Function1 & Serializable)vector -> this.predictProbability((org.apache.spark.ml.linalg.Vector)vector), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator2$1(null)));
                outputData = outputData.withColumn(this.$(this.probabilityCol()), probUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{vectorCol})), outputSchema.apply(this.$(this.probabilityCol())).metadata());
                ++numColsOutput;
            }
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.predictionCol())))) {
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.probabilityCol())))) {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
                    public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator3$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator3$1(GaussianMixtureModel $outer) {
                        }
                    }
                    UserDefinedFunction predUDF = functions$.MODULE$.udf((Function1 & Serializable)vector -> BoxesRunTime.boxToInteger((int)vector.argmax()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator3$1(null)));
                    outputData = outputData.withColumn(this.$(this.predictionCol()), predUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.probabilityCol()))})), outputSchema.apply(this.$(this.predictionCol())).metadata());
                } else {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
                    public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator4$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator4$1(GaussianMixtureModel $outer) {
                        }
                    }
                    UserDefinedFunction predUDF = functions$.MODULE$.udf((Function1 & Serializable)vector -> BoxesRunTime.boxToInteger((int)this.predict(vector)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator4$1(null)));
                    outputData = outputData.withColumn(this.$(this.predictionCol()), predUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{vectorCol})), outputSchema.apply(this.$(this.predictionCol())).metadata());
                }
                ++numColsOutput;
            }
            if (numColsOutput != false) break block4;
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ": GaussianMixtureModel.transform() does "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.UUID, this.uid())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"nothing because no output columns were set."}))).log((Seq)Nil$.MODULE$))));
        }
        return outputData.toDF();
    }

    @Override
    public StructType transformSchema(StructType schema) {
        StructType outputSchema;
        block1: {
            outputSchema = this.validateAndTransformSchema(schema);
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.predictionCol())))) {
                outputSchema = SchemaUtils$.MODULE$.updateNumValues(outputSchema, this.$(this.predictionCol()), this.weights().length);
            }
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.probabilityCol())))) break block1;
            outputSchema = SchemaUtils$.MODULE$.updateAttributeGroupSize(outputSchema, this.$(this.probabilityCol()), this.weights().length);
        }
        return outputSchema;
    }

    public int predict(org.apache.spark.ml.linalg.Vector features) {
        org.apache.spark.ml.linalg.Vector r = this.predictProbability(features);
        return r.argmax();
    }

    public org.apache.spark.ml.linalg.Vector predictProbability(org.apache.spark.ml.linalg.Vector features) {
        double[] probs = GaussianMixtureModel$.MODULE$.computeProbabilities(features, this.gaussians(), this.weights());
        return org.apache.spark.ml.linalg.Vectors$.MODULE$.dense(probs);
    }

    public Dataset<Row> gaussiansDF() {
        ArraySeq modelGaussians = ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.gaussians()), (Function1 & Serializable)gaussian -> new Tuple2((Object)Vectors$.MODULE$.fromML(gaussian.mean()), (Object)Matrices$.MODULE$.fromML(gaussian.cov())), ClassTag$.MODULE$.apply(Tuple2.class))).toImmutableArraySeq();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
        public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.mllib.linalg.Matrix").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$2(GaussianMixtureModel $outer) {
            }
        }
        return SparkSession$.MODULE$.builder().getOrCreate().createDataFrame((Seq)modelGaussians, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$2(null))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mean", "cov"}));
    }

    @Override
    public MLWriter write() {
        return new GaussianMixtureModelWriter(this);
    }

    @Override
    public String toString() {
        return "GaussianMixtureModel: uid=" + this.uid() + ", k=" + this.weights().length + ", numFeatures=" + this.numFeatures();
    }

    @Override
    public GaussianMixtureSummary summary() {
        return (GaussianMixtureSummary)HasTrainingSummary.summary$(this);
    }

    @Override
    public long estimatedSize() {
        return SizeEstimator$.MODULE$.estimate((Object)new Tuple2((Object)this.weights(), (Object)this.gaussians()));
    }

    public void createSummary(Dataset<Row> predictions, double logLikelihood, int iteration) {
        GaussianMixtureSummary summary = new GaussianMixtureSummary(predictions, this.$(this.predictionCol()), this.$(this.probabilityCol()), this.$(this.featuresCol()), BoxesRunTime.unboxToInt((Object)this.$(this.k())), logLikelihood, iteration);
        this.setSummary((Option<GaussianMixtureSummary>)new Some((Object)summary));
    }

    @Override
    public void saveSummary(String path) {
        public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$3(GaussianMixtureModel $outer) {
            }
        }
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
        ReadWriteUtils$.MODULE$.saveObjectToLocal(path, new Tuple2.mcDI.sp(this.summary().logLikelihood(), this.summary().numIter()), (Function2 & Serializable)(data, dos) -> {
            GaussianMixtureModel.$anonfun$saveSummary$1(data, dos);
            return BoxedUnit.UNIT;
        }, ClassTag$.MODULE$.apply(Tuple2.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$3(null)));
    }

    @Override
    public void loadSummary(String path, Dataset<Row> dataset) {
        double d;
        int numIter;
        block3: {
            Tuple2 tuple2;
            block2: {
                public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$4
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$4(GaussianMixtureModel $outer) {
                    }
                }
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
                tuple2 = (Tuple2)ReadWriteUtils$.MODULE$.loadObjectFromLocal(path, (Function1 & Serializable)dis -> {
                    double logLikelihood = dis.readDouble();
                    int numIter = dis.readInt();
                    return new Tuple2.mcDI.sp(logLikelihood, numIter);
                }, ClassTag$.MODULE$.apply(Tuple2.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$4(null)));
                if (tuple2 == null) break block2;
                double logLikelihood = tuple2._1$mcD$sp();
                numIter = tuple2._2$mcI$sp();
                if (!true) break block2;
                d = logLikelihood;
                if (true) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        int n = numIter;
        Tuple2.mcDI.sp sp2 = new Tuple2.mcDI.sp(d, n);
        double logLikelihood = sp2._1$mcD$sp();
        int numIter2 = sp2._2$mcI$sp();
        this.createSummary(dataset, logLikelihood, numIter2);
    }

    public static final /* synthetic */ void $anonfun$saveSummary$1(Tuple2 data, DataOutputStream dos) {
        dos.writeDouble(data._1$mcD$sp());
        dos.writeInt(data._2$mcI$sp());
    }

    public GaussianMixtureModel(String uid, double[] weights, MultivariateGaussian[] gaussians) {
        this.uid = uid;
        this.weights = weights;
        this.gaussians = gaussians;
        HasMaxIter.$init$(this);
        HasFeaturesCol.$init$(this);
        HasSeed.$init$(this);
        HasPredictionCol.$init$(this);
        HasWeightCol.$init$(this);
        HasProbabilityCol.$init$(this);
        HasTol.$init$(this);
        HasAggregationDepth.$init$(this);
        GaussianMixtureParams.$init$(this);
        MLWritable.$init$(this);
        HasTrainingSummary.$init$(this);
        Statics.releaseFence();
    }

    public GaussianMixtureModel() {
        this("", Array$.MODULE$.emptyDoubleArray(), (MultivariateGaussian[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(MultivariateGaussian.class)));
    }

    public static class Data
    implements Product,
    Serializable {
        private final double[] weights;
        private final Vector[] mus;
        private final Matrix[] sigmas;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public double[] weights() {
            return this.weights;
        }

        public Vector[] mus() {
            return this.mus;
        }

        public Matrix[] sigmas() {
            return this.sigmas;
        }

        public Data copy(double[] weights, Vector[] mus, Matrix[] sigmas) {
            return new Data(weights, mus, sigmas);
        }

        public double[] copy$default$1() {
            return this.weights();
        }

        public Vector[] copy$default$2() {
            return this.mus();
        }

        public Matrix[] copy$default$3() {
            return this.sigmas();
        }

        public String productPrefix() {
            return "Data";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.weights();
                }
                case 1: {
                    return this.mus();
                }
                case 2: {
                    return this.sigmas();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Data;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "weights";
                }
                case 1: {
                    return "mus";
                }
                case 2: {
                    return "sigmas";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 45109845, true);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Data)) return false;
            boolean bl = true;
            if (!bl) return false;
            Data data = (Data)x$1;
            if (this.weights() != data.weights()) return false;
            if (this.mus() != data.mus()) return false;
            if (this.sigmas() != data.sigmas()) return false;
            if (!data.canEqual(this)) return false;
            return true;
        }

        public Data(double[] weights, Vector[] mus, Matrix[] sigmas) {
            this.weights = weights;
            this.mus = mus;
            this.sigmas = sigmas;
            Product.$init$((Product)this);
        }
    }

    private static class GaussianMixtureModelReader
    extends MLReader<GaussianMixtureModel> {
        private final String className = GaussianMixtureModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public GaussianMixtureModel load(String path) {
            Data data;
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sparkSession(), this.className());
            String dataPath = new Path(path, "data").toString();
            if (BoxesRunTime.unboxToBoolean((Object)ReadWriteUtils$.MODULE$.localSavingModeState().get())) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModelReader.class.getClassLoader());
                public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$GaussianMixtureModelReader$$typecreator1$6
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.clustering.GaussianMixtureModel.Data").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_clustering_GaussianMixtureModel$GaussianMixtureModelReader$$typecreator1$6(GaussianMixtureModelReader $outer) {
                    }
                }
                data = (Data)ReadWriteUtils$.MODULE$.loadObjectFromLocal(dataPath, (Function1 & Serializable)dis -> GaussianMixtureModel$.MODULE$.deserializeData((DataInputStream)dis), ClassTag$.MODULE$.apply(Data.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$GaussianMixtureModelReader$$typecreator1$6(null)));
            } else {
                Row row = (Row)this.sparkSession().read().parquet(dataPath).select("weights", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mus", "sigmas"})).head();
                data = new Data((double[])row.getSeq(0).toArray((ClassTag)ClassTag$.MODULE$.Double()), (Vector[])row.getSeq(1).toArray(ClassTag$.MODULE$.apply(Vector.class)), (Matrix[])row.getSeq(2).toArray(ClassTag$.MODULE$.apply(Matrix.class)));
            }
            Data data2 = data;
            Predef$.MODULE$.require(data2.mus().length == data2.sigmas().length, (Function0 & Serializable)() -> "Length of Mu and Sigma array must match");
            Predef$.MODULE$.require(data2.mus().length == data2.weights().length, (Function0 & Serializable)() -> "Length of weight and Gaussian array must match");
            MultivariateGaussian[] gaussians = (MultivariateGaussian[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])data2.mus()), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])data2.sigmas()))), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Vector mu = (Vector)tuple2._1();
                    Matrix sigma = (Matrix)tuple2._2();
                    return new MultivariateGaussian(mu.asML(), sigma.asML());
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(MultivariateGaussian.class));
            GaussianMixtureModel model = new GaussianMixtureModel(metadata.uid(), data2.weights(), gaussians);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class GaussianMixtureModelWriter
    extends MLWriter {
        private final GaussianMixtureModel instance;

        @Override
        public void saveImpl(String path) {
            public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$GaussianMixtureModelWriter$$typecreator1$5
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.clustering.GaussianMixtureModel.Data").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_clustering_GaussianMixtureModel$GaussianMixtureModelWriter$$typecreator1$5(GaussianMixtureModelWriter $outer) {
                }
            }
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sparkSession());
            double[] weights = this.instance.weights();
            MultivariateGaussian[] gaussians = this.instance.gaussians();
            Vector[] mus = (Vector[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])gaussians), (Function1 & Serializable)g -> Vectors$.MODULE$.fromML(g.mean()), ClassTag$.MODULE$.apply(Vector.class));
            Matrix[] sigmas = (Matrix[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])gaussians), (Function1 & Serializable)c -> Matrices$.MODULE$.fromML(c.cov()), ClassTag$.MODULE$.apply(Matrix.class));
            Data data2 = new Data(weights, mus, sigmas);
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModelWriter.class.getClassLoader());
            ReadWriteUtils$.MODULE$.saveObject(dataPath, data2, this.sparkSession(), (Function2 & Serializable)(data, dos) -> {
                GaussianMixtureModel$.MODULE$.serializeData(data, dos);
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.apply(Data.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$GaussianMixtureModelWriter$$typecreator1$5(null)));
        }

        public GaussianMixtureModelWriter(GaussianMixtureModel instance) {
            this.instance = instance;
        }
    }
}

