/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.dmg.pmml.general_regression;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sparkproject.dmg.pmml.Extension;
import org.sparkproject.dmg.pmml.HasExtensions;
import org.sparkproject.dmg.pmml.LocalTransformations;
import org.sparkproject.dmg.pmml.MathContext;
import org.sparkproject.dmg.pmml.MiningFunction;
import org.sparkproject.dmg.pmml.MiningSchema;
import org.sparkproject.dmg.pmml.Model;
import org.sparkproject.dmg.pmml.ModelExplanation;
import org.sparkproject.dmg.pmml.ModelStats;
import org.sparkproject.dmg.pmml.ModelVerification;
import org.sparkproject.dmg.pmml.Output;
import org.sparkproject.dmg.pmml.PMMLObject;
import org.sparkproject.dmg.pmml.StringValue;
import org.sparkproject.dmg.pmml.Targets;
import org.sparkproject.dmg.pmml.Version;
import org.sparkproject.dmg.pmml.Visitor;
import org.sparkproject.dmg.pmml.VisitorAction;
import org.sparkproject.dmg.pmml.adapters.FieldNameAdapter;
import org.sparkproject.dmg.pmml.adapters.IntegerAdapter;
import org.sparkproject.dmg.pmml.adapters.ObjectAdapter;
import org.sparkproject.dmg.pmml.adapters.RealNumberAdapter;
import org.sparkproject.dmg.pmml.general_regression.BaseCumHazardTables;
import org.sparkproject.dmg.pmml.general_regression.CovariateList;
import org.sparkproject.dmg.pmml.general_regression.EventValues;
import org.sparkproject.dmg.pmml.general_regression.FactorList;
import org.sparkproject.dmg.pmml.general_regression.PCovMatrix;
import org.sparkproject.dmg.pmml.general_regression.PMMLAttributes;
import org.sparkproject.dmg.pmml.general_regression.PMMLElements;
import org.sparkproject.dmg.pmml.general_regression.PPMatrix;
import org.sparkproject.dmg.pmml.general_regression.ParamMatrix;
import org.sparkproject.dmg.pmml.general_regression.ParameterList;
import org.sparkproject.jpmml.model.MissingAttributeException;
import org.sparkproject.jpmml.model.MissingElementException;
import org.sparkproject.jpmml.model.annotations.Added;
import org.sparkproject.jpmml.model.annotations.CollectionElementType;
import org.sparkproject.jpmml.model.annotations.Deprecated;
import org.sparkproject.jpmml.model.annotations.Property;
import org.sparkproject.jpmml.model.annotations.Required;
import org.sparkproject.jpmml.model.annotations.Since;
import org.sparkproject.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="GeneralRegressionModel", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "parameterList", "factorList", "covariateList", "ppMatrix", "pCovMatrix", "paramMatrix", "eventValues", "baseCumHazardTables", "modelVerification"})
@JsonRootName(value="GeneralRegressionModel")
@JsonPropertyOrder(value={"targetVariable", "modelType", "modelName", "miningFunction", "algorithmName", "targetReferenceCategory", "cumulativeLinkFunction", "linkFunction", "linkParameter", "trialsVariable", "trialsValue", "distribution", "distParameter", "offsetVariable", "offsetValue", "modelDF", "endTimeVariable", "startTimeVariable", "subjectIDVariable", "statusVariable", "baselineStrataVariable", "scorable", "mathContext", "extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "parameterList", "factorList", "covariateList", "ppMatrix", "pCovMatrix", "paramMatrix", "eventValues", "baseCumHazardTables", "modelVerification"})
public class GeneralRegressionModel
extends Model
implements HasExtensions<GeneralRegressionModel> {
    @XmlAttribute(name="targetVariableName")
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @JsonProperty(value="targetVariableName")
    @Deprecated(value=Version.PMML_3_0)
    private String targetVariable;
    @XmlAttribute(name="modelType", required=true)
    @JsonProperty(value="modelType")
    private ModelType modelType;
    @XmlAttribute(name="modelName")
    @JsonProperty(value="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    @JsonProperty(value="functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name="algorithmName")
    @JsonProperty(value="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="targetReferenceCategory")
    @XmlJavaTypeAdapter(value=ObjectAdapter.class)
    @XmlSchemaType(name="anySimpleType")
    @JsonProperty(value="targetReferenceCategory")
    @Added(value=Version.PMML_4_0)
    private Object targetReferenceCategory;
    @XmlAttribute(name="cumulativeLink")
    @JsonProperty(value="cumulativeLink")
    @Added(value=Version.PMML_3_1)
    private CumulativeLinkFunction cumulativeLinkFunction;
    @XmlAttribute(name="linkFunction")
    @JsonProperty(value="linkFunction")
    @Added(value=Version.PMML_3_2)
    private LinkFunction linkFunction;
    @XmlAttribute(name="linkParameter")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="linkParameter")
    @Added(value=Version.PMML_3_2)
    private Number linkParameter;
    @XmlAttribute(name="trialsVariable")
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @JsonProperty(value="trialsVariable")
    @Added(value=Version.PMML_3_2)
    private String trialsVariable;
    @XmlAttribute(name="trialsValue")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    @JsonProperty(value="trialsValue")
    @Added(value=Version.PMML_3_2)
    private Integer trialsValue;
    @XmlAttribute(name="distribution")
    @JsonProperty(value="distribution")
    @Added(value=Version.PMML_3_2)
    private Distribution distribution;
    @XmlAttribute(name="distParameter")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="distParameter")
    @Added(value=Version.PMML_3_2)
    private Number distParameter;
    @XmlAttribute(name="offsetVariable")
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @JsonProperty(value="offsetVariable")
    @Added(value=Version.PMML_3_2)
    private String offsetVariable;
    @XmlAttribute(name="offsetValue")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="offsetValue")
    @Added(value=Version.PMML_3_2)
    private Number offsetValue;
    @XmlAttribute(name="modelDF")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="modelDF")
    @Added(value=Version.PMML_4_0)
    private Number modelDF;
    @XmlAttribute(name="endTimeVariable")
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @JsonProperty(value="endTimeVariable")
    @Added(value=Version.PMML_4_0)
    private String endTimeVariable;
    @XmlAttribute(name="startTimeVariable")
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @JsonProperty(value="startTimeVariable")
    @Added(value=Version.PMML_4_0)
    private String startTimeVariable;
    @XmlAttribute(name="subjectIDVariable")
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @JsonProperty(value="subjectIDVariable")
    @Added(value=Version.PMML_4_0)
    private String subjectIDVariable;
    @XmlAttribute(name="statusVariable")
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @JsonProperty(value="statusVariable")
    @Added(value=Version.PMML_4_0)
    private String statusVariable;
    @XmlAttribute(name="baselineStrataVariable")
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @JsonProperty(value="baselineStrataVariable")
    @Added(value=Version.PMML_4_0)
    private String baselineStrataVariable;
    @XmlAttribute(name="isScorable")
    @JsonProperty(value="isScorable")
    @Added(value=Version.PMML_4_1, removable=true)
    private Boolean scorable;
    @XmlAttribute(name="x-mathContext")
    @JsonProperty(value="x-mathContext")
    @Added(value=Version.XPMML, removable=true)
    @Since(value="1.3.7")
    private MathContext mathContext;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Output")
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelStats")
    private ModelStats modelStats;
    @XmlElement(name="ModelExplanation", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelExplanation")
    @Added(value=Version.PMML_4_0, removable=true)
    private ModelExplanation modelExplanation;
    @XmlElement(name="Targets", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Targets")
    private Targets targets;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name="ParameterList", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="ParameterList")
    private ParameterList parameterList;
    @XmlElement(name="FactorList", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="FactorList")
    private FactorList factorList;
    @XmlElement(name="CovariateList", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="CovariateList")
    private CovariateList covariateList;
    @XmlElement(name="PPMatrix", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="PPMatrix")
    @Required(value=Version.PMML_3_1)
    private PPMatrix ppMatrix;
    @XmlElement(name="PCovMatrix", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="PCovMatrix")
    private PCovMatrix pCovMatrix;
    @XmlElement(name="ParamMatrix", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="ParamMatrix")
    private ParamMatrix paramMatrix;
    @XmlElement(name="EventValues", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="EventValues")
    @Added(value=Version.PMML_4_0)
    private EventValues eventValues;
    @XmlElement(name="BaseCumHazardTables", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="BaseCumHazardTables")
    @Added(value=Version.PMML_4_0)
    private BaseCumHazardTables baseCumHazardTables;
    @XmlElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelVerification")
    private ModelVerification modelVerification;
    private static final Boolean DEFAULT_SCORABLE = true;
    private static final long serialVersionUID = 67371272L;

    public GeneralRegressionModel() {
    }

    @ValueConstructor
    public GeneralRegressionModel(@Property(value="modelType") ModelType modelType, @Property(value="miningFunction") MiningFunction miningFunction, @Property(value="miningSchema") MiningSchema miningSchema, @Property(value="parameterList") ParameterList parameterList, @Property(value="ppMatrix") PPMatrix ppMatrix, @Property(value="paramMatrix") ParamMatrix paramMatrix) {
        this.modelType = modelType;
        this.miningFunction = miningFunction;
        this.miningSchema = miningSchema;
        this.parameterList = parameterList;
        this.ppMatrix = ppMatrix;
        this.paramMatrix = paramMatrix;
    }

    public String getTargetVariable() {
        return this.targetVariable;
    }

    public GeneralRegressionModel setTargetVariable(@Property(value="targetVariable") String targetVariable) {
        this.targetVariable = targetVariable;
        return this;
    }

    public ModelType requireModelType() {
        if (this.modelType == null) {
            throw new MissingAttributeException(this, PMMLAttributes.GENERALREGRESSIONMODEL_MODELTYPE);
        }
        return this.modelType;
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    public GeneralRegressionModel setModelType(@Property(value="modelType") ModelType modelType) {
        this.modelType = modelType;
        return this;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public GeneralRegressionModel setModelName(@Property(value="modelName") String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction requireMiningFunction() {
        if (this.miningFunction == null) {
            throw new MissingAttributeException(this, PMMLAttributes.GENERALREGRESSIONMODEL_MININGFUNCTION);
        }
        return this.miningFunction;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return this.miningFunction;
    }

    @Override
    public GeneralRegressionModel setMiningFunction(@Property(value="miningFunction") MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public GeneralRegressionModel setAlgorithmName(@Property(value="algorithmName") String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Object getTargetReferenceCategory() {
        return this.targetReferenceCategory;
    }

    public GeneralRegressionModel setTargetReferenceCategory(@Property(value="targetReferenceCategory") Object targetReferenceCategory) {
        this.targetReferenceCategory = targetReferenceCategory;
        return this;
    }

    public CumulativeLinkFunction requireCumulativeLinkFunction() {
        if (this.cumulativeLinkFunction == null) {
            throw new MissingAttributeException(this, PMMLAttributes.GENERALREGRESSIONMODEL_CUMULATIVELINKFUNCTION);
        }
        return this.cumulativeLinkFunction;
    }

    public CumulativeLinkFunction getCumulativeLinkFunction() {
        return this.cumulativeLinkFunction;
    }

    public GeneralRegressionModel setCumulativeLinkFunction(@Property(value="cumulativeLinkFunction") CumulativeLinkFunction cumulativeLinkFunction) {
        this.cumulativeLinkFunction = cumulativeLinkFunction;
        return this;
    }

    public LinkFunction requireLinkFunction() {
        if (this.linkFunction == null) {
            throw new MissingAttributeException(this, PMMLAttributes.GENERALREGRESSIONMODEL_LINKFUNCTION);
        }
        return this.linkFunction;
    }

    public LinkFunction getLinkFunction() {
        return this.linkFunction;
    }

    public GeneralRegressionModel setLinkFunction(@Property(value="linkFunction") LinkFunction linkFunction) {
        this.linkFunction = linkFunction;
        return this;
    }

    public Number requireLinkParameter() {
        if (this.linkParameter == null) {
            throw new MissingAttributeException(this, PMMLAttributes.GENERALREGRESSIONMODEL_LINKPARAMETER);
        }
        return this.linkParameter;
    }

    public Number getLinkParameter() {
        return this.linkParameter;
    }

    public GeneralRegressionModel setLinkParameter(@Property(value="linkParameter") Number linkParameter) {
        this.linkParameter = linkParameter;
        return this;
    }

    public String getTrialsVariable() {
        return this.trialsVariable;
    }

    public GeneralRegressionModel setTrialsVariable(@Property(value="trialsVariable") String trialsVariable) {
        this.trialsVariable = trialsVariable;
        return this;
    }

    public Integer getTrialsValue() {
        return this.trialsValue;
    }

    public GeneralRegressionModel setTrialsValue(@Property(value="trialsValue") Integer trialsValue) {
        this.trialsValue = trialsValue;
        return this;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public GeneralRegressionModel setDistribution(@Property(value="distribution") Distribution distribution) {
        this.distribution = distribution;
        return this;
    }

    public Number requireDistParameter() {
        if (this.distParameter == null) {
            throw new MissingAttributeException(this, PMMLAttributes.GENERALREGRESSIONMODEL_DISTPARAMETER);
        }
        return this.distParameter;
    }

    public Number getDistParameter() {
        return this.distParameter;
    }

    public GeneralRegressionModel setDistParameter(@Property(value="distParameter") Number distParameter) {
        this.distParameter = distParameter;
        return this;
    }

    public String getOffsetVariable() {
        return this.offsetVariable;
    }

    public GeneralRegressionModel setOffsetVariable(@Property(value="offsetVariable") String offsetVariable) {
        this.offsetVariable = offsetVariable;
        return this;
    }

    public Number getOffsetValue() {
        return this.offsetValue;
    }

    public GeneralRegressionModel setOffsetValue(@Property(value="offsetValue") Number offsetValue) {
        this.offsetValue = offsetValue;
        return this;
    }

    public Number getModelDF() {
        return this.modelDF;
    }

    public GeneralRegressionModel setModelDF(@Property(value="modelDF") Number modelDF) {
        this.modelDF = modelDF;
        return this;
    }

    public String getEndTimeVariable() {
        return this.endTimeVariable;
    }

    public GeneralRegressionModel setEndTimeVariable(@Property(value="endTimeVariable") String endTimeVariable) {
        this.endTimeVariable = endTimeVariable;
        return this;
    }

    public String getStartTimeVariable() {
        return this.startTimeVariable;
    }

    public GeneralRegressionModel setStartTimeVariable(@Property(value="startTimeVariable") String startTimeVariable) {
        this.startTimeVariable = startTimeVariable;
        return this;
    }

    public String getSubjectIDVariable() {
        return this.subjectIDVariable;
    }

    public GeneralRegressionModel setSubjectIDVariable(@Property(value="subjectIDVariable") String subjectIDVariable) {
        this.subjectIDVariable = subjectIDVariable;
        return this;
    }

    public String getStatusVariable() {
        return this.statusVariable;
    }

    public GeneralRegressionModel setStatusVariable(@Property(value="statusVariable") String statusVariable) {
        this.statusVariable = statusVariable;
        return this;
    }

    public String getBaselineStrataVariable() {
        return this.baselineStrataVariable;
    }

    public GeneralRegressionModel setBaselineStrataVariable(@Property(value="baselineStrataVariable") String baselineStrataVariable) {
        this.baselineStrataVariable = baselineStrataVariable;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return DEFAULT_SCORABLE;
        }
        return this.scorable;
    }

    @Override
    public GeneralRegressionModel setScorable(@Property(value="scorable") Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public MathContext getMathContext() {
        if (this.mathContext == null) {
            return MathContext.DOUBLE;
        }
        return this.mathContext;
    }

    @Override
    public GeneralRegressionModel setMathContext(@Property(value="mathContext") MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public GeneralRegressionModel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public MiningSchema requireMiningSchema() {
        if (this.miningSchema == null) {
            throw new MissingElementException(this, PMMLElements.GENERALREGRESSIONMODEL_MININGSCHEMA);
        }
        return this.miningSchema;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public GeneralRegressionModel setMiningSchema(@Property(value="miningSchema") MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public GeneralRegressionModel setOutput(@Property(value="output") Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public GeneralRegressionModel setModelStats(@Property(value="modelStats") ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return this.modelExplanation;
    }

    @Override
    public GeneralRegressionModel setModelExplanation(@Property(value="modelExplanation") ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public Targets getTargets() {
        return this.targets;
    }

    @Override
    public GeneralRegressionModel setTargets(@Property(value="targets") Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public GeneralRegressionModel setLocalTransformations(@Property(value="localTransformations") LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public ParameterList requireParameterList() {
        if (this.parameterList == null) {
            throw new MissingElementException(this, PMMLElements.GENERALREGRESSIONMODEL_PARAMETERLIST);
        }
        return this.parameterList;
    }

    public ParameterList getParameterList() {
        return this.parameterList;
    }

    public GeneralRegressionModel setParameterList(@Property(value="parameterList") ParameterList parameterList) {
        this.parameterList = parameterList;
        return this;
    }

    public FactorList getFactorList() {
        return this.factorList;
    }

    public GeneralRegressionModel setFactorList(@Property(value="factorList") FactorList factorList) {
        this.factorList = factorList;
        return this;
    }

    public CovariateList getCovariateList() {
        return this.covariateList;
    }

    public GeneralRegressionModel setCovariateList(@Property(value="covariateList") CovariateList covariateList) {
        this.covariateList = covariateList;
        return this;
    }

    public PPMatrix requirePPMatrix() {
        if (this.ppMatrix == null) {
            throw new MissingElementException(this, PMMLElements.GENERALREGRESSIONMODEL_PPMATRIX);
        }
        return this.ppMatrix;
    }

    public PPMatrix getPPMatrix() {
        return this.ppMatrix;
    }

    public GeneralRegressionModel setPPMatrix(@Property(value="ppMatrix") PPMatrix ppMatrix) {
        this.ppMatrix = ppMatrix;
        return this;
    }

    public PCovMatrix getPCovMatrix() {
        return this.pCovMatrix;
    }

    public GeneralRegressionModel setPCovMatrix(@Property(value="pCovMatrix") PCovMatrix pCovMatrix) {
        this.pCovMatrix = pCovMatrix;
        return this;
    }

    public ParamMatrix requireParamMatrix() {
        if (this.paramMatrix == null) {
            throw new MissingElementException(this, PMMLElements.GENERALREGRESSIONMODEL_PARAMMATRIX);
        }
        return this.paramMatrix;
    }

    public ParamMatrix getParamMatrix() {
        return this.paramMatrix;
    }

    public GeneralRegressionModel setParamMatrix(@Property(value="paramMatrix") ParamMatrix paramMatrix) {
        this.paramMatrix = paramMatrix;
        return this;
    }

    public EventValues getEventValues() {
        return this.eventValues;
    }

    public GeneralRegressionModel setEventValues(@Property(value="eventValues") EventValues eventValues) {
        this.eventValues = eventValues;
        return this;
    }

    public BaseCumHazardTables requireBaseCumHazardTables() {
        if (this.baseCumHazardTables == null) {
            throw new MissingElementException(this, PMMLElements.GENERALREGRESSIONMODEL_BASECUMHAZARDTABLES);
        }
        return this.baseCumHazardTables;
    }

    public BaseCumHazardTables getBaseCumHazardTables() {
        return this.baseCumHazardTables;
    }

    public GeneralRegressionModel setBaseCumHazardTables(@Property(value="baseCumHazardTables") BaseCumHazardTables baseCumHazardTables) {
        this.baseCumHazardTables = baseCumHazardTables;
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    @Override
    public GeneralRegressionModel setModelVerification(@Property(value="modelVerification") ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getMiningSchema(), this.getOutput(), this.getModelStats(), this.getModelExplanation(), this.getTargets(), this.getLocalTransformations(), this.getParameterList(), this.getFactorList(), this.getCovariateList(), this.getPPMatrix(), this.getPCovMatrix(), this.getParamMatrix(), this.getEventValues(), this.getBaseCumHazardTables(), this.getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum ModelType implements StringValue<ModelType>
    {
        REGRESSION("regression"),
        GENERAL_LINEAR("generalLinear"),
        MULTINOMIAL_LOGISTIC("multinomialLogistic"),
        ORDINAL_MULTINOMIAL("ordinalMultinomial"),
        GENERALIZED_LINEAR("generalizedLinear"),
        COX_REGRESSION("CoxRegression");

        private final String value;

        private ModelType(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static ModelType fromValue(String v) {
            for (ModelType c : ModelType.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum LinkFunction implements StringValue<LinkFunction>
    {
        CLOGLOG("cloglog"),
        IDENTITY("identity"),
        LOG("log"),
        LOGC("logc"),
        LOGIT("logit"),
        LOGLOG("loglog"),
        NEGBIN("negbin"),
        ODDSPOWER("oddspower"),
        POWER("power"),
        PROBIT("probit");

        private final String value;

        private LinkFunction(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static LinkFunction fromValue(String v) {
            for (LinkFunction c : LinkFunction.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Distribution implements StringValue<Distribution>
    {
        BINOMIAL("binomial"),
        GAMMA("gamma"),
        IGAUSS("igauss"),
        NEGBIN("negbin"),
        NORMAL("normal"),
        POISSON("poisson"),
        TWEEDIE("tweedie");

        private final String value;

        private Distribution(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static Distribution fromValue(String v) {
            for (Distribution c : Distribution.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum CumulativeLinkFunction implements StringValue<CumulativeLinkFunction>
    {
        LOGIT("logit"),
        PROBIT("probit"),
        CLOGLOG("cloglog"),
        LOGLOG("loglog"),
        CAUCHIT("cauchit");

        private final String value;

        private CumulativeLinkFunction(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static CumulativeLinkFunction fromValue(String v) {
            for (CumulativeLinkFunction c : CumulativeLinkFunction.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

