/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.orc.OrcFile;
import org.apache.orc.Writer;
import org.apache.orc.mapred.OrcStruct;
import org.apache.orc.mapreduce.OrcMapreduceRecordWriter;
import org.apache.orc.mapreduce.OrcOutputFormat;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.orc.OrcSerializer;
import org.apache.spark.sql.execution.datasources.orc.OrcUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005A4Q\u0001D\u0007\u0001'mA\u0001\u0002\t\u0001\u0003\u0006\u0004%\tA\t\u0005\ta\u0001\u0011\t\u0011)A\u0005G!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0011!\t\u0005A!A!\u0002\u0013\u0011\u0005\"\u0002$\u0001\t\u00039\u0005B\u0002(\u0001A\u0003%q\nC\u0004S\u0001\t\u0007I\u0011B*\t\r\u0001\u0004\u0001\u0015!\u0003U\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u0015q\u0007\u0001\"\u0011p\u0005=y%oY(viB,Ho\u0016:ji\u0016\u0014(B\u0001\b\u0010\u0003\ry'o\u0019\u0006\u0003!E\t1\u0002Z1uCN|WO]2fg*\u0011!cE\u0001\nKb,7-\u001e;j_:T!\u0001F\u000b\u0002\u0007M\fHN\u0003\u0002\u0017/\u0005)1\u000f]1sW*\u0011\u0001$G\u0001\u0007CB\f7\r[3\u000b\u0003i\t1a\u001c:h'\t\u0001A\u0004\u0005\u0002\u001e=5\tq\"\u0003\u0002 \u001f\taq*\u001e;qkR<&/\u001b;fe\u0006!\u0001/\u0019;i\u0007\u0001)\u0012a\t\t\u0003I5r!!J\u0016\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!\n\u0013A\u0002\u001fs_>$hHC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013&\u0001\u0004Qe\u0016$WMZ\u0005\u0003]=\u0012aa\u0015;sS:<'B\u0001\u0017*\u0003\u0015\u0001\u0018\r\u001e5!\u0003)!\u0017\r^1TG\",W.\u0019\t\u0003gYj\u0011\u0001\u000e\u0006\u0003kM\tQ\u0001^=qKNL!a\u000e\u001b\u0003\u0015M#(/^2u)f\u0004X-A\u0004d_:$X\r\u001f;\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014!C7baJ,G-^2f\u0015\tqt#\u0001\u0004iC\u0012|w\u000e]\u0005\u0003\u0001n\u0012!\u0003V1tW\u0006#H/Z7qi\u000e{g\u000e^3yi\u0006I!-\u0019;dQNK'0\u001a\t\u0003\u0007\u0012k\u0011!K\u0005\u0003\u000b&\u00121!\u00138u\u0003\u0019a\u0014N\\5u}Q)\u0001JS&M\u001bB\u0011\u0011\nA\u0007\u0002\u001b!)\u0001E\u0002a\u0001G!)\u0011G\u0002a\u0001e!)\u0001H\u0002a\u0001s!)\u0011I\u0002a\u0001\u0005\u0006Q1/\u001a:jC2L'0\u001a:\u0011\u0005%\u0003\u0016BA)\u000e\u00055y%oY*fe&\fG.\u001b>fe\u0006a!/Z2pe\u0012<&/\u001b;feV\tA\u000bE\u0002V1jk\u0011A\u0016\u0006\u0003y]S!AD\f\n\u0005e3&\u0001G(sG6\u000b\u0007O]3ek\u000e,'+Z2pe\u0012<&/\u001b;feB\u00111LX\u0007\u00029*\u0011QlV\u0001\u0007[\u0006\u0004(/\u001a3\n\u0005}c&!C(sGN#(/^2u\u00035\u0011XmY8sI^\u0013\u0018\u000e^3sA\u0005)qO]5uKR\u00111M\u001a\t\u0003\u0007\u0012L!!Z\u0015\u0003\tUs\u0017\u000e\u001e\u0005\u0006O*\u0001\r\u0001[\u0001\u0004e><\bCA5m\u001b\u0005Q'BA6\u0014\u0003!\u0019\u0017\r^1msN$\u0018BA7k\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u000b\rdwn]3\u0015\u0003\r\u0004")
public class OrcOutputWriter
extends OutputWriter {
    private final String path;
    private final TaskAttemptContext context;
    private final OrcSerializer serializer;
    private final OrcMapreduceRecordWriter<OrcStruct> recordWriter;

    @Override
    public String path() {
        return this.path;
    }

    private OrcMapreduceRecordWriter<OrcStruct> recordWriter() {
        return this.recordWriter;
    }

    @Override
    public void write(InternalRow row) {
        this.recordWriter().write(NullWritable.get(), (Writable)this.serializer.serialize(row));
    }

    @Override
    public void close() {
        this.recordWriter().close(this.context);
    }

    public OrcOutputWriter(String path, StructType dataSchema, TaskAttemptContext context, int batchSize) {
        this.path = path;
        this.context = context;
        this.serializer = new OrcSerializer(dataSchema);
        OrcOutputFormat<OrcStruct> orcOutputFormat = new OrcOutputFormat<OrcStruct>(this){
            private final /* synthetic */ OrcOutputWriter $outer;

            public Path getDefaultWorkFile(TaskAttemptContext context, String extension) {
                return new Path(this.$outer.path());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        Path filename = orcOutputFormat.getDefaultWorkFile(context, ".orc");
        OrcFile.WriterOptions options = org.apache.orc.mapred.OrcOutputFormat.buildOptions((Configuration)context.getConfiguration());
        options.setSchema(OrcUtils$.MODULE$.orcTypeDescription((DataType)dataSchema));
        Writer writer = OrcFile.createWriter((Path)filename, (OrcFile.WriterOptions)options);
        OrcMapreduceRecordWriter recordWriter = new OrcMapreduceRecordWriter(writer, batchSize);
        OrcUtils$.MODULE$.addSparkVersionMetadata(writer);
        this.recordWriter = recordWriter;
    }
}

