/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Objects;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;

public class GetLocalDirsForExecutors
extends BlockTransferMessage {
    public final String appId;
    public final String[] execIds;

    public GetLocalDirsForExecutors(String appId, String[] execIds) {
        this.appId = appId;
        this.execIds = execIds;
    }

    @Override
    protected BlockTransferMessage.Type type() {
        return BlockTransferMessage.Type.GET_LOCAL_DIRS_FOR_EXECUTORS;
    }

    public int hashCode() {
        return Objects.hashCode(this.appId) * 41 + Arrays.hashCode(this.execIds);
    }

    public String toString() {
        return "GetLocalDirsForExecutors[appId=" + this.appId + ",execIds=" + Arrays.toString(this.execIds) + "]";
    }

    public boolean equals(Object other) {
        if (other instanceof GetLocalDirsForExecutors) {
            GetLocalDirsForExecutors o = (GetLocalDirsForExecutors)other;
            return this.appId.equals(o.appId) && Arrays.equals(this.execIds, o.execIds);
        }
        return false;
    }

    public int encodedLength() {
        return Encoders.Strings.encodedLength((String)this.appId) + Encoders.StringArrays.encodedLength((String[])this.execIds);
    }

    public void encode(ByteBuf buf) {
        Encoders.Strings.encode((ByteBuf)buf, (String)this.appId);
        Encoders.StringArrays.encode((ByteBuf)buf, (String[])this.execIds);
    }

    public static GetLocalDirsForExecutors decode(ByteBuf buf) {
        String appId = Encoders.Strings.decode((ByteBuf)buf);
        String[] execIds = Encoders.StringArrays.decode((ByteBuf)buf);
        return new GetLocalDirsForExecutors(appId, execIds);
    }
}

