/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.grpc;

import java.util.List;
import org.sparkproject.connect.grpc.CallbackMetricInstrument;
import org.sparkproject.connect.grpc.DoubleCounterMetricInstrument;
import org.sparkproject.connect.grpc.DoubleHistogramMetricInstrument;
import org.sparkproject.connect.grpc.Internal;
import org.sparkproject.connect.grpc.LongCounterMetricInstrument;
import org.sparkproject.connect.grpc.LongGaugeMetricInstrument;
import org.sparkproject.connect.grpc.LongHistogramMetricInstrument;
import org.sparkproject.connect.grpc.LongUpDownCounterMetricInstrument;
import org.sparkproject.guava.base.Preconditions;

@Internal
public interface MetricRecorder {
    default public void addDoubleCounter(DoubleCounterMetricInstrument metricInstrument, double value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        Preconditions.checkArgument((requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size() ? 1 : 0) != 0, (String)"Incorrect number of required labels provided. Expected: %s", (int)metricInstrument.getRequiredLabelKeys().size());
        Preconditions.checkArgument((optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size() ? 1 : 0) != 0, (String)"Incorrect number of optional labels provided. Expected: %s", (int)metricInstrument.getOptionalLabelKeys().size());
    }

    default public void addLongCounter(LongCounterMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        Preconditions.checkArgument((requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size() ? 1 : 0) != 0, (String)"Incorrect number of required labels provided. Expected: %s", (int)metricInstrument.getRequiredLabelKeys().size());
        Preconditions.checkArgument((optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size() ? 1 : 0) != 0, (String)"Incorrect number of optional labels provided. Expected: %s", (int)metricInstrument.getOptionalLabelKeys().size());
    }

    default public void addLongUpDownCounter(LongUpDownCounterMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        Preconditions.checkArgument((requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size() ? 1 : 0) != 0, (String)"Incorrect number of required labels provided. Expected: %s", (int)metricInstrument.getRequiredLabelKeys().size());
        Preconditions.checkArgument((optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size() ? 1 : 0) != 0, (String)"Incorrect number of optional labels provided. Expected: %s", (int)metricInstrument.getOptionalLabelKeys().size());
    }

    default public void recordDoubleHistogram(DoubleHistogramMetricInstrument metricInstrument, double value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        Preconditions.checkArgument((requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size() ? 1 : 0) != 0, (String)"Incorrect number of required labels provided. Expected: %s", (int)metricInstrument.getRequiredLabelKeys().size());
        Preconditions.checkArgument((optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size() ? 1 : 0) != 0, (String)"Incorrect number of optional labels provided. Expected: %s", (int)metricInstrument.getOptionalLabelKeys().size());
    }

    default public void recordLongHistogram(LongHistogramMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        Preconditions.checkArgument((requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size() ? 1 : 0) != 0, (String)"Incorrect number of required labels provided. Expected: %s", (int)metricInstrument.getRequiredLabelKeys().size());
        Preconditions.checkArgument((optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size() ? 1 : 0) != 0, (String)"Incorrect number of optional labels provided. Expected: %s", (int)metricInstrument.getOptionalLabelKeys().size());
    }

    default public Registration registerBatchCallback(BatchCallback callback, CallbackMetricInstrument ... metricInstruments) {
        return () -> {};
    }

    public static interface Registration
    extends AutoCloseable {
        @Override
        public void close();
    }

    public static interface BatchRecorder {
        default public void recordLongGauge(LongGaugeMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
            Preconditions.checkArgument((requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size() ? 1 : 0) != 0, (String)"Incorrect number of required labels provided. Expected: %s", (int)metricInstrument.getRequiredLabelKeys().size());
            Preconditions.checkArgument((optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size() ? 1 : 0) != 0, (String)"Incorrect number of optional labels provided. Expected: %s", (int)metricInstrument.getOptionalLabelKeys().size());
        }
    }

    public static interface BatchCallback {
        public void accept(BatchRecorder var1);
    }
}

