/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.collection.mutable;

import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.Function2;
import coursierapi.shaded.scala.PartialFunction;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.collection.AbstractIterator;
import coursierapi.shaded.scala.collection.IterableFactory;
import coursierapi.shaded.scala.collection.IterableOnce;
import coursierapi.shaded.scala.collection.Iterator;
import coursierapi.shaded.scala.collection.Iterator$;
import coursierapi.shaded.scala.collection.StrictOptimizedIterableOps;
import coursierapi.shaded.scala.collection.immutable.BitmapIndexedSetNode;
import coursierapi.shaded.scala.collection.immutable.SetNode;
import coursierapi.shaded.scala.collection.mutable.AbstractSet;
import coursierapi.shaded.scala.collection.mutable.Builder;
import coursierapi.shaded.scala.collection.mutable.Growable;
import coursierapi.shaded.scala.collection.mutable.HashSet$;
import coursierapi.shaded.scala.collection.mutable.LinkedHashSet;
import coursierapi.shaded.scala.runtime.BoxedUnit;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.Statics;
import coursierapi.shaded.scala.util.hashing.MurmurHash3$;
import java.io.Serializable;
import java.util.Arrays;

public final class HashSet<A>
extends AbstractSet<A>
implements Serializable,
StrictOptimizedIterableOps<A, HashSet, HashSet<A>> {
    private final double loadFactor;
    public Node<A>[] scala$collection$mutable$HashSet$$table;
    private int threshold;
    private int contentSize;

    @Override
    public Tuple2<HashSet<A>, HashSet<A>> partition(Function1<A, Object> p) {
        return StrictOptimizedIterableOps.partition$(this, p);
    }

    @Override
    public <A1, A2> Tuple2<HashSet<A1>, HashSet<A2>> unzip(Function1<A, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.unzip$(this, asPair);
    }

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public Object flatMap(Function1 f) {
        return StrictOptimizedIterableOps.flatMap$(this, f);
    }

    @Override
    public Object collect(PartialFunction pf) {
        return StrictOptimizedIterableOps.collect$(this, pf);
    }

    @Override
    public Object flatten(Function1 toIterableOnce) {
        return StrictOptimizedIterableOps.flatten$(this, toIterableOnce);
    }

    @Override
    public Object zip(IterableOnce that) {
        return StrictOptimizedIterableOps.zip$(this, that);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    @Override
    public Object dropRight(int n) {
        return StrictOptimizedIterableOps.dropRight$(this, n);
    }

    @Override
    public int size() {
        return this.contentSize;
    }

    @Override
    public boolean contains(A elem) {
        int findNode_scala$collection$mutable$HashSet$$computeHash_scala$collection$mutable$HashSet$$improveHash_originalHash = Statics.anyHash(elem);
        int findNode_hash = findNode_scala$collection$mutable$HashSet$$computeHash_scala$collection$mutable$HashSet$$improveHash_originalHash ^ findNode_scala$collection$mutable$HashSet$$computeHash_scala$collection$mutable$HashSet$$improveHash_originalHash >>> 16;
        Node<A> node = this.scala$collection$mutable$HashSet$$table[findNode_hash & this.scala$collection$mutable$HashSet$$table.length - 1];
        Node<A> node2 = node == null ? null : node.findNode(elem, findNode_hash);
        node = null;
        return node2 != null;
    }

    @Override
    public void sizeHint(int size) {
        int target = this.tableSizeFor((int)((double)(size + 1) / this.loadFactor));
        if (target > this.scala$collection$mutable$HashSet$$table.length) {
            this.growTable(target);
            return;
        }
    }

    @Override
    public boolean add(A elem) {
        if (this.contentSize + 1 >= this.threshold) {
            this.growTable(this.scala$collection$mutable$HashSet$$table.length * 2);
        }
        int scala$collection$mutable$HashSet$$computeHash_scala$collection$mutable$HashSet$$improveHash_originalHash = Statics.anyHash(elem);
        return this.addElem(elem, scala$collection$mutable$HashSet$$computeHash_scala$collection$mutable$HashSet$$improveHash_originalHash ^ scala$collection$mutable$HashSet$$computeHash_scala$collection$mutable$HashSet$$improveHash_originalHash >>> 16);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HashSet<A> addAll(IterableOnce<A> xs) {
        int sizeHint_delta = 0;
        Builder.sizeHint$(this, xs, sizeHint_delta);
        if (xs instanceof coursierapi.shaded.scala.collection.immutable.HashSet) {
            coursierapi.shaded.scala.collection.immutable.HashSet hashSet = (coursierapi.shaded.scala.collection.immutable.HashSet)xs;
            Function2<Object, Object, Object> & Serializable intersect = (Function2<Object, Object, Object> & Serializable)(k, h) -> {
                this.addElem(k, BoxesRunTime.unboxToInt(h) ^ BoxesRunTime.unboxToInt(h) >>> 16);
                return BoxedUnit.UNIT;
            };
            if (hashSet == null) {
                throw null;
            }
            BitmapIndexedSetNode bitmapIndexedSetNode = hashSet.rootNode();
            if (bitmapIndexedSetNode == null) {
                throw null;
            }
            BitmapIndexedSetNode foreachWithHash_foreachWithHash_this = bitmapIndexedSetNode;
            int foreachWithHash_foreachWithHash_iN = foreachWithHash_foreachWithHash_this.payloadArity();
            for (int foreachWithHash_foreachWithHash_i = 0; foreachWithHash_foreachWithHash_i < foreachWithHash_foreachWithHash_iN; ++foreachWithHash_foreachWithHash_i) {
                int n = foreachWithHash_foreachWithHash_this.originalHashes()[foreachWithHash_foreachWithHash_i];
                Object object = foreachWithHash_foreachWithHash_this.content()[foreachWithHash_foreachWithHash_i];
                this.addElem(object, n ^ n >>> 16);
            }
            int foreachWithHash_foreachWithHash_jN = foreachWithHash_foreachWithHash_this.nodeArity();
            for (int foreachWithHash_foreachWithHash_j = 0; foreachWithHash_foreachWithHash_j < foreachWithHash_foreachWithHash_jN; ++foreachWithHash_foreachWithHash_j) {
                void foreachWithHash_f;
                ((SetNode)foreachWithHash_foreachWithHash_this.getNode(foreachWithHash_foreachWithHash_j)).foreachWithHash(foreachWithHash_f);
            }
            return this;
        }
        if (xs instanceof HashSet) {
            HashSet hashSet = (HashSet)xs;
            if (hashSet == null) {
                throw null;
            }
            HashSetIterator iter = new HashSetIterator<Node<A>>(hashSet){

                public Node<A> extract(Node<A> nd) {
                    return nd;
                }
            };
            while (iter.hasNext()) {
                Node next = (Node)iter.next();
                this.addElem(next.key(), next.hash());
            }
            return this;
        }
        if (xs instanceof LinkedHashSet) {
            Iterator iter = ((LinkedHashSet)xs).entryIterator();
            while (iter.hasNext()) {
                LinkedHashSet.Entry next = iter.next();
                this.addElem(next.key(), next.hash());
            }
            return this;
        }
        return (HashSet)Growable.addAll$(this, xs);
    }

    private boolean addElem(A elem, int hash) {
        int idx = hash & this.scala$collection$mutable$HashSet$$table.length - 1;
        Node<A> node = this.scala$collection$mutable$HashSet$$table[idx];
        if (node == null) {
            this.scala$collection$mutable$HashSet$$table[idx] = new Node<A>(elem, hash, null);
        } else {
            Node<A> prev = null;
            for (Node<A> n = node; n != null && n.hash() <= hash; n = n.next()) {
                if (n.hash() == hash && BoxesRunTime.equals(elem, n.key())) {
                    return false;
                }
                prev = n;
            }
            if (prev == null) {
                this.scala$collection$mutable$HashSet$$table[idx] = new Node<A>(elem, hash, node);
            } else {
                prev.next_$eq(new Node<A>(elem, hash, prev.next()));
            }
        }
        ++this.contentSize;
        return true;
    }

    private boolean remove(A elem, int hash) {
        int idx = hash & this.scala$collection$mutable$HashSet$$table.length - 1;
        Node<A> node = this.scala$collection$mutable$HashSet$$table[idx];
        if (node == null) {
            return false;
        }
        if (node.hash() == hash && BoxesRunTime.equals(node.key(), elem)) {
            this.scala$collection$mutable$HashSet$$table[idx] = node.next();
            --this.contentSize;
            return true;
        }
        Node<A> prev = node;
        for (Node<A> next = node.next(); next != null && next.hash() <= hash; next = next.next()) {
            if (next.hash() == hash && BoxesRunTime.equals(next.key(), elem)) {
                prev.next_$eq(next.next());
                --this.contentSize;
                return true;
            }
            prev = next;
        }
        return false;
    }

    @Override
    public boolean remove(A elem) {
        int scala$collection$mutable$HashSet$$computeHash_scala$collection$mutable$HashSet$$improveHash_originalHash = Statics.anyHash(elem);
        return this.remove(elem, scala$collection$mutable$HashSet$$computeHash_scala$collection$mutable$HashSet$$improveHash_originalHash ^ scala$collection$mutable$HashSet$$computeHash_scala$collection$mutable$HashSet$$improveHash_originalHash >>> 16);
    }

    @Override
    public Iterator<A> iterator() {
        return new HashSetIterator<A>(this){

            public A extract(Node<A> nd) {
                return nd.key();
            }
        };
    }

    private void growTable(int newlen) {
        this.threshold = this.newThreshold(newlen);
        if (this.size() == 0) {
            this.scala$collection$mutable$HashSet$$table = new Node[newlen];
            return;
        }
        this.scala$collection$mutable$HashSet$$table = Arrays.copyOf(this.scala$collection$mutable$HashSet$$table, newlen);
        Node<Object> preLow = new Node<Object>(null, 0, null);
        Node<Object> preHigh = new Node<Object>(null, 0, null);
        for (int oldlen = this.scala$collection$mutable$HashSet$$table.length; oldlen < newlen; oldlen *= 2) {
            for (int i = 0; i < oldlen; ++i) {
                Node<A> old = this.scala$collection$mutable$HashSet$$table[i];
                if (old == null) continue;
                preLow.next_$eq(null);
                preHigh.next_$eq(null);
                Node<Object> lastLow = preLow;
                Node<Object> lastHigh = preHigh;
                Node<A> n = old;
                while (n != null) {
                    Node<A> next = n.next();
                    if ((n.hash() & oldlen) == 0) {
                        lastLow.next_$eq(n);
                        lastLow = n;
                    } else {
                        lastHigh.next_$eq(n);
                        lastHigh = n;
                    }
                    n = next;
                }
                lastLow.next_$eq(null);
                if (old != preLow.next()) {
                    this.scala$collection$mutable$HashSet$$table[i] = preLow.next();
                }
                if (preHigh.next() == null) continue;
                this.scala$collection$mutable$HashSet$$table[i + oldlen] = preHigh.next();
                lastHigh.next_$eq(null);
            }
        }
    }

    private int tableSizeFor(int capacity) {
        int n = capacity - 1;
        int max$extension_that = 4;
        int n2 = Integer.highestOneBit(Math.max(n, max$extension_that)) * 2;
        int min$extension_that = 0x40000000;
        return Math.min(n2, min$extension_that);
    }

    private int newThreshold(int size) {
        return (int)((double)size * this.loadFactor);
    }

    @Override
    public void clear() {
        Arrays.fill(this.scala$collection$mutable$HashSet$$table, null);
        this.contentSize = 0;
    }

    @Override
    public IterableFactory<HashSet> iterableFactory() {
        return HashSet$.MODULE$;
    }

    @Override
    public HashSet<A> addOne(A elem) {
        this.add(elem);
        return this;
    }

    @Override
    public HashSet<A> subtractOne(A elem) {
        this.remove(elem);
        return this;
    }

    @Override
    public int knownSize() {
        return this.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public <U> void foreach(Function1<A, U> f) {
        for (Node<A> n : this.scala$collection$mutable$HashSet$$table) {
            if (n == null) continue;
            n.foreach(f);
        }
    }

    @Override
    public String className() {
        return "HashSet";
    }

    @Override
    public int hashCode() {
        HashSetIterator setIterator = new /* invalid duplicate definition of identical inner class */;
        HashSetIterator<Object> hashIterator = setIterator.isEmpty() ? setIterator : new HashSetIterator<Object>(this){
            private int hash;
            private final /* synthetic */ HashSet $outer;

            private int hash() {
                return this.hash;
            }

            private void hash_$eq(int x$1) {
                this.hash = x$1;
            }

            public int hashCode() {
                return this.hash();
            }

            /*
             * WARNING - void declaration
             */
            public Object extract(Node<A> nd) {
                void unimproveHash_improvedHash;
                int n = nd.hash();
                if (this.$outer == null) {
                    throw null;
                }
                this.hash_$eq(unimproveHash_improvedHash ^ unimproveHash_improvedHash >>> 16);
                return this;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hash = 0;
            }
        };
        return MurmurHash3$.MODULE$.unorderedHash((IterableOnce<Object>)hashIterator, MurmurHash3$.MODULE$.setSeed());
    }

    public HashSet(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.scala$collection$mutable$HashSet$$table = new Node[this.tableSizeFor(initialCapacity)];
        this.threshold = this.newThreshold(this.scala$collection$mutable$HashSet$$table.length);
        this.contentSize = 0;
    }

    public HashSet() {
        this(16, 0.75);
    }

    private abstract class HashSetIterator<B>
    extends AbstractIterator<B> {
        private int i;
        private Node<A> node;
        private final int len;

        public abstract B extract(Node<A> var1);

        @Override
        public boolean hasNext() {
            if (this.node != null) {
                return true;
            }
            while (this.i < this.len) {
                Node n = this.scala$collection$mutable$HashSet$HashSetIterator$$$outer().scala$collection$mutable$HashSet$$table[this.i];
                ++this.i;
                if (n == null) continue;
                this.node = n;
                return true;
            }
            return false;
        }

        @Override
        public B next() {
            if (!this.hasNext()) {
                return (B)Iterator$.scala$collection$Iterator$$_empty.next();
            }
            B r = this.extract(this.node);
            this.node = this.node.next();
            return r;
        }

        public /* synthetic */ HashSet scala$collection$mutable$HashSet$HashSetIterator$$$outer() {
            return HashSet.this;
        }

        public HashSetIterator() {
            if (HashSet.this == null) {
                throw null;
            }
            this.i = 0;
            this.node = null;
            this.len = HashSet.this.scala$collection$mutable$HashSet$$table.length;
        }
    }

    public static final class Node<K> {
        private final K _key;
        private final int _hash;
        private Node<K> _next;

        public K key() {
            return this._key;
        }

        public int hash() {
            return this._hash;
        }

        public Node<K> next() {
            return this._next;
        }

        public void next_$eq(Node<K> n) {
            this._next = n;
        }

        public Node<K> findNode(K k, int h) {
            while (h != this_._hash || !BoxesRunTime.equals(k, this_._key)) {
                if (this_._next == null || this_._hash > h) {
                    return null;
                }
                Node<K> this_ = this_._next;
            }
            return this_;
        }

        public <U> void foreach(Function1<K, U> f) {
            while (true) {
                f.apply(this_._key);
                if (this_._next == null) break;
                Node<K> this_ = this_._next;
            }
        }

        public String toString() {
            return new StringBuilder(12).append("Node(").append(this.key()).append(", ").append(this.hash()).append(") -> ").append(this.next()).toString();
        }

        public Node(K _key, int _hash, Node<K> _next) {
            this._key = _key;
            this._hash = _hash;
            this._next = _next;
        }
    }
}

