/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.datastore;

import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.exceptions.NullValueException;
import org.datanucleus.store.rdbms.mapping.datastore.AbstractDatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class TinyIntRDBMSMapping
extends AbstractDatastoreMapping {
    public TinyIntRDBMSMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(storeMgr, mapping);
        this.column = col;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null) {
            Object[] validValues;
            this.column.checkPrimitive();
            if (this.getJavaTypeMapping() instanceof SingleFieldMapping && (validValues = ((SingleFieldMapping)this.getJavaTypeMapping()).getValidValues(0)) != null) {
                String constraints = this.storeMgr.getDatastoreAdapter().getCheckConstraintForValues(this.column.getIdentifier(), validValues, this.column.isNullable());
                this.column.setConstraints(constraints);
            }
            if (this.getJavaTypeMapping().getJavaType() == Boolean.class) {
                StringBuilder constraints = new StringBuilder("CHECK (" + this.column.getIdentifier() + " IN (0,1)");
                if (this.column.isNullable()) {
                    constraints.append(" OR " + this.column.getIdentifier() + " IS NULL");
                }
                constraints.append(')');
                this.column.setConstraints(constraints.toString());
            }
        }
        this.initTypeInfo();
    }

    @Override
    public boolean isIntegerBased() {
        return true;
    }

    @Override
    public int getJDBCType() {
        return -6;
    }

    @Override
    public SQLTypeInfo getTypeInfo() {
        if (this.column != null && this.column.getColumnMetaData().getSqlType() != null) {
            return this.storeMgr.getSQLTypeInfoForJDBCType(-6, this.column.getColumnMetaData().getSqlType());
        }
        return this.storeMgr.getSQLTypeInfoForJDBCType(-6);
    }

    @Override
    public void setBoolean(PreparedStatement ps, int param, boolean value) {
        try {
            ps.setInt(param, value ? 1 : 0);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"boolean", "" + value, this.column, e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public boolean getBoolean(ResultSet rs, int param) {
        boolean value;
        block4: {
            try {
                int intValue = rs.getInt(param);
                if (intValue == 0) {
                    value = false;
                    break block4;
                }
                if (intValue == 1) {
                    value = true;
                    break block4;
                }
                throw new NucleusDataStoreException(Localiser.msg((String)"055006", (Object[])new Object[]{"Types.TINYINT", "" + intValue}));
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"Boolean", "" + param, this.column, e.getMessage()}), (Throwable)e);
            }
        }
        return value;
    }

    @Override
    public void setInt(PreparedStatement ps, int param, int value) {
        try {
            ps.setInt(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"int", "" + value, this.column, e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public int getInt(ResultSet rs, int param) {
        int value;
        try {
            value = rs.getInt(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && rs.wasNull()) {
                throw new NullValueException(Localiser.msg((String)"055003", (Object[])new Object[]{this.column}));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"int", "" + param, this.column, e.getMessage()}), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setLong(PreparedStatement ps, int param, long value) {
        try {
            ps.setLong(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"int", "" + value, this.column, e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public long getLong(ResultSet rs, int param) {
        int value;
        try {
            value = rs.getInt(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && rs.wasNull()) {
                throw new NullValueException(Localiser.msg((String)"055003", (Object[])new Object[]{this.column}));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"int", "" + param, this.column, e.getMessage()}), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setByte(PreparedStatement ps, int param, byte value) {
        try {
            ps.setInt(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"byte", "" + value, this.column, e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public byte getByte(ResultSet rs, int param) {
        byte value;
        try {
            value = rs.getByte(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && rs.wasNull()) {
                throw new NullValueException(Localiser.msg((String)"055003", (Object[])new Object[]{this.column}));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"byte", "" + param, this.column, e.getMessage()}), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setObject(PreparedStatement ps, int param, Object value) {
        block8: {
            try {
                if (value == null) {
                    if (this.column != null && this.column.isDefaultable() && this.column.getDefaultValue() != null && !StringUtils.isWhitespace((String)this.column.getDefaultValue().toString())) {
                        ps.setInt(param, Integer.valueOf(this.column.getDefaultValue().toString()));
                    } else {
                        ps.setNull(param, this.getTypeInfo().getDataType());
                    }
                    break block8;
                }
                if (value instanceof Byte) {
                    ps.setInt(param, ((Byte)value).shortValue());
                    break block8;
                }
                if (value instanceof BigInteger) {
                    ps.setInt(param, ((BigInteger)value).shortValue());
                    break block8;
                }
                if (value instanceof Boolean) {
                    ps.setInt(param, (Boolean)value != false ? 1 : 0);
                    break block8;
                }
                throw new NucleusException("TinyIntRDBMSMapping.setObject called for " + StringUtils.toJVMIDString((Object)value) + " but not supported");
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"Byte", "" + value, this.column, e.getMessage()}), (Throwable)e);
            }
        }
    }

    @Override
    public Object getObject(ResultSet rs, int param) {
        Comparable<BigInteger> value;
        try {
            int d = rs.getInt(param);
            value = this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_MATH_BIGINTEGER) ? (rs.wasNull() ? null : BigInteger.valueOf(d)) : (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_BOOLEAN) ? (Comparable<Boolean>)(rs.wasNull() ? null : (d == 1 ? Boolean.TRUE : Boolean.FALSE)) : (Comparable<Boolean>)(rs.wasNull() ? null : Byte.valueOf(rs.getByte(param))));
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"Byte", "" + param, this.column, e.getMessage()}), (Throwable)e);
        }
        return value;
    }
}

