/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringSplit$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.CollationSupport;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.types.StringTypeBinaryLcase$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(str, regex, limit) - Splits `str` around occurrences that match `regex` and returns an array with a length of at most `limit`", arguments="\n    Arguments:\n      * str - a string expression to split.\n      * regex - a string representing a regular expression. The regex string should be a\n        Java regular expression.\n      * limit - an integer expression which controls the number of times the regex is applied.\n          * limit > 0: The resulting array's length will not be more than `limit`,\n            and the resulting array's last entry will contain all input\n            beyond the last matched regex.\n          * limit <= 0: `regex` will be applied as many times as possible, and\n            the resulting array can be of any size.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('oneAtwoBthreeC', '[ABC]');\n       [\"one\",\"two\",\"three\",\"\"]\n      > SELECT _FUNC_('oneAtwoBthreeC', '[ABC]', -1);\n       [\"one\",\"two\",\"three\",\"\"]\n      > SELECT _FUNC_('oneAtwoBthreeC', '[ABC]', 2);\n       [\"one\",\"twoBthreeC\"]\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t-b\u0001B\u0014)\u0001VB\u0001b\u0014\u0001\u0003\u0016\u0004%\t\u0001\u0015\u0005\t)\u0002\u0011\t\u0012)A\u0005#\"AQ\u000b\u0001BK\u0002\u0013\u0005\u0001\u000b\u0003\u0005W\u0001\tE\t\u0015!\u0003R\u0011!9\u0006A!f\u0001\n\u0003\u0001\u0006\u0002\u0003-\u0001\u0005#\u0005\u000b\u0011B)\t\u000be\u0003A\u0011\u0001.\t\u000b}\u0003A\u0011\t1\t\u000b\u0011\u0004A\u0011I3\t\u000b1\u0004A\u0011I7\t\u000bQ\u0004A\u0011\t)\t\u000bU\u0004A\u0011\t)\t\u000bY\u0004A\u0011\t)\t\u0011]\u0004\u0001R1A\u0005\u0006aD\u0001\u0002 \u0001\t\u0006\u0004%I\u0001\u0019\u0005\u00063\u0002!\t! \u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u0011\u001d\t)\u0002\u0001C!\u0003/Aq!a\r\u0001\t\u0003\n)\u0004C\u0004\u0002H\u0001!\t&!\u0013\t\u0013\u0005]\u0003!!A\u0005\u0002\u0005e\u0003\"CA1\u0001E\u0005I\u0011AA2\u0011%\tI\bAI\u0001\n\u0003\t\u0019\u0007C\u0005\u0002|\u0001\t\n\u0011\"\u0001\u0002d!I\u0011Q\u0010\u0001\u0002\u0002\u0013\u0005\u0013q\u0010\u0005\t\u0003\u001f\u0003\u0011\u0011!C\u0001q\"I\u0011\u0011\u0013\u0001\u0002\u0002\u0013\u0005\u00111\u0013\u0005\n\u00033\u0003\u0011\u0011!C!\u00037C\u0011\"!+\u0001\u0003\u0003%\t!a+\t\u0013\u0005=\u0006!!A\u0005B\u0005E\u0006\"CA[\u0001\u0005\u0005I\u0011IA\\\u000f%\t\t\u000fKA\u0001\u0012\u0003\t\u0019O\u0002\u0005(Q\u0005\u0005\t\u0012AAs\u0011\u0019I\u0016\u0005\"\u0001\u0002~\"I\u0011q`\u0011\u0002\u0002\u0013\u0015#\u0011\u0001\u0005\n\u0005\u0007\t\u0013\u0011!CA\u0005\u000bA\u0011B!\u0004\"\u0003\u0003%\tIa\u0004\t\u0013\t\u0005\u0012%!A\u0005\n\t\r\"aC*ue&twm\u00159mSRT!!\u000b\u0016\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003W1\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003[9\n1a]9m\u0015\ty\u0003'A\u0003ta\u0006\u00148N\u0003\u00022e\u00051\u0011\r]1dQ\u0016T\u0011aM\u0001\u0004_J<7\u0001A\n\u0006\u0001YRTh\u0011\t\u0003oaj\u0011\u0001K\u0005\u0003s!\u0012\u0011\u0003V3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t94(\u0003\u0002=Q\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002?\u00036\tqHC\u0001A\u0003\u0015\u00198-\u00197b\u0013\t\u0011uHA\u0004Qe>$Wo\u0019;\u0011\u0005\u0011ceBA#K\u001d\t1\u0015*D\u0001H\u0015\tAE'\u0001\u0004=e>|GOP\u0005\u0002\u0001&\u00111jP\u0001\ba\u0006\u001c7.Y4f\u0013\tieJ\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002L\u007f\u0005\u00191\u000f\u001e:\u0016\u0003E\u0003\"a\u000e*\n\u0005MC#AC#yaJ,7o]5p]\u0006!1\u000f\u001e:!\u0003\u0015\u0011XmZ3y\u0003\u0019\u0011XmZ3yA\u0005)A.[7ji\u00061A.[7ji\u0002\na\u0001P5oSRtD\u0003B.];z\u0003\"a\u000e\u0001\t\u000b=;\u0001\u0019A)\t\u000bU;\u0001\u0019A)\t\u000b];\u0001\u0019A)\u0002\u001d9,H\u000e\\%oi>dWM]1oiV\t\u0011\r\u0005\u0002?E&\u00111m\u0010\u0002\b\u0005>|G.Z1o\u0003!!\u0017\r^1UsB,W#\u00014\u0011\u0005\u001dTW\"\u00015\u000b\u0005%d\u0013!\u0002;za\u0016\u001c\u0018BA6i\u0005!!\u0015\r^1UsB,\u0017AC5oaV$H+\u001f9fgV\ta\u000eE\u0002E_FL!\u0001\u001d(\u0003\u0007M+\u0017\u000f\u0005\u0002he&\u00111\u000f\u001b\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\fQAZ5sgR\faa]3d_:$\u0017!\u0002;iSJ$\u0017aC2pY2\fG/[8o\u0013\u0012,\u0012!\u001f\t\u0003}iL!a_ \u0003\u0007%sG/A\nmK\u001e\f7-_*qY&$HK];oG\u0006$X\r\u0006\u0003\\}\u0006\u0005\u0001\"B@\u0011\u0001\u0004\t\u0016aA3ya\")Q\u000b\u0005a\u0001#\u0006aa.\u001e7m'\u00064W-\u0012<bYRA\u0011qAA\u0007\u0003#\t\u0019\u0002E\u0002?\u0003\u0013I1!a\u0003@\u0005\r\te.\u001f\u0005\b\u0003\u001f\t\u0002\u0019AA\u0004\u0003\u0019\u0019HO]5oO\"1Q+\u0005a\u0001\u0003\u000fAaaV\tA\u0002\u0005\u001d\u0011!\u00033p\u000f\u0016t7i\u001c3f)\u0019\tI\"!\n\u00020A!\u00111DA\u0011\u001b\t\tiBC\u0002\u0002 !\nqaY8eK\u001e,g.\u0003\u0003\u0002$\u0005u!\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005\u001d\"\u00031\u0001\u0002*\u0005\u00191\r\u001e=\u0011\t\u0005m\u00111F\u0005\u0005\u0003[\tiB\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005E\"\u00031\u0001\u0002\u001a\u0005\u0011QM^\u0001\u000baJ,G\u000f^=OC6,WCAA\u001c!\u0011\tI$!\u0011\u000f\t\u0005m\u0012Q\b\t\u0003\r~J1!a\u0010@\u0003\u0019\u0001&/\u001a3fM&!\u00111IA#\u0005\u0019\u0019FO]5oO*\u0019\u0011qH \u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGcB.\u0002L\u0005=\u00131\u000b\u0005\u0007\u0003\u001b\"\u0002\u0019A)\u0002\u00119,wOR5sgRDa!!\u0015\u0015\u0001\u0004\t\u0016!\u00038foN+7m\u001c8e\u0011\u0019\t)\u0006\u0006a\u0001#\u0006Aa.Z<UQ&\u0014H-\u0001\u0003d_BLHcB.\u0002\\\u0005u\u0013q\f\u0005\b\u001fV\u0001\n\u00111\u0001R\u0011\u001d)V\u0003%AA\u0002ECqaV\u000b\u0011\u0002\u0003\u0007\u0011+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0015$fA)\u0002h-\u0012\u0011\u0011\u000e\t\u0005\u0003W\n)(\u0004\u0002\u0002n)!\u0011qNA9\u0003%)hn\u00195fG.,GMC\u0002\u0002t}\n!\"\u00198o_R\fG/[8o\u0013\u0011\t9(!\u001c\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!!\u0011\t\u0005\r\u0015QR\u0007\u0003\u0003\u000bSA!a\"\u0002\n\u0006!A.\u00198h\u0015\t\tY)\u0001\u0003kCZ\f\u0017\u0002BA\"\u0003\u000b\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\b\u0005U\u0005\u0002CAL7\u0005\u0005\t\u0019A=\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\n\u0005\u0004\u0002 \u0006\u0015\u0016qA\u0007\u0003\u0003CS1!a)@\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003O\u000b\tK\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA1\u0002.\"I\u0011qS\u000f\u0002\u0002\u0003\u0007\u0011qA\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\u0002\u0006M\u0006\u0002CAL=\u0005\u0005\t\u0019A=\u0002\r\u0015\fX/\u00197t)\r\t\u0017\u0011\u0018\u0005\n\u0003/{\u0012\u0011!a\u0001\u0003\u000fAs\u0003AA_\u0003\u0007\f)-!3\u0002L\u0006=\u0017\u0011[Ak\u0003/\fY.!8\u0011\u0007]\ny,C\u0002\u0002B\"\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002H\u0006\tIa\u0018$V\u001d\u000e{\u0006f\u001d;sY\u0001\u0012XmZ3yY\u0001b\u0017.\\5uS\u0001j\u0003e\u00159mSR\u001c\b\u0005Y:ue\u0002\u0004\u0013M]8v]\u0012\u0004snY2veJ,gnY3tAQD\u0017\r\u001e\u0011nCR\u001c\u0007\u000e\t1sK\u001e,\u0007\u0010\u0019\u0011b]\u0012\u0004#/\u001a;ve:\u001c\b%\u00198!CJ\u0014\u0018-\u001f\u0011xSRD\u0007%\u0019\u0011mK:<G\u000f\u001b\u0011pM\u0002\nG\u000fI7pgR\u0004\u0003\r\\5nSR\u0004\u0017!C1sOVlWM\u001c;tC\t\ti-\u0001Ca\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u00023\u000f\u001e:![\u0001\n\u0007e\u001d;sS:<\u0007%\u001a=qe\u0016\u001c8/[8oAQ|\u0007e\u001d9mSRt#\u0002\t\u0011!A\u0001\u0002#\u0006\t:fO\u0016D\b%\f\u0011bAM$(/\u001b8hAI,\u0007O]3tK:$\u0018N\\4!C\u0002\u0012XmZ;mCJ\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/AQCW\r\t:fO\u0016D\be\u001d;sS:<\u0007e\u001d5pk2$\u0007EY3!C*\u0001\u0003\u0005\t\u0011!A\u0001\u0002#*\u0019<bAI,w-\u001e7be\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+A1LW.\u001b;![\u0001\ng\u000eI5oi\u0016<WM\u001d\u0011fqB\u0014Xm]:j_:\u0004s\u000f[5dQ\u0002\u001awN\u001c;s_2\u001c\b\u0005\u001e5fA9,XNY3sA=4\u0007\u0005^5nKN\u0004C\u000f[3!e\u0016<W\r\u001f\u0011jg\u0002\n\u0007\u000f\u001d7jK\u0012t#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!U\u0001b\u0017.\\5uAy\u0002\u0003G\u000f\u0011UQ\u0016\u0004#/Z:vYRLgn\u001a\u0011beJ\f\u0017pJ:!Y\u0016tw\r\u001e5!o&dG\u000e\t8pi\u0002\u0012W\rI7pe\u0016\u0004C\u000f[1oA\u0001d\u0017.\\5uA2R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0005tG\r\t;iK\u0002\u0012Xm];mi&tw\rI1se\u0006Lxe\u001d\u0011mCN$\b%\u001a8uef\u0004s/\u001b7mA\r|g\u000e^1j]\u0002\nG\u000e\u001c\u0011j]B,HO\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002#-Z=p]\u0012\u0004C\u000f[3!Y\u0006\u001cH\u000fI7bi\u000eDW\r\u001a\u0011sK\u001e,\u0007P\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001R\u0003\u0005\\5nSR\u0004C(\u0010\u00111u\u0001\u0002'/Z4fq\u0002\u0004s/\u001b7mA\t,\u0007%\u00199qY&,G\rI1tA5\fg.\u001f\u0011uS6,7\u000fI1tAA|7o]5cY\u0016d\u0003%\u00198e\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011uQ\u0016\u0004#/Z:vYRLgn\u001a\u0011beJ\f\u0017\u0010I2b]\u0002\u0012W\rI8gA\u0005t\u0017\u0010I:ju\u0016t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a5\u0002\u0005+Q\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ8oK\u0006#xo\u001c\"uQJ,WmQ\u0014-A\u001dZ\u0016IQ\"^O%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u0017\u0012p]\u0016\u0014CF\t;x_\nb#\u0005\u001e5sK\u0016\u0014CF\t\u0012^\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":sN\\3Bi^|'\t\u001e5sK\u0016\u001cu\u0005\f\u0011(7\u0006\u00135)X\u0014-A5\n\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\E=tWM\t\u0017#i^|'\u0005\f\u0012uQJ,WM\t\u0017#EuS\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ8oK\u0006#xo\u001c\"uQJ,WmQ\u0014-A\u001dZ\u0016IQ\"^O1\u0002#'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7\nzg.\u001a\u0012-EQ<xN\u0011;ie\u0016,7II/\u000bA\u0001\nQa]5oG\u0016\f#!!7\u0002\u000bErSG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005}\u0017\u0001D:ue&twm\u00184v]\u000e\u001c\u0018aC*ue&twm\u00159mSR\u0004\"aN\u0011\u0014\u000b\u0005\n9/a=\u0011\u0011\u0005%\u0018q^)R#nk!!a;\u000b\u0007\u00055x(A\u0004sk:$\u0018.\\3\n\t\u0005E\u00181\u001e\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004\u0003BA{\u0003wl!!a>\u000b\t\u0005e\u0018\u0011R\u0001\u0003S>L1!TA|)\t\t\u0019/\u0001\u0005u_N#(/\u001b8h)\t\t\t)A\u0003baBd\u0017\u0010F\u0004\\\u0005\u000f\u0011IAa\u0003\t\u000b=#\u0003\u0019A)\t\u000bU#\u0003\u0019A)\t\u000b]#\u0003\u0019A)\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u0003B\u000f!\u0015q$1\u0003B\f\u0013\r\u0011)b\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\ry\u0012I\"U)R\u0013\r\u0011Yb\u0010\u0002\u0007)V\u0004H.Z\u001a\t\u0011\t}Q%!AA\u0002m\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011)\u0003\u0005\u0003\u0002\u0004\n\u001d\u0012\u0002\u0002B\u0015\u0003\u000b\u0013aa\u00142kK\u000e$\b")
public class StringSplit
extends TernaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private int collationId;
    private boolean legacySplitTruncate;
    private final Expression str;
    private final Expression regex;
    private final Expression limit;
    private volatile byte bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringSplit x$0) {
        return StringSplit$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringSplit> tupled() {
        return StringSplit$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringSplit>>> curried() {
        return StringSplit$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression regex() {
        return this.regex;
    }

    public Expression limit() {
        return this.limit;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public DataType dataType() {
        return new ArrayType(this.str().dataType(), false);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeBinaryLcase$.MODULE$, (List)new .colon.colon((Object)StringTypeWithCollation$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public Expression first() {
        return this.str();
    }

    @Override
    public Expression second() {
        return this.regex();
    }

    @Override
    public Expression third() {
        return this.limit();
    }

    private int collationId$lzycompute() {
        StringSplit stringSplit = this;
        synchronized (stringSplit) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.collationId = ((StringType)this.str().dataType()).collationId();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.collationId;
    }

    public final int collationId() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    private boolean legacySplitTruncate$lzycompute() {
        StringSplit stringSplit = this;
        synchronized (stringSplit) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.legacySplitTruncate = BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_TRUNCATE_FOR_EMPTY_REGEX_SPLIT()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.legacySplitTruncate;
    }

    private boolean legacySplitTruncate() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.legacySplitTruncate$lzycompute();
        }
        return this.legacySplitTruncate;
    }

    @Override
    public Object nullSafeEval(Object string, Object regex, Object limit) {
        UTF8String pattern = CollationSupport.collationAwareRegex((UTF8String)((UTF8String)regex), (int)this.collationId(), (boolean)this.legacySplitTruncate());
        UTF8String[] strings = this.legacySplitTruncate() ? ((UTF8String)string).splitLegacyTruncate(pattern, BoxesRunTime.unboxToInt((Object)limit)) : ((UTF8String)string).split(pattern, BoxesRunTime.unboxToInt((Object)limit));
        return new GenericArrayData(strings);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String arrayClass = GenericArrayData.class.getName();
        String pattern = ctx.freshName("pattern");
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(str, regex, limit) -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |UTF8String " + pattern + " =\n         |  CollationSupport.collationAwareRegex(" + regex + ", " + this.collationId() + ", " + this.legacySplitTruncate() + ");\n         |" + ev.value() + " = new " + arrayClass + "(" + this.legacySplitTruncate() + " ?\n         |  " + str + ".splitLegacyTruncate(" + pattern + ", " + limit + ") : " + str + ".split(" + pattern + ", " + limit + "));\n         |")));
    }

    @Override
    public String prettyName() {
        return "split";
    }

    @Override
    public StringSplit withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public StringSplit copy(Expression str, Expression regex, Expression limit) {
        return new StringSplit(str, regex, limit);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.regex();
    }

    public Expression copy$default$3() {
        return this.limit();
    }

    @Override
    public String productPrefix() {
        return "StringSplit";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.str();
            }
            case 1: {
                return this.regex();
            }
            case 2: {
                return this.limit();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringSplit;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "str";
            }
            case 1: {
                return "regex";
            }
            case 2: {
                return "limit";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringSplit)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringSplit stringSplit = (StringSplit)x$1;
        Expression expression = this.str();
        Expression expression2 = stringSplit.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regex();
        Expression expression4 = stringSplit.regex();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.limit();
        Expression expression6 = stringSplit.limit();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringSplit.canEqual(this)) return false;
        return true;
    }

    public StringSplit(Expression str, Expression regex, Expression limit) {
        this.str = str;
        this.regex = regex;
        this.limit = limit;
        ExpectsInputTypes.$init$(this);
    }

    public StringSplit(Expression exp, Expression regex) {
        this(exp, regex, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)-1)));
    }
}

