/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.sinks;

import java.io.Serializable;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.runtime.CompactibleFileStreamLog;
import org.apache.spark.sql.execution.streaming.sinks.FileStreamSinkLog$;
import org.apache.spark.sql.execution.streaming.sinks.SinkFileStatus;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005]a\u0001B\f\u0019\u0001\u001dB\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\ts\u0001\u0011\t\u0011)A\u0005u!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u001dA\u0006A1A\u0005ReCaA\u0017\u0001!\u0002\u0013q\u0005bB.\u0001\u0005\u0004%\t\u0006\u0018\u0005\u0007A\u0002\u0001\u000b\u0011B/\t\u000f\u0005\u0004!\u0019!C)E\"11\r\u0001Q\u0001\nMBq\u0001\u001a\u0001C\u0002\u0013\u0005\u0011\f\u0003\u0004f\u0001\u0001\u0006IA\u0014\u0005\u0006M\u0002!\teZ\u0004\u0006YbA\t!\u001c\u0004\u0006/aA\tA\u001c\u0005\u0006#B!\tA\u001d\u0005\bgB\u0011\r\u0011\"\u0001c\u0011\u0019!\b\u0003)A\u0005g!9Q\u000f\u0005b\u0001\n\u00031\bB\u0002@\u0011A\u0003%q\u000f\u0003\u0005\u0000!E\u0005I\u0011AA\u0001\u0005E1\u0015\u000e\\3TiJ,\u0017-\\*j].dun\u001a\u0006\u00033i\tQa]5oWNT!a\u0007\u000f\u0002\u0013M$(/Z1nS:<'BA\u000f\u001f\u0003%)\u00070Z2vi&|gN\u0003\u0002 A\u0005\u00191/\u001d7\u000b\u0005\u0005\u0012\u0013!B:qCJ\\'BA\u0012%\u0003\u0019\t\u0007/Y2iK*\tQ%A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001QA\u0019\u0011\u0006\f\u0018\u000e\u0003)R!a\u000b\u000e\u0002\u000fI,h\u000e^5nK&\u0011QF\u000b\u0002\u0019\u0007>l\u0007/Y2uS\ndWMR5mKN#(/Z1n\u0019><\u0007CA\u00181\u001b\u0005A\u0012BA\u0019\u0019\u00059\u0019\u0016N\\6GS2,7\u000b^1ukN\f!#\\3uC\u0012\fG/\u0019'pOZ+'o]5p]B\u0011AgN\u0007\u0002k)\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\t\u0019\u0011J\u001c;\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005mbT\"\u0001\u0010\n\u0005ur\"\u0001D*qCJ\\7+Z:tS>t\u0017\u0001\u00029bi\"\u0004\"\u0001Q$\u000f\u0005\u0005+\u0005C\u0001\"6\u001b\u0005\u0019%B\u0001#'\u0003\u0019a$o\\8u}%\u0011a)N\u0001\u0007!J,G-\u001a4\n\u0005!K%AB*ue&twM\u0003\u0002Gk\u0005aqL]3uK:$\u0018n\u001c8NgB\u0019A\u0007\u0014(\n\u00055+$AB(qi&|g\u000e\u0005\u00025\u001f&\u0011\u0001+\u000e\u0002\u0005\u0019>tw-\u0001\u0004=S:LGO\u0010\u000b\u0006'R+fk\u0016\t\u0003_\u0001AQAM\u0003A\u0002MBQ!O\u0003A\u0002iBQAP\u0003A\u0002}BqAS\u0003\u0011\u0002\u0003\u00071*\u0001\ngS2,7\t\\3b]V\u0004H)\u001a7bs6\u001bX#\u0001(\u0002'\u0019LG.Z\"mK\u0006tW\u000f\u001d#fY\u0006LXj\u001d\u0011\u0002)%\u001cH)\u001a7fi&tw-\u0012=qSJ,G\rT8h+\u0005i\u0006C\u0001\u001b_\u0013\tyVGA\u0004C_>dW-\u00198\u0002+%\u001cH)\u001a7fi&tw-\u0012=qSJ,G\rT8hA\u00051B-\u001a4bk2$8i\\7qC\u000e$\u0018J\u001c;feZ\fG.F\u00014\u0003]!WMZ1vYR\u001cu.\u001c9bGRLe\u000e^3sm\u0006d\u0007%A\u0006sKR,g\u000e^5p]6\u001b\u0018\u0001\u0004:fi\u0016tG/[8o\u001bN\u0004\u0013\u0001D:i_VdGMU3uC&tGcA/iU\")\u0011N\u0004a\u0001]\u0005\u0019An\\4\t\u000b-t\u0001\u0019\u0001(\u0002\u0017\r,(O]3oiRKW.Z\u0001\u0012\r&dWm\u0015;sK\u0006l7+\u001b8l\u0019><\u0007CA\u0018\u0011'\t\u0001r\u000e\u0005\u00025a&\u0011\u0011/\u000e\u0002\u0007\u0003:L(+\u001a4\u0015\u00035\fqAV#S'&{e*\u0001\u0005W\u000bJ\u001b\u0016j\u0014(!\u0003)\tE\tR0B\u0007RKuJT\u000b\u0002oB\u0011\u00010`\u0007\u0002s*\u0011!p_\u0001\u0005Y\u0006twMC\u0001}\u0003\u0011Q\u0017M^1\n\u0005!K\u0018aC!E\t~\u000b5\tV%P\u001d\u0002\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"TCAA\u0002U\rY\u0015QA\u0016\u0003\u0003\u000f\u0001B!!\u0003\u0002\u00145\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011C\u001b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0016\u0005-!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class FileStreamSinkLog
extends CompactibleFileStreamLog<SinkFileStatus> {
    private final long fileCleanupDelayMs;
    private final boolean isDeletingExpiredLog;
    private final int defaultCompactInterval;
    private final long retentionMs;

    public static Option<Object> $lessinit$greater$default$4() {
        return FileStreamSinkLog$.MODULE$.$lessinit$greater$default$4();
    }

    public static String ADD_ACTION() {
        return FileStreamSinkLog$.MODULE$.ADD_ACTION();
    }

    public static int VERSION() {
        return FileStreamSinkLog$.MODULE$.VERSION();
    }

    @Override
    public long fileCleanupDelayMs() {
        return this.fileCleanupDelayMs;
    }

    @Override
    public boolean isDeletingExpiredLog() {
        return this.isDeletingExpiredLog;
    }

    @Override
    public int defaultCompactInterval() {
        return this.defaultCompactInterval;
    }

    public long retentionMs() {
        return this.retentionMs;
    }

    @Override
    public boolean shouldRetain(SinkFileStatus log, long currentTime) {
        if (this.retentionMs() < Long.MAX_VALUE) {
            if (currentTime - log.modificationTime() > this.retentionMs()) {
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> log.path() + " excluded by retention - current time: " + currentTime + " / modification time: " + log.modificationTime() + " / retention: " + this.retentionMs() + " ms.");
                return false;
            }
            return true;
        }
        return true;
    }

    public FileStreamSinkLog(int metadataLogVersion, SparkSession sparkSession, String path, Option<Object> _retentionMs) {
        super(metadataLogVersion, sparkSession, path, ClassTag$.MODULE$.apply(SinkFileStatus.class));
        long l;
        this.fileCleanupDelayMs = sparkSession.sessionState().conf().fileSinkLogCleanupDelay();
        this.isDeletingExpiredLog = sparkSession.sessionState().conf().fileSinkLogDeletion();
        this.defaultCompactInterval = sparkSession.sessionState().conf().fileSinkLogCompactInterval();
        Predef$.MODULE$.require(this.defaultCompactInterval() > 0, (Function0 & Serializable)() -> "Please set " + SQLConf$.MODULE$.FILE_SINK_LOG_COMPACT_INTERVAL().key() + " (was " + this.defaultCompactInterval() + ") to a positive value.");
        Option<Object> option = _retentionMs;
        if (option instanceof Some) {
            Some some = (Some)option;
            long retention = BoxesRunTime.unboxToLong((Object)some.value());
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Retention is set to ", " ms"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.TIME_UNITS, BoxesRunTime.boxToLong((long)retention))}))));
            l = retention;
        } else {
            l = Long.MAX_VALUE;
        }
        this.retentionMs = l;
    }
}

